/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import io.datarouter.aws.sqs.SqsNodeFactory;
import io.datarouter.aws.sqs.group.SqsGroupNode;
import io.datarouter.aws.sqs.single.SqsNode;
import io.datarouter.bytes.Codec;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.EmptyDatabean;
import io.datarouter.model.key.EmptyDatabeanKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.imp.BlobQueueClientNodeFactory;
import io.datarouter.storage.client.imp.QueueClientNodeFactory;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.adapter.NodeAdapters;
import io.datarouter.storage.node.op.raw.BlobQueueStorage;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

@Singleton
public class SqsClientNodeFactory
implements QueueClientNodeFactory,
BlobQueueClientNodeFactory {
    @Inject
    private SqsNodeFactory sqsNodeFactory;
    @Inject
    private NodeAdapters nodeAdapters;

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createSingleQueueNode(NodeParams<PK, D, F> nodeParams) {
        SqsNode<PK, D, F> node = this.sqsNodeFactory.createSingleNode(nodeParams);
        return this.nodeAdapters.wrapQueueNode(node);
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createGroupQueueNode(NodeParams<PK, D, F> nodeParams) {
        SqsGroupNode<PK, D, F> node = this.sqsNodeFactory.createGroupNode(nodeParams);
        return this.nodeAdapters.wrapGroupQueueNode(node);
    }

    public <T> BlobQueueStorage.PhysicalBlobQueueStorageNode<T> createBlobQueueNode(NodeParams<EmptyDatabeanKey, EmptyDatabean, EmptyDatabean.EmptyDatabeanFielder> nodeParams, Codec<T, byte[]> codec) {
        BlobQueueStorage.PhysicalBlobQueueStorageNode<T> node = this.sqsNodeFactory.createBlobQueueNode(nodeParams, codec);
        return this.nodeAdapters.wrapBlobQueueNode(node);
    }
}

