/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.blob.SqsBlobNode;
import io.datarouter.aws.sqs.blob.op.SqsBlobAckOp;
import io.datarouter.aws.sqs.blob.op.SqsBlobPeekOp;
import io.datarouter.aws.sqs.blob.op.SqsBlobPutOp;
import io.datarouter.aws.sqs.op.SqsBlobOp;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.queue.RawBlobQueueMessage;

public class SqsBlobOpFactory {
    private final SqsBlobNode<?> node;
    private final SqsClientManager clientManager;
    private final ClientId clientId;

    public SqsBlobOpFactory(SqsBlobNode<?> node, SqsClientManager clientManager, ClientId clientId) {
        this.node = node;
        this.clientManager = clientManager;
        this.clientId = clientId;
    }

    public SqsBlobOp<Void> makePutOp(byte[] data, Config config) {
        return new SqsBlobPutOp(data, this.node.getMaxRawDataSize(), config, this.clientManager, this.clientId, this.getQueueUrl());
    }

    public SqsBlobOp<RawBlobQueueMessage> makePeekOp(Config config) {
        return new SqsBlobPeekOp(config, this.clientManager, this.clientId, this.getQueueUrl());
    }

    public SqsBlobOp<Void> makeAckOp(byte[] handle, Config config) {
        return new SqsBlobAckOp(handle, config, this.clientManager, this.clientId, this.getQueueUrl());
    }

    private String getQueueUrl() {
        return this.node.getQueueUrlAndName().get().queueUrl();
    }
}

