/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.blob.op;

import com.amazonaws.AbortedException;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsDataTooLargeException;
import io.datarouter.aws.sqs.op.SqsBlobOp;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.util.concurrent.UncheckedInterruptedException;
import java.util.List;

public class SqsBlobPutOp
extends SqsBlobOp<Void> {
    private final byte[] data;
    private final int maxRawDataSize;

    public SqsBlobPutOp(byte[] data, int maxRawDataSize, Config config, SqsClientManager sqsClientManager, ClientId clientId, String queueUrl) {
        super(sqsClientManager, clientId, config, queueUrl);
        this.data = data;
        this.maxRawDataSize = maxRawDataSize;
    }

    @Override
    protected Void run() {
        if (this.data.length > this.maxRawDataSize) {
            throw new SqsDataTooLargeException(List.of("a blob of size " + this.data.length));
        }
        SendMessageRequest request = new SendMessageRequest(this.queueUrl, SqsBlobOp.SQS_BLOB_BASE_64_CODEC.encode(this.data));
        try {
            this.sqsClientManager.getAmazonSqs(this.clientId).sendMessage(request);
        }
        catch (AbortedException e) {
            throw new UncheckedInterruptedException("", (Exception)((Object)e));
        }
        return null;
    }
}

