/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.blob;

import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsBlobOpFactory;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.model.util.CommonFieldSizes;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.config.properties.EnvironmentName;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.BlobQueueStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.queue.BlobQueueMessage;
import io.datarouter.storage.queue.BlobQueueMessageDto;
import io.datarouter.storage.queue.BlobQueueMessageKey;
import io.datarouter.util.singletonsupplier.SingletonSupplier;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.tuple.Twin;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqsBlobNode
extends BasePhysicalNode<BlobQueueMessageKey, BlobQueueMessage, BlobQueueMessage.BlobQueueMessageFielder>
implements BlobQueueStorage.PhysicalBlobQueueStorageNode {
    private static final Logger logger = LoggerFactory.getLogger(SqsBlobNode.class);
    private final NodeParams<BlobQueueMessageKey, BlobQueueMessage, BlobQueueMessage.BlobQueueMessageFielder> params;
    private final SqsClientManager sqsClientManager;
    private final EnvironmentName environmentName;
    private final ServiceName serviceName;
    private final ClientId clientId;
    private final boolean owned;
    private final Supplier<Twin<String>> queueUrlAndName;
    private final SqsBlobOpFactory opFactory;

    public SqsBlobNode(NodeParams<BlobQueueMessageKey, BlobQueueMessage, BlobQueueMessage.BlobQueueMessageFielder> params, ClientType<?, ?> clientType, SqsClientManager sqsClientManager, EnvironmentName environmentName, ServiceName serviceName) {
        super(params, clientType);
        this.params = params;
        this.sqsClientManager = sqsClientManager;
        this.environmentName = environmentName;
        this.serviceName = serviceName;
        this.clientId = params.getClientId();
        this.owned = params.getQueueUrl() == null;
        this.queueUrlAndName = SingletonSupplier.of(this::getOrCreateQueueUrl);
        this.opFactory = new SqsBlobOpFactory(this, sqsClientManager, this.clientId);
    }

    private Twin<String> getOrCreateQueueUrl() {
        String queueName;
        String queueUrl;
        if (!this.owned) {
            queueUrl = this.params.getQueueUrl();
            queueName = queueUrl.substring(queueUrl.lastIndexOf(47) + 1);
        } else {
            queueName = this.buildQueueName(this.environmentName.get(), this.serviceName.get());
            queueUrl = this.createQueueAndGetUrl(queueName);
            this.sqsClientManager.updateAttr(this.clientId, queueUrl, QueueAttributeName.MessageRetentionPeriod, BaseSqsNode.RETENTION_S);
            logger.warn("retention updated queueName=" + queueName);
        }
        logger.warn("nodeName={}, queueUrl={}", (Object)this.getName(), (Object)queueUrl);
        return new Twin((Object)queueUrl, (Object)queueName);
    }

    private String createQueueAndGetUrl(String queueName) {
        CreateQueueRequest createQueueRequest = new CreateQueueRequest(queueName);
        try {
            return this.sqsClientManager.getAmazonSqs(this.clientId).createQueue(createQueueRequest).getQueueUrl();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("queueName=" + queueName + " queueNameLength=" + queueName.length(), e);
        }
    }

    public String buildQueueName(String environmentName, String serviceName) {
        String queueName;
        String namespace = this.params.getNamespace().orElseGet(() -> String.valueOf(environmentName) + "-" + serviceName);
        String tableName = this.getFieldInfo().getTableName();
        String string = queueName = StringTool.isEmpty((String)namespace) ? tableName : String.valueOf(namespace) + "-" + tableName;
        if (queueName.length() > 80) {
            logger.error("queue={} overflows the max size {}", (Object)queueName, (Object)80);
        }
        return queueName;
    }

    public Supplier<Twin<String>> getQueueUrlAndName() {
        return this.queueUrlAndName;
    }

    public int getMaxDataSize() {
        return CommonFieldSizes.MAX_SQS_SIZE;
    }

    public void put(byte[] data, Config config) {
        this.opFactory.makePutOp(data, config).call();
    }

    public Optional<BlobQueueMessageDto> peek(Config config) {
        return Optional.ofNullable(this.opFactory.makePeekOp(config).call());
    }

    public void ack(byte[] handle, Config config) {
        this.opFactory.makeAckOp(handle, config).call();
    }
}

