/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import io.datarouter.aws.sqs.SqsNodeFactory;
import io.datarouter.aws.sqs.group.SqsGroupNode;
import io.datarouter.aws.sqs.single.SqsNode;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.imp.BlobQueueClientNodeFactory;
import io.datarouter.storage.client.imp.QueueClientNodeFactory;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.adapter.NodeAdapters;
import io.datarouter.storage.node.op.raw.BlobQueueStorage;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.storage.queue.BlobQueueMessage;
import io.datarouter.storage.queue.BlobQueueMessageKey;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SqsClientNodeFactory
implements QueueClientNodeFactory,
BlobQueueClientNodeFactory {
    @Inject
    private SqsNodeFactory sqsNodeFactory;
    @Inject
    private NodeAdapters nodeAdapters;

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createSingleQueueNode(NodeParams<PK, D, F> nodeParams) {
        SqsNode<PK, D, F> node = this.sqsNodeFactory.createSingleNode(nodeParams);
        return this.nodeAdapters.wrapQueueNode(node);
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createGroupQueueNode(NodeParams<PK, D, F> nodeParams) {
        SqsGroupNode<PK, D, F> node = this.sqsNodeFactory.createGroupNode(nodeParams);
        return this.nodeAdapters.wrapGroupQueueNode(node);
    }

    public BlobQueueStorage.PhysicalBlobQueueStorageNode createBlobQueueNode(NodeParams<BlobQueueMessageKey, BlobQueueMessage, BlobQueueMessage.BlobQueueMessageFielder> nodeParams) {
        BlobQueueStorage.PhysicalBlobQueueStorageNode node = this.sqsNodeFactory.createBlobQueueNode(nodeParams);
        return this.nodeAdapters.wrapBlobQueueNode(node);
    }
}

