/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.launchers.http;

import io.datakernel.bytebuf.ByteBuf;
import io.datakernel.bytebuf.ByteBufStrings;
import io.datakernel.config.Config;
import io.datakernel.config.ConfigConverter;
import io.datakernel.config.ConfigConverters;
import io.datakernel.config.ConfigModule;
import io.datakernel.di.annotation.Inject;
import io.datakernel.di.annotation.Optional;
import io.datakernel.di.annotation.Provides;
import io.datakernel.di.core.Key;
import io.datakernel.di.module.AbstractModule;
import io.datakernel.di.module.Module;
import io.datakernel.di.module.Modules;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.eventloop.EventloopInspector;
import io.datakernel.eventloop.ThrottlingController;
import io.datakernel.http.AsyncHttpServer;
import io.datakernel.http.AsyncServlet;
import io.datakernel.http.HttpResponse;
import io.datakernel.jmx.JmxModule;
import io.datakernel.launcher.Launcher;
import io.datakernel.launcher.OnStart;
import io.datakernel.launchers.initializers.Initializers;
import io.datakernel.service.ServiceGraphModule;
import java.net.InetSocketAddress;
import java.util.Properties;
import java.util.concurrent.CompletionStage;

public abstract class HttpServerLauncher
extends Launcher {
    public static final String PROPERTIES_FILE = "http-server.properties";
    public static final String BUSINESS_MODULE_PROP = "businessLogicModule";
    @Inject
    AsyncHttpServer httpServer;

    @Provides
    Eventloop eventloop(Config config, @Optional ThrottlingController throttlingController) {
        return (Eventloop)((Eventloop)Eventloop.create().initialize(Initializers.ofEventloop((Config)config.getChild("eventloop")))).initialize(eventloop -> eventloop.withInspector((EventloopInspector)throttlingController));
    }

    @Provides
    AsyncHttpServer server(Eventloop eventloop, AsyncServlet rootServlet, Config config) {
        return (AsyncHttpServer)AsyncHttpServer.create((Eventloop)eventloop, (AsyncServlet)rootServlet).initialize(Initializers.ofHttpServer((Config)config.getChild("http")));
    }

    @Provides
    Config config() {
        return Config.create().with("http.listenAddresses", Config.ofValue((ConfigConverter)ConfigConverters.ofInetSocketAddress(), (Object)new InetSocketAddress(8080))).overrideWith(Config.ofClassPathProperties((String)PROPERTIES_FILE, (boolean)true)).overrideWith(Config.ofProperties((Properties)System.getProperties()).getChild("config"));
    }

    protected final Module getModule() {
        return Modules.combine((Module[])new Module[]{ServiceGraphModule.create(), JmxModule.create(), ConfigModule.create().printEffectiveConfig().rebindImport((Key)new Key<CompletionStage<Void>>(){}, (Key)new Key<CompletionStage<Void>>(OnStart.class){}), this.getBusinessLogicModule()});
    }

    protected Module getBusinessLogicModule() {
        return Module.empty();
    }

    protected void run() throws Exception {
        this.logger.info("HTTP Server is now available at " + String.join((CharSequence)", ", this.httpServer.getHttpAddresses()));
        this.awaitShutdown();
    }

    public static void main(String[] args) throws Exception {
        String businessLogicModuleName = System.getProperty(BUSINESS_MODULE_PROP);
        AbstractModule businessLogicModule = businessLogicModuleName != null ? (Module)Class.forName(businessLogicModuleName).newInstance() : new AbstractModule(){

            @Provides
            public AsyncServlet servlet(Config config) {
                String message = config.get("message", "Hello, world!");
                return request -> HttpResponse.ok200().withBody(ByteBuf.wrapForReading((byte[])ByteBufStrings.encodeAscii((String)message)));
            }
        };
        HttpServerLauncher launcher = new HttpServerLauncher((Module)businessLogicModule){
            final /* synthetic */ Module val$businessLogicModule;
            {
                this.val$businessLogicModule = module;
            }

            @Override
            protected Module getBusinessLogicModule() {
                return this.val$businessLogicModule;
            }
        };
        launcher.launch(args);
    }
}

