/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.gosu;

import cucumber.runtime.Argument;
import cucumber.runtime.JdkPatternArgumentMatcher;
import cucumber.runtime.ParameterInfo;
import cucumber.runtime.StepDefinition;
import gherkin.pickles.PickleStep;
import gw.lang.function.AbstractBlock;
import gw.lang.reflect.IType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class GosuStepDefinition
implements StepDefinition {
    private final Pattern pattern;
    private final StackTraceElement location;
    private final AbstractBlock block;
    private final JdkPatternArgumentMatcher argumentMatcher;
    private final List<ParameterInfo> parameterInfos;

    public GosuStepDefinition(Pattern pattern, AbstractBlock block, StackTraceElement location) {
        this.block = block;
        this.pattern = pattern;
        this.location = location;
        this.argumentMatcher = new JdkPatternArgumentMatcher(pattern);
        this.parameterInfos = this.getParameterInfos();
    }

    private List<ParameterInfo> getParameterInfos() {
        IType[] parameterTypes = this.block.getFunctionType().getParameterTypes();
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(parameterTypes.length);
        for (IType parameterType : parameterTypes) {
            result.add(new ParameterInfo(String.class, null, null, null));
        }
        return result;
    }

    public List<Argument> matchedArguments(PickleStep step) {
        return this.argumentMatcher.argumentsFrom(step.getText());
    }

    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    public Integer getParameterCount() {
        return this.parameterInfos.size();
    }

    public ParameterInfo getParameterType(int n, Type argumentType) {
        return this.parameterInfos.get(n);
    }

    public void execute(String language, Object[] args) throws Throwable {
        this.block.invokeWithArgs(args);
    }

    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return this.location.getFileName().equals(stackTraceElement.getFileName());
    }

    public String getPattern() {
        return this.pattern.pattern();
    }

    public boolean isScenarioScoped() {
        return false;
    }
}

