/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.gosu;

import cucumber.runtime.Backend;
import cucumber.runtime.Glue;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.gosu.GlueSource;
import cucumber.runtime.gosu.GosuSnippet;
import cucumber.runtime.gosu.GosuStepDefinition;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.snippets.FunctionNameGenerator;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.pickles.PickleStep;
import gw.lang.function.AbstractBlock;
import java.util.List;
import java.util.regex.Pattern;

public class GosuBackend
implements Backend {
    public static GosuBackend instance;
    private final ResourceLoader resourceLoader;
    private final SnippetGenerator snippetGenerator = new SnippetGenerator((Snippet)new GosuSnippet());
    private Glue glue;

    public GosuBackend(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        instance = this;
    }

    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        GlueSource source = new GlueSource();
        for (String gluePath : gluePaths) {
            for (Resource glueScript : this.resourceLoader.resources(gluePath, ".gsp")) {
                source.addGlueScript(glueScript);
            }
        }
    }

    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    public void buildWorld() {
    }

    public void disposeWorld() {
    }

    public String getSnippet(PickleStep step, String keyword, FunctionNameGenerator functionNameGenerator) {
        return this.snippetGenerator.getSnippet(step, keyword, functionNameGenerator);
    }

    public void addStepDefinition(String regexp, Object body) {
        AbstractBlock block = (AbstractBlock)body;
        this.glue.addStepDefinition((StepDefinition)new GosuStepDefinition(Pattern.compile(regexp), block, GosuBackend.currentLocation()));
    }

    private static StackTraceElement currentLocation() {
        StackTraceElement[] stackTraceElements;
        Throwable t = new Throwable();
        for (StackTraceElement stackTraceElement : stackTraceElements = t.getStackTrace()) {
            if (!GosuBackend.isGosuFile(stackTraceElement.getFileName())) continue;
            return stackTraceElement;
        }
        throw new RuntimeException("Couldn't find location for step definition");
    }

    private static boolean isGosuFile(String fileName) {
        return fileName != null && fileName.endsWith(".gsp");
    }
}

