/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.j4c;

import cronapp.reports.j4c.commons.J4CUtils;
import java.io.Serializable;

public class J4CParameter
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private String type;
    private Object value;

    public J4CParameter() {
        this.name = "";
        this.type = String.class.getName();
        this.value = "";
    }

    public J4CParameter(String name, String type) {
        this.name = name;
        this.type = type;
        this.value = J4CUtils.defaultValueBy(type);
    }

    public J4CParameter(String name, String type, Object value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public J4CParameter(String name, String description, String type, Object value) {
        this.name = name;
        this.type = type;
        this.value = value;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getValue() {
        return J4CUtils.checkValue(this.type, this.value);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        J4CParameter that = (J4CParameter)o;
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return "J4CParameter{name='" + this.name + '\'' + '}';
    }

    public J4CParameter clone() {
        try {
            return (J4CParameter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatJPQL(String parameter) {
        return parameter.replace("$P{", ":").replace("}", "");
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

