/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.bpm.identity.plugin.support;

import cronapp.framework.api.ApiManager;
import io.cronapp.bpm.identity.plugin.support.query.CronGroupQuery;
import io.cronapp.bpm.identity.plugin.support.query.CronTenantQuery;
import io.cronapp.bpm.identity.plugin.support.query.CronUserQuery;
import io.cronapp.bpm.identity.plugin.support.service.GroupService;
import io.cronapp.bpm.identity.plugin.support.service.UserService;
import io.cronapp.bpm.identity.plugin.support.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.NativeUserQuery;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;

public class CronIdentityProvider
implements ReadOnlyIdentityProvider {
    private static final String ANONYMOUS_USER = "anonymousUser";

    public User findUserById(String userId) {
        return (User)this.createUserQuery(Context.getCommandContext()).userId(userId).singleResult();
    }

    public UserQuery createUserQuery() {
        return new CronUserQuery(this.getCommandExecutor(), this);
    }

    public UserQuery createUserQuery(CommandContext commandContext) {
        return new CronUserQuery(this);
    }

    public NativeUserQuery createNativeUserQuery() {
        throw new BadUserRequestException("Native user queries are not supported for Cronapp identity service provider.");
    }

    public long findUserCountByQueryCriteria(CronUserQuery query) {
        return this.findUserByQueryCriteria(query).size();
    }

    public List<User> findUserByQueryCriteria(CronUserQuery query) {
        try {
            List<Object> users = StringUtils.isNotEmpty((CharSequence)query.getId()) ? this.getSingleUser(query.getId()) : UserService.getInstance().listUsers();
            if (StringUtils.isNotEmpty((CharSequence)query.getGroupId())) {
                users = users.stream().filter(user -> ApiManager.byUser((String)user.getUsername()).getRoles().contains(query.getGroupId())).collect(Collectors.toList());
            }
            return Utils.transformUsers(users);
        }
        catch (Exception ignored) {
            return Collections.emptyList();
        }
    }

    public boolean checkPassword(String userId, String password) {
        if (this.checkCredentialsIsEmpty(userId, password)) {
            return false;
        }
        ApiManager apiManager = ApiManager.byUserAndPassword((String)userId, (String)password);
        try {
            cronapp.framework.api.User user = apiManager.getUser();
            return user != null && apiManager.passwordMatches((CharSequence)password, user.getPassword());
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public Group findGroupById(String groupId) {
        return (Group)this.createGroupQuery(Context.getCommandContext()).groupId(groupId).singleResult();
    }

    public GroupQuery createGroupQuery() {
        return new CronGroupQuery(this.getCommandExecutor(), this);
    }

    public GroupQuery createGroupQuery(CommandContext commandContext) {
        return new CronGroupQuery(this);
    }

    public long findGroupCountByQueryCriteria(CronGroupQuery query) {
        return this.findGroupByQueryCriteria(query).size();
    }

    public List<Group> findGroupByQueryCriteria(CronGroupQuery query) {
        try {
            Collection roles = StringUtils.isNotEmpty((CharSequence)query.getUserId()) ? ApiManager.byUser((String)query.getUserId()).getRoles() : GroupService.getInstance().listRoles();
            if (StringUtils.isNotEmpty((CharSequence)query.getId())) {
                roles.removeIf(role -> !role.equals(query.getId()));
            }
            return Utils.transformGroups(roles);
        }
        catch (Exception ignored) {
            return Collections.emptyList();
        }
    }

    public Tenant findTenantById(String tenantId) {
        return null;
    }

    public TenantQuery createTenantQuery() {
        return new CronTenantQuery(this.getCommandExecutor());
    }

    public TenantQuery createTenantQuery(CommandContext commandContext) {
        return new CronTenantQuery();
    }

    public void flush() {
    }

    public void close() {
    }

    private CommandExecutor getCommandExecutor() {
        return Context.getProcessEngineConfiguration().getCommandExecutorTxRequired();
    }

    private boolean checkCredentialsIsEmpty(String userId, String password) {
        return userId == null || userId.isEmpty() || password == null || password.isEmpty();
    }

    private List<cronapp.framework.api.User> getSingleUser(String username) throws Exception {
        cronapp.framework.api.User user = ANONYMOUS_USER.equals(username) ? new cronapp.framework.api.User(username) : ApiManager.byUser((String)username).getUser();
        if (user == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(user);
    }
}

