/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.bpm.identity.plugin.support.service;

import cronapi.Var;
import cronapi.database.DataSource;
import cronapi.util.SecurityUtil;
import cronapp.framework.api.EventsManager;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;

public class GroupService {
    private static final String EVENT_NAME = "onGetRoles";

    private GroupService() {
    }

    public static GroupService getInstance() {
        return new GroupService();
    }

    public Collection<String> listRoles() {
        LinkedHashSet<String> roles;
        if (EventsManager.hasEvent((String)EVENT_NAME)) {
            Var roleResult = EventsManager.executeEventOnTransaction((String)EVENT_NAME, (Var[])new Var[0]);
            if (roleResult.getType() == Var.Type.NULL) {
                return Collections.emptyList();
            }
            roles = new LinkedHashSet<String>();
            if (roleResult.getType() == Var.Type.LIST || roleResult.getObject() instanceof DataSource) {
                for (Object role2 : roleResult.getObjectAsList()) {
                    roles.add(Var.valueOf(role2).getObjectAsString());
                }
            } else {
                roles.add(roleResult.getObjectAsString());
            }
        } else {
            roles = (LinkedHashSet<String>)((Object)SecurityUtil.getRoles().stream().map(role -> role.id).collect(Collectors.toList()));
        }
        return roles;
    }
}

