/*
 * Decompiled with CFR 0.152.
 */
package cronapi.ocr;

import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.leptonica.PIX;
import org.bytedeco.leptonica.global.lept;
import org.bytedeco.tesseract.TessBaseAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@CronapiMetaData(categoryName="Ocr")
public final class Operations {
    private static final String TESSERACT_DATA_PATH = UUID.randomUUID().toString();
    private static final String TESSERACT_DATA_ZIPPED = "classpath:tessdata.zip";
    private static final Logger logger = LoggerFactory.getLogger(Operations.class);

    @CronapiMetaData(type="function", name="{{getTextFromFile}}", description="{{getTextFromFileDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var getTextFromFile(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{language}}", blockType="util_dropdown", keys={"eng", "por"}) Var language, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{file}}") Var fileRef) throws Exception {
        String textString = "";
        if (language == null || language.isEmptyOrNull().booleanValue()) {
            language = new Var((Object)"por");
        }
        if (fileRef != null && !fileRef.isEmptyOrNull().booleanValue()) {
            TessBaseAPI api = Operations.loadAPI(language.getObjectAsString());
            try {
                File file = null;
                if (fileRef.getObject() instanceof FileInputStream) {
                    FileInputStream fis = (FileInputStream)fileRef.getObject();
                    Field field = fis.getClass().getDeclaredField("path");
                    field.setAccessible(true);
                    String path = (String)field.get(fis);
                    file = new File(path);
                } else {
                    file = fileRef.getObject() instanceof File ? (File)fileRef.getObject() : fileRef.getObjectAsFile();
                }
                if (!file.exists() || api == null) {
                    throw new FileNotFoundException("File not found!");
                }
                if (Operations.isPdfFile(file)) {
                    PDDocument document = PDDocument.load((File)file);
                    PDFRenderer pdfRenderer = new PDFRenderer(document);
                    BufferedImage bufferedImage = pdfRenderer.renderImageWithDPI(0, 300.0f);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage, "png", baos);
                    baos.flush();
                    byte[] imageBytes = baos.toByteArray();
                    baos.close();
                    BytePointer imageData = new BytePointer(imageBytes);
                    PIX pixImage = lept.pixReadMemPng((BytePointer)imageData, (long)imageBytes.length);
                    if (pixImage != null) {
                        api.SetImage(pixImage);
                        BytePointer outText = api.GetUTF8Text();
                        textString = outText.getString();
                        outText.deallocate();
                        lept.pixDestroy((PIX)pixImage);
                    }
                } else {
                    PIX image = lept.pixRead((String)file.getAbsolutePath());
                    if (image != null) {
                        api.SetImage(image);
                        BytePointer outText = api.GetUTF8Text();
                        textString = outText.getString();
                        outText.deallocate();
                        lept.pixDestroy((PIX)image);
                    }
                }
            }
            catch (Exception var16) {
                throw new RuntimeException("Error getting file ocr!");
            }
            finally {
                if (api != null) {
                    api.End();
                }
            }
            return new Var((Object)textString);
        }
        throw new FileNotFoundException("File not found!");
    }

    public static boolean isPdfFile(File file) {
        return file.isFile() && file.getName().toLowerCase().endsWith(".pdf");
    }

    private static TessBaseAPI loadAPI(String language) {
        TessBaseAPI api;
        block9: {
            api = null;
            try {
                int result;
                api = new TessBaseAPI();
                PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
                Resource resource = resourceResolver.getResource(TESSERACT_DATA_ZIPPED);
                if (!resource.exists()) break block9;
                String destFolder = cronapi.io.Operations.fileTempDir().getObjectAsString() + File.separator + TESSERACT_DATA_PATH;
                File tesseractPath = new File(destFolder);
                if (!tesseractPath.exists()) {
                    logger.info("Tesseract data path: " + tesseractPath.getAbsolutePath());
                    Path tempFile = Files.createTempFile(TESSERACT_DATA_PATH, ".zip", new FileAttribute[0]);
                    Files.copy(resource.getInputStream(), tempFile, StandardCopyOption.REPLACE_EXISTING);
                    try (FileInputStream fis = new FileInputStream(tempFile.toFile());){
                        cronapi.io.Operations.unZip((Var)Var.valueOf((Object)fis), (Var)Var.valueOf((Object)destFolder));
                    }
                }
                if ((result = api.Init(tesseractPath.getAbsolutePath(), language)) != 0) {
                    throw new RuntimeException("Error loading tesseract data!");
                }
                return api;
            }
            catch (Exception ex) {
                throw new RuntimeException("Error loading tesseract data!");
            }
        }
        return api;
    }
}

