/*
 * Decompiled with CFR 0.152.
 */
package cronapi.odata.server;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import cronapi.AppConfig;
import cronapi.QueryManager;
import cronapi.RestClient;
import cronapi.Var;
import cronapi.database.DataSource;
import cronapi.odata.server.DatasourceExtension;
import cronapi.odata.server.JPAODataServiceFactory;
import cronapi.odata.server.commands.ConnectCommand;
import cronapi.util.Operations;
import io.cronapp.reverse.DiagramBuilder;
import io.cronapp.reverse.utils.ReverseEngineeringData;
import io.cronapp.util.JdbcUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.core.ODataContextImpl;
import org.apache.olingo.odata2.core.ODataPathSegmentImpl;
import org.apache.olingo.odata2.core.ODataRequestHandler;
import org.apache.olingo.odata2.core.PathInfoImpl;
import org.apache.olingo.odata2.core.servlet.RestUtil;
import org.apache.olingo.odata2.jpa.processor.core.factory.ODataJPAFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.metamodel.EntityTypeImpl;
import org.eclipse.persistence.jpa.Archive;
import org.springframework.data.domain.PageRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import picocli.CommandLine;

public class ODataAgent {
    private static final String ERROR_TEMPLATE = "<?xml version=\"1.0\" ?><error xmlns=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\"><code></code><message xml:lang=\"en\">{0}</message></error>";
    private static final int START_RESULT = 28;
    private static final int END_RESULT = 29;
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final String DEFAULT_READ_CHARSET = "utf-8";
    private static boolean BOUND = false;
    private static File CONTEXT_FILE;
    private static String ACTIVE_PROFILE;
    private static boolean IS_LOCAL;
    private static String INITIAL_CONTEXT_FACTORY;

    private static void cleanDuplicated(Document doc) {
        ArrayList<Node> allNodes = new ArrayList<Node>(doc.getDocumentElement().getChildNodes().getLength());
        for (int i = 0; i < doc.getDocumentElement().getChildNodes().getLength(); ++i) {
            Node node = doc.getDocumentElement().getChildNodes().item(i);
            allNodes.add(node);
        }
        HashSet<String> ids = new HashSet<String>();
        for (Node node : allNodes) {
            if (!(node instanceof Element)) continue;
            if (((Element)node).getTagName().equalsIgnoreCase("Profile")) {
                doc.getDocumentElement().removeChild(node);
                continue;
            }
            String name = ((Element)node).getAttribute("name");
            if (ids.contains(name)) {
                doc.getDocumentElement().removeChild(node);
                continue;
            }
            ids.add(name);
            if (!((Element)node).hasAttribute("profile")) continue;
            ((Element)node).removeAttribute("profile");
        }
    }

    private static void updateProfile(Document doc, String activeProfile) {
        ArrayList<Node> allNodes = new ArrayList<Node>(doc.getDocumentElement().getChildNodes().getLength());
        ArrayList<Node> removeNodes = new ArrayList<Node>(doc.getDocumentElement().getChildNodes().getLength());
        for (int i = 0; i < doc.getDocumentElement().getChildNodes().getLength(); ++i) {
            if (doc.getDocumentElement().getChildNodes().item(i) instanceof Element) {
                allNodes.add(doc.getDocumentElement().getChildNodes().item(i));
            }
            removeNodes.add(doc.getDocumentElement().getChildNodes().item(i));
        }
        for (Node node : removeNodes) {
            doc.getDocumentElement().removeChild(node);
        }
        Collections.sort(allNodes, (o1, o2) -> {
            if (o1 instanceof Element && o2 instanceof Element) {
                String profile1 = ((Element)o1).getAttribute("profile");
                String profile2 = ((Element)o2).getAttribute("profile");
                String tag1 = ((Element)o1).getTagName();
                String tag2 = ((Element)o2).getTagName();
                int score1 = 0;
                int score2 = 0;
                if ("resource".equalsIgnoreCase(tag1)) {
                    ++score1;
                }
                if ("resource".equalsIgnoreCase(tag2)) {
                    ++score2;
                }
                if (activeProfile.equalsIgnoreCase(profile1)) {
                    ++score1;
                }
                if (activeProfile.equalsIgnoreCase(profile2)) {
                    ++score2;
                }
                return Integer.compare(score2, score1);
            }
            return 0;
        });
        for (Node node : allNodes) {
            doc.getDocumentElement().appendChild(node);
        }
    }

    private static void bind() throws Exception {
        InitialContext context;
        BasicDataSource ds;
        String name;
        Node elem;
        int i;
        if (BOUND) {
            return;
        }
        BOUND = true;
        System.out.println("Binding " + CONTEXT_FILE.toString() + " - " + ACTIVE_PROFILE);
        File contextFile = CONTEXT_FILE;
        String activeProfile = ACTIVE_PROFILE;
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(contextFile);
        ODataAgent.updateProfile(doc, activeProfile);
        ODataAgent.cleanDuplicated(doc);
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate("//Resource", doc, XPathConstants.NODESET);
        HashSet<String> added = new HashSet<String>();
        for (i = 0; i < nodes.getLength(); ++i) {
            elem = nodes.item(i);
            name = elem.getAttributes().getNamedItem("name").getTextContent();
            if (added.contains(name)) continue;
            ds = ODataAgent.createDataSource(elem);
            context = new InitialContext();
            context.bind("java:comp/env/" + name, (Object)ds);
            added.add(name);
        }
        for (i = 0; i < nodes.getLength(); ++i) {
            elem = nodes.item(i);
            name = elem.getAttributes().getNamedItem("name").getTextContent();
            if (added.contains(name)) continue;
            ds = ODataAgent.createDataSource(elem);
            context = new InitialContext();
            context.bind("java:comp/env/" + name, (Object)ds);
            added.add(name);
        }
    }

    private static BasicDataSource createDataSource(Node elem) {
        BasicDataSource ds = new BasicDataSource();
        if (IS_LOCAL) {
            ds.setUrl(JdbcUtil.rewriteLocalhost((String)elem.getAttributes().getNamedItem("url").getTextContent()));
        } else {
            ds.setUrl(elem.getAttributes().getNamedItem("url").getTextContent());
        }
        ds.setDriverClassName(elem.getAttributes().getNamedItem("driverClassName").getTextContent());
        ds.setUsername(elem.getAttributes().getNamedItem("username").getTextContent());
        ds.setPassword(elem.getAttributes().getNamedItem("password").getTextContent());
        return ds;
    }

    private static String xmlEscapeText(String t) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < t.length(); ++i) {
            char c = t.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    if (c > '~') {
                        sb.append("&#").append((int)c).append(";");
                        continue block7;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static void sendError(String msg) {
        System.out.println();
        System.out.write(28);
        System.out.print(MessageFormat.format(ERROR_TEMPLATE, ODataAgent.xmlEscapeText(msg)));
        System.out.write(29);
        System.out.println();
    }

    private static List<SEPersistenceUnitInfo> getPersistenceUnits(Archive archive) {
        return PersistenceUnitProcessor.getPersistenceUnits((Archive)archive, (ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    private static EntityManagerFactory find(String pu) {
        Set archives = PersistenceUnitProcessor.findPersistenceArchives();
        for (Archive archive : archives) {
            List<SEPersistenceUnitInfo> persistenceUnitInfos = ODataAgent.getPersistenceUnits(archive);
            for (SEPersistenceUnitInfo pui : persistenceUnitInfos) {
                String namespace = pui.getPersistenceUnitName();
                if (pu != null && !namespace.equalsIgnoreCase(pu)) continue;
                Properties properties = pui.getProperties();
                properties.setProperty("eclipselink.ddl-generation", "none");
                return Persistence.createEntityManagerFactory((String)namespace, (Map)properties);
            }
        }
        return null;
    }

    private static synchronized void odata(String strPath) {
        try {
            String queryString = null;
            if (strPath.contains("?")) {
                String[] urlParts = strPath.split("\\?");
                queryString = urlParts[1];
                strPath = urlParts[0];
                RestClient.getRestClient().setParameters(queryString);
                RestClient.getRestClient().setQueryString(queryString);
            } else {
                RestClient.getRestClient().setParameters("");
            }
            RestClient.getRestClient().setMethod("GET");
            String[] parts = strPath.split("/");
            String pu = parts[0];
            Set archives = PersistenceUnitProcessor.findPersistenceArchives();
            boolean found = false;
            int idx = 0;
            for (Archive archive : archives) {
                List<SEPersistenceUnitInfo> persistenceUnitInfos = ODataAgent.getPersistenceUnits(archive);
                persistenceUnitInfos.sort((p1, p2) -> {
                    if (p1.getPersistenceUnitName().equals("app")) {
                        return -1;
                    }
                    if (p2.getPersistenceUnitName().equals("app")) {
                        return 1;
                    }
                    return p1.getPersistenceUnitName().compareTo(p2.getPersistenceUnitName());
                });
                for (SEPersistenceUnitInfo pui : persistenceUnitInfos) {
                    String namespace = pui.getPersistenceUnitName();
                    if (pu != null && !namespace.equalsIgnoreCase(pu)) continue;
                    found = true;
                    Properties properties = pui.getProperties();
                    properties.setProperty("eclipselink.ddl-generation", "none");
                    if (strPath.contains("$metadata")) {
                        properties.setProperty("jakarta.persistence.jdbc.driver", "org.h2.Driver");
                        properties.setProperty("jakarta.persistence.jdbc.url", "jdbc:h2:mem:default");
                        properties.setProperty("jakarta.persistence.nonJtaDataSource", "");
                    }
                    JPAODataServiceFactory serviceFactory = new JPAODataServiceFactory(namespace, idx, properties);
                    ++idx;
                    LinkedList<ODataPathSegmentImpl> odataPathSegment = new LinkedList<ODataPathSegmentImpl>();
                    for (int i = 1; i < parts.length; ++i) {
                        odataPathSegment.add(new ODataPathSegmentImpl(parts[i], new LinkedHashMap()));
                    }
                    PathInfoImpl path = new PathInfoImpl();
                    path.setODataPathSegment(odataPathSegment);
                    path.setServiceRoot(new URI("file:///local/"));
                    path.setRequestUri(new URI("file:///local/" + strPath));
                    ByteArrayInputStream ip = new ByteArrayInputStream(new byte[0]);
                    ODataRequest odataRequest = ODataRequest.method((ODataHttpMethod)ODataHttpMethod.GET).httpMethod("GET").contentType(RestUtil.extractRequestContentType(null).toContentTypeString()).acceptHeaders(RestUtil.extractAcceptHeaders((String)"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8")).acceptableLanguages(RestUtil.extractAcceptableLanguage((String)"en-US")).pathInfo((PathInfo)path).allQueryParameters(RestUtil.extractAllQueryParameters((String)queryString, null)).requestHeaders(new HashMap()).body((InputStream)ip).build();
                    ODataContextImpl context = new ODataContextImpl(odataRequest, (ODataServiceFactory)serviceFactory);
                    ODataService service = serviceFactory.createService((ODataContext)context);
                    context.setService(service);
                    service.getProcessor().setContext((ODataContext)context);
                    String jpql = RestClient.getRestClient().getParameter("jpql");
                    boolean isNative = "true".equalsIgnoreCase(RestClient.getRestClient().getParameter("native"));
                    if (jpql != null && !jpql.isEmpty()) {
                        ((DatasourceExtension)serviceFactory.getODataJPAContext().getJPAEdmExtension()).jpql(jpql, isNative);
                    }
                    ODataRequestHandler requestHandler = new ODataRequestHandler((ODataServiceFactory)serviceFactory, service, (ODataContext)context);
                    ODataResponse odataResponse = requestHandler.handle(odataRequest);
                    Object entity = odataResponse.getEntity();
                    System.out.println();
                    System.out.write(28);
                    if (entity != null) {
                        if (entity instanceof InputStream) {
                            ODataAgent.handleStream((InputStream)entity);
                        } else if (entity instanceof String) {
                            String body = (String)entity;
                            byte[] entityBytes = body.getBytes(DEFAULT_READ_CHARSET);
                            System.out.write(entityBytes);
                        } else {
                            System.out.print("Illegal entity object in ODataResponse of type '" + String.valueOf(entity.getClass()) + "'");
                        }
                    }
                    System.out.write(29);
                    System.out.println();
                }
            }
            if (!found) {
                ODataAgent.sendError("No persistence provided found!");
            }
        }
        catch (Exception e) {
            ODataAgent.sendError(e.getMessage());
        }
    }

    private static void handleStream(InputStream stream) throws IOException {
        byte[] buffer = new byte[32768];
        try (InputStream closeableStream = stream;){
            int len;
            while ((len = closeableStream.read(buffer)) != -1) {
                System.out.write(buffer, 0, len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void datasource(String strPath) {
        EntityManager entityManager = null;
        try {
            if (strPath.contains("?")) {
                String[] urlParts = strPath.split("\\?");
                strPath = urlParts[0];
                String queryString = urlParts[1];
                RestClient.getRestClient().setParameters(queryString);
            } else {
                RestClient.getRestClient().setParameters("");
            }
            String[] parts = strPath.split("/");
            String pu = parts[0];
            EntityManagerFactory factory = ODataAgent.find(pu);
            entityManager = Objects.requireNonNull(factory).createEntityManager();
            PageRequest p = PageRequest.of((int)RestClient.getRestClient().getParameterAsInt("$skip", 0), (int)RestClient.getRestClient().getParameterAsInt("$top", 100));
            DataSource ds = new DataSource(((EntityTypeImpl)entityManager.getMetamodel().getEntities().toArray()[0]).getJavaTypeName(), entityManager);
            ds.disableMultiTenant();
            ds.setUseUrlParams(true);
            ds.setPlainData(RestClient.getRestClient().getParameterAsBoolean("plain", true));
            ds.filter(RestClient.getRestClient().getParameter("jpql"), p, new Var[0]);
            System.out.println();
            System.out.write(28);
            Gson gson = new Gson();
            System.out.print(gson.toJson((Object)ds.getPage().getContent()));
            System.out.write(29);
            System.out.println();
        }
        catch (Exception e) {
            ODataAgent.sendError(e.getMessage());
        }
        finally {
            if (entityManager != null && entityManager.isOpen()) {
                entityManager.close();
            }
        }
    }

    public static EdmEntityType getSchema(Map<String, Edm> schemas, String namespace, String source) {
        try {
            Edm schema;
            if (namespace == null) {
                for (Map.Entry<String, Edm> entry : schemas.entrySet()) {
                    for (EdmEntitySet entitySchema : entry.getValue().getEntitySets()) {
                        if (!entitySchema.getEntityType().getName().equals(source)) continue;
                        return entitySchema.getEntityType();
                    }
                }
            }
            if ((schema = schemas.get(namespace)) != null) {
                for (EdmEntitySet entitySchema : schema.getEntitySets()) {
                    if (!entitySchema.getEntityType().getName().equals(source)) continue;
                    return entitySchema.getEntityType();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Edm> getSchemas() {
        try {
            Set archives = PersistenceUnitProcessor.findPersistenceArchives();
            LinkedHashMap<String, Edm> result = new LinkedHashMap<String, Edm>();
            int i = -1;
            for (Archive archive : archives) {
                List persistenceUnitInfos = PersistenceUnitProcessor.getPersistenceUnits((Archive)archive, (ClassLoader)Thread.currentThread().getContextClassLoader());
                for (SEPersistenceUnitInfo pui : persistenceUnitInfos) {
                    String namespace = pui.getPersistenceUnitName();
                    JPAODataServiceFactory factory = new JPAODataServiceFactory(namespace, ++i);
                    ODataService service = factory.createService(factory.initializeODataJPAContext().getODataContext());
                    result.put(namespace, service.getEntityDataModel());
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        QueryManager.DISABLE_AUTH = true;
        AppConfig.FORCE_METADATA = true;
        AppConfig.FORCE_LOCAL_ENTITIES = true;
        Operations.IS_DEBUG = true;
        ODataJPAFactoryImpl.IS_DEBUG = true;
        ODataRequestHandler.PRINT_EXCEPTION = false;
        PrintStream errStream = System.err;
        System.setErr(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        }));
        try {
            Class.forName("SpringBootMain");
        }
        catch (ClassNotFoundException exception) {
            TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        }
        System.out.println("Starting CronApp Data Agent");
        ODataAgent.setupInitialContext();
        CONTEXT_FILE = new File(args[0]);
        ACTIVE_PROFILE = args[2];
        if (args.length > 3) {
            IS_LOCAL = Boolean.parseBoolean(args[3]);
        }
        QueryManager.loadJSONFromFile(new File(args[1]));
        Scanner scanner = new Scanner(System.in);
        scanner.useDelimiter(Pattern.compile("[\\n]+"));
        System.out.println("Waiting for commands...");
        while (true) {
            String input = scanner.next();
            QueryManager.JSON_CACHE.set(null);
            QueryManager.JSON_CACHE.remove();
            if (input.startsWith("error")) {
                System.setErr(errStream);
                ODataRequestHandler.PRINT_EXCEPTION = true;
                System.out.println("Err sent to printstream");
                continue;
            }
            if (input.startsWith("odata ")) {
                if (!input.contains("$metadata")) {
                    ODataAgent.bind();
                }
                ODataAgent.odata(input.substring(6).trim());
                continue;
            }
            if (input.startsWith("ds ")) {
                ODataAgent.bind();
                ODataAgent.datasource(input.substring(3).trim());
                continue;
            }
            if (input.startsWith("connect ")) {
                CommandLine connectCommand = new CommandLine((Object)new ConnectCommand());
                connectCommand.execute(input.split("\\s+"));
                continue;
            }
            if (input.startsWith("reverse ")) {
                ODataAgent.reverse(input.substring(8).trim());
                continue;
            }
            ODataAgent.sendError("Command not found!");
        }
    }

    private static void reverse(String command) {
        try {
            Gson gson = new Gson();
            ReverseEngineeringData data = (ReverseEngineeringData)gson.fromJson(command, ReverseEngineeringData.class);
            if (IS_LOCAL) {
                data.getContext().setUrl(JdbcUtil.rewriteLocalhost((String)data.getContext().getUrl()));
            }
            DiagramBuilder reverseBuilder = new DiagramBuilder(data);
            JsonObject json = reverseBuilder.getCellsFromResource();
            System.out.println();
            System.out.write(28);
            System.out.print(json.toString());
            System.out.write(29);
            System.out.println();
        }
        catch (Exception e) {
            ODataAgent.sendError(e.getMessage());
        }
    }

    private static void setupInitialContext() throws NamingException {
        if (System.getProperty(INITIAL_CONTEXT_FACTORY) != null) {
            return;
        }
        System.setProperty(INITIAL_CONTEXT_FACTORY, "org.apache.naming.java.javaURLContextFactory");
        new InitialContext().createSubcontext("java:comp").createSubcontext("env").createSubcontext("jdbc").close();
    }

    static {
        IS_LOCAL = false;
        INITIAL_CONTEXT_FACTORY = "java.naming.factory.initial";
    }
}

