/*
 * Decompiled with CFR 0.152.
 */
package cronapi.util;

import cronapi.QueryManager;
import cronapi.Var;
import cronapi.util.BlocklyParam;
import cronapi.util.Functions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class BlocklyInfo {
    public static Pattern BLOCKLY_CALL = Pattern.compile("cronapi\\.([^\\.]+)\\((.*?)\\)(\\.names\\((.*?)\\))?(\\.attr\\(\\))?\\.run\\((.*?)\\)");
    private String type;
    private String blocklyMethod;
    private String blocklyClass;
    private String blocklyLanguage;
    private List<BlocklyParam> blocklyParams = new ArrayList<BlocklyParam>();

    private String unquote(String str) {
        if (str.length() >= 2 && str.startsWith("\"") || str.startsWith("'")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public boolean load(String text, Object entity, Map<String, Var> customValues) {
        Matcher blocklyMatcher;
        if (text != null && !text.trim().isEmpty() && (blocklyMatcher = BLOCKLY_CALL.matcher(text)).matches()) {
            List<String> names;
            this.blocklyParams.clear();
            String blockly = this.unquote(blocklyMatcher.group(2).trim());
            Object[] parts = blockly.split("\\.");
            this.type = blocklyMatcher.group(1);
            this.blocklyMethod = parts[parts.length - 1];
            this.blocklyClass = StringUtils.join((Object[])parts, (String)".", (int)0, (int)(parts.length - 1));
            this.blocklyLanguage = "client".equals(this.type) ? "js" : "java";
            List<String> array = StringUtils.isNotBlank((CharSequence)blocklyMatcher.group(6)) ? Functions.parseArguments(blocklyMatcher.group(6).trim()) : null;
            List<String> list = names = StringUtils.isNotBlank((CharSequence)blocklyMatcher.group(4)) ? Functions.parseArguments(blocklyMatcher.group(4).trim()) : null;
            if (array != null) {
                int i = 0;
                for (String value : array) {
                    ++i;
                    BlocklyParam param = new BlocklyParam();
                    if (names != null && names.size() == array.size()) {
                        param.setName(names.get(i - 1));
                    }
                    if (!value.equals("null")) {
                        param.setValue(QueryManager.parseExpressionValue(entity, value, customValues));
                    }
                    this.blocklyParams.add(param);
                }
            }
            return true;
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBlocklyMethod() {
        return this.blocklyMethod;
    }

    public void setBlocklyMethod(String blocklyMethod) {
        this.blocklyMethod = blocklyMethod;
    }

    public String getBlocklyClass() {
        return this.blocklyClass;
    }

    public void setBlocklyClass(String blocklyClass) {
        this.blocklyClass = blocklyClass;
    }

    public void setParamValue(String key, Var value) {
        for (BlocklyParam param : this.blocklyParams) {
            if (!param.name.equals(key)) continue;
            param.value = value;
        }
    }

    public List<BlocklyParam> getBlocklyParams() {
        return this.blocklyParams;
    }

    public void setBlocklyParams(List<BlocklyParam> blocklyParams) {
        this.blocklyParams = blocklyParams;
    }

    public String getBlocklyLanguage() {
        return this.blocklyLanguage;
    }

    public void setBlocklyLanguage(String blocklyLanguage) {
        this.blocklyLanguage = blocklyLanguage;
    }

    public String toString() {
        Object result = "";
        if (this.getBlocklyClass() != null) {
            result = this.getBlocklyClass();
        }
        if (this.getBlocklyMethod() != null) {
            result = (String)result + (String)(((String)result).length() > 0 ? ":" + this.getBlocklyMethod() : this.getBlocklyMethod());
        }
        return result;
    }
}

