/*
 * Decompiled with CFR 0.152.
 */
package cronapi.swagger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.Map;

public class ParameterBodyDefinition {
    private LinkedHashMap<String, LinkedHashMap> content = new LinkedHashMap();
    private final String type;
    private Boolean required;

    @JsonIgnore
    public ParameterBodyDefinition(String type) {
        this.type = type;
        this.content.put(type, new LinkedHashMap());
        this.setDefaultProperties();
    }

    private void setDefaultProperties() {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("type", "object");
        schema.put("properties", new LinkedHashMap());
        this.content.get(this.type).put("schema", schema);
    }

    @JsonIgnore
    public void addProperty(String name, Map definition) {
        Map schema = (Map)this.content.get(this.type).get("schema");
        Map properties = (Map)schema.get("properties");
        properties.put(name, definition);
    }

    @JsonIgnore
    public Map getProperties() {
        Map schema = (Map)this.content.get(this.type).get("schema");
        Map properties = (Map)schema.get("properties");
        return properties;
    }

    @JsonIgnore
    public void addToMetadataReference(String entityLink) {
        LinkedHashMap<String, CallSite> schema = new LinkedHashMap<String, CallSite>();
        schema.put("$ref", (CallSite)((Object)("#/components/schemas/" + entityLink)));
        this.content.get(this.type).put("schema", schema);
    }

    public LinkedHashMap getContent() {
        return this.content;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean getRequired() {
        return this.required;
    }
}

