/*
 * Decompiled with CFR 0.152.
 */
package cronapi.pushnotification;

import cronapi.pushnotification.HeaderRequestInterceptor;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.springframework.http.HttpEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class FirebasePushNotificationService {
    private String FIREBASE_SERVER_KEY;
    private static final String FIREBASE_API_URL = "https://fcm.googleapis.com/fcm/send";
    private static final String FIREBASE_API_URL_V2 = "https://fcm.googleapis.com/v1/projects/";

    public FirebasePushNotificationService() {
    }

    public FirebasePushNotificationService(String serverKEY) {
        this.FIREBASE_SERVER_KEY = serverKEY;
    }

    @Async
    public CompletableFuture<String> send(HttpEntity<String> entity) {
        RestTemplate restTemplate = new RestTemplate();
        ArrayList<HeaderRequestInterceptor> interceptors = new ArrayList<HeaderRequestInterceptor>();
        interceptors.add(new HeaderRequestInterceptor("Authorization", "key=" + this.FIREBASE_SERVER_KEY));
        interceptors.add(new HeaderRequestInterceptor("Content-Type", "application/json"));
        restTemplate.setInterceptors(interceptors);
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(Charset.forName("UTF-8")));
        String firebaseResponse = (String)restTemplate.postForObject(FIREBASE_API_URL, entity, String.class, new Object[0]);
        return CompletableFuture.completedFuture(firebaseResponse);
    }

    public CompletableFuture<String> sendV2(HttpEntity<String> entity, String accessToken, String projectId) {
        String fcmUrl = FIREBASE_API_URL_V2 + projectId + "/messages:send";
        RestTemplate restTemplate = new RestTemplate();
        ArrayList<HeaderRequestInterceptor> interceptors = new ArrayList<HeaderRequestInterceptor>();
        interceptors.add(new HeaderRequestInterceptor("Authorization", "Bearer " + accessToken));
        interceptors.add(new HeaderRequestInterceptor("Content-Type", "application/json; UTF-8"));
        restTemplate.setInterceptors(interceptors);
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(Charset.forName("UTF-8")));
        try {
            String firebaseResponse = (String)restTemplate.postForObject(fcmUrl, entity, String.class, new Object[0]);
            return CompletableFuture.completedFuture(firebaseResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            return CompletableFuture.completedFuture("Erro: " + e.getMessage());
        }
    }
}

