/*
 * Decompiled with CFR 0.152.
 */
package cronapi.jdbc;

import cronapi.jdbc.DatabaseMetadata;
import cronapi.jdbc.FirebirdMetadata;
import cronapi.jdbc.MSSQLMetadata;
import cronapi.jdbc.MySQLMetadata;
import cronapi.jdbc.OracleMetadata;
import cronapi.jdbc.PostegreSQLMetadata;
import cronapi.jdbc.SQLAnsiMetadata;
import java.util.HashMap;
import java.util.Map;

public class DatabaseMetadataFactory {
    private static DatabaseMetadata DEFAULT_METADATA = new SQLAnsiMetadata();
    private static Map<String, DatabaseMetadata> METADATA = new HashMap<String, DatabaseMetadata>();

    public static DatabaseMetadata getMetadata(String provider) {
        if (provider.toLowerCase().contains("firebird")) {
            provider = "Firebird";
        }
        return METADATA.getOrDefault(provider, DEFAULT_METADATA);
    }

    static {
        METADATA.put("PostgreSQL", new PostegreSQLMetadata());
        METADATA.put("Microsoft SQL Server", new MSSQLMetadata());
        METADATA.put("Firebird", new FirebirdMetadata());
        METADATA.put("Oracle", new OracleMetadata());
        METADATA.put("MySQL", new MySQLMetadata());
    }
}

