/*
 * Decompiled with CFR 0.152.
 */
package cronapi.database;

import cronapi.Var;
import cronapi.database.TransactionManager;
import cronapi.jdbc.DatabaseMetadataFactory;
import cronapi.odata.server.JPQLParserUtil;
import cronapi.odata.server.NativeQueryUtils;
import cronapi.util.Functions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class NativeDatasource {
    private final EntityManager em;
    private String namespace;
    private Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    private List<String> params;
    private LinkedHashMap<Integer, String> mapping;
    private String metadataSQL;

    public NativeDatasource(String namespace) {
        this.namespace = namespace;
        this.em = TransactionManager.getEntityManager(namespace, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepare(Connection connection, String sql, Integer returnKeys) throws Exception {
        Integer version;
        PreparedStatement query;
        String database = connection.getMetaData().getDatabaseProductName();
        if (database.equalsIgnoreCase("Microsoft SQL Server")) {
            sql = sql.replace("\n", " ");
        }
        PreparedStatement metadataQuery = query = returnKeys != null ? connection.prepareStatement(sql, returnKeys) : connection.prepareStatement(sql);
        DBDictionary dictionary = DatabaseMetadataFactory.getMetadata(database).getDictionary(connection);
        if (database.equalsIgnoreCase("Microsoft SQL Server") && this.metadataSQL != null && (version = Integer.valueOf(connection.getMetaData().getDatabaseProductVersion().split("\\.")[0])) < 11) {
            metadataQuery = returnKeys != null ? connection.prepareStatement(this.metadataSQL.replace("\n", " "), returnKeys) : connection.prepareStatement(this.metadataSQL);
        }
        try {
            NativeQueryUtils.setQueryParams(this.params, this.mapping, dictionary, metadataQuery, query, this.parameters);
        }
        finally {
            if (metadataQuery != query) {
                metadataQuery.close();
            }
        }
        return query;
    }

    private String countSQL(Statement statement, Connection connection) throws Exception {
        PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
        select.setOrderByElements(List.of());
        this.metadataSQL = statement.toString();
        return DatabaseMetadataFactory.getMetadata(connection.getMetaData().getDatabaseProductName()).count(statement, connection);
    }

    private String limit(Statement statement, Connection connection, Pageable pageRequest) throws Exception {
        this.metadataSQL = statement.toString();
        if (((Select)statement).getSelectBody() instanceof SetOperationList) {
            String sqlToExecute = "select * from (" + statement + ") CRONAPP_ALIAS";
            statement = CCJSqlParserUtil.parse((String)sqlToExecute);
        }
        return DatabaseMetadataFactory.getMetadata(connection.getMetaData().getDatabaseProductName()).limit(statement, connection, pageRequest.getPageSize(), (int)pageRequest.getOffset());
    }

    private String convertSQL(String sql) {
        sql = sql.replace("::", "$$__$$");
        this.params = JPQLParserUtil.parseParams(sql, ':');
        this.mapping = new LinkedHashMap();
        int i = 0;
        for (String param : this.params) {
            sql = JPQLParserUtil.replaceToken(sql, ":" + param, "?");
            this.mapping.put(++i, param);
        }
        sql = sql.replace("$$__$$", "::");
        return sql;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Page query(String query, Pageable pageRequest, boolean isCount, Var ... params) {
        LinkedList resultsInPage = new LinkedList();
        try {
            if (!this.em.getTransaction().isActive()) {
                this.em.getTransaction().begin();
            }
            String sqlToExecute = this.convertSQL(query);
            Statement statement = CCJSqlParserUtil.parse((String)sqlToExecute);
            Connection connection = (Connection)this.em.unwrap(Connection.class);
            for (Var param : params) {
                this.parameters.put(param.getId(), param);
            }
            sqlToExecute = isCount ? this.countSQL(statement, connection) : this.limit(statement, connection, pageRequest);
            try (PreparedStatement ps = this.prepare(connection, sqlToExecute, null);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    if (isCount) {
                        PageImpl pageImpl = new PageImpl(List.of(Long.valueOf(rs.getLong("CRONAPP_COUNT"))), pageRequest, 0L);
                        return pageImpl;
                    }
                    LinkedHashMap<String, Var> map = new LinkedHashMap<String, Var>();
                    for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                        Object name = rs.getMetaData().getColumnName(i);
                        if (StringUtils.isBlank((CharSequence)name)) {
                            name = "column";
                        }
                        if (((String)name).contains("(") && StringUtils.isBlank((CharSequence)(name = ((String)name).substring(0, ((String)name).indexOf("("))))) {
                            name = "expression";
                        }
                        if (!Functions.isValidIdentifier((String)name)) {
                            name = "expression";
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                        int j = 1;
                        while (map.containsKey(name)) {
                            name = rs.getMetaData().getColumnName(i) + "_" + ++j;
                        }
                        map.put((String)name, Var.valueOf(rs.getObject(i)));
                    }
                    resultsInPage.add(map);
                }
                return new PageImpl(resultsInPage, pageRequest, 0L);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> execute(String query, Var ... params) {
        try {
            if (!this.em.getTransaction().isActive()) {
                this.em.getTransaction().begin();
            }
            String sqlToExecute = this.convertSQL(query);
            Connection connection = (Connection)this.em.unwrap(Connection.class);
            for (Var param : params) {
                this.parameters.put(param.getId(), param);
            }
            try (PreparedStatement ps = this.prepare(connection, sqlToExecute, query.toLowerCase().trim().startsWith("insert") ? Integer.valueOf(1) : null);){
                int result = ps.executeUpdate();
                if (query.toLowerCase().trim().startsWith("insert")) {
                    LinkedHashMap<String, Object> map2 = new LinkedHashMap<String, Object>();
                    ResultSet keys = ps.getGeneratedKeys();
                    if (keys != null && keys.next()) {
                        for (int c = 1; c <= keys.getMetaData().getColumnCount(); ++c) {
                            map2.put(keys.getMetaData().getColumnName(c), keys.getObject(c));
                        }
                    }
                    LinkedHashMap<String, Object> linkedHashMap = map2;
                    return linkedHashMap;
                }
                Map<String, Object> map = Map.of("success", result);
                return map;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

