/*
 * Decompiled with CFR 0.152.
 */
package cronapi.odata.server.commands;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="connect", mixinStandardHelpOptions=true, description={"Get a connection from the sandbox container"})
public class ConnectCommand
implements Callable<Boolean> {
    @CommandLine.Parameters(index="0", description={"This field is mandatory when running command inside jre"})
    String connect;
    @CommandLine.Parameters(index="1", description={"The connection url"})
    String address;
    @CommandLine.Option(names={"--driver", "-d"}, description={"The connection driver class name"})
    String driverClassName;
    @CommandLine.Option(names={"--username", "-u"}, description={"The connection username"})
    String username;
    @CommandLine.Option(names={"--password", "-p"}, description={"The connection password"})
    String password;
    private final Logger logger = Logger.getLogger("General");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        Connection connection = null;
        boolean isConnected = false;
        try {
            Class.forName(this.driverClassName);
            connection = DriverManager.getConnection(this.address, this.username, this.password);
            isConnected = true;
            this.logger.log(Level.INFO, "Connection successful!");
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, "Connection failed!", e);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "JDBC driver not found!", e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                } else {
                    isConnected = false;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        System.out.println(isConnected);
        return isConnected;
    }
}

