/*
 * Decompiled with CFR 0.152.
 */
package cronapi.util;

import cronapi.AppConfig;
import cronapi.ClientCommand;
import cronapi.CronapiBeanConfigurator;
import cronapi.CronapiConfigurator;
import cronapi.CronapiMetaData;
import cronapi.CustomHttpClient;
import cronapi.ErrorResponse;
import cronapi.HttpWithBody;
import cronapi.ParamMetaData;
import cronapi.RestClient;
import cronapi.Var;
import cronapi.clazz.CronapiClassLoader;
import cronapi.database.DatabaseQueryManager;
import cronapi.database.HistoryListener;
import cronapi.i18n.Messages;
import cronapi.rest.DownloadREST;
import cronapi.rest.security.BlocklySecurity;
import cronapi.util.Callback;
import cronapi.util.ReflectionUtils;
import cronapp.framework.core.CronappConfiguration;
import cronapp.framework.core.CronappTokenManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

@CronapiMetaData(category=CronapiMetaData.CategoryType.UTIL, categoryTags={"Util"})
public class Operations {
    public static boolean IS_DEBUG;
    public static boolean IS_WINDOWS;
    public static boolean IS_LINUX;
    private static int THREAD_POOLSIZE;
    public static ConcurrentHashMap<String, Logger> LOGGERS;
    public static Level LOG_LEVEL;
    public static boolean LOG_DEFINED;
    private static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String APPLICATION_JSON = "application/json";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final ExecutorService threadPool;
    private static final ScheduledExecutorService executor;
    private static final String DEFAULT_CHARSET;

    @CronapiMetaData(type="function", name="{{setReturn}}", nameTags={"return", "retorno"}, description="{{setReturnDescription}}", wizard="procedures_return_callnoreturn")
    public static final void setReturn(Var param) throws Exception {
    }

    @CronapiMetaData(type="function", name="{{getCurrentUserName}}", nameTags={"getCurrentUser"}, description="{{getCurrentUserNameDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getCurrentUserName() throws Exception {
        User user = RestClient.getRestClient().getUser();
        String username = null;
        if (user != null) {
            username = user.getUsername();
        }
        return Var.valueOf(username);
    }

    @CronapiMetaData(type="function", name="{{shellExecuteName}}", nameTags={"shellExecute"}, description="{{shellExecuteDescription}}", params={"{{shellExecuteParam0}}", "{{shellExecuteParam1}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.BOOLEAN}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var shellExecute(Var cmdline, Var waitFor) throws Exception {
        Boolean waitForCasted = (Boolean)waitFor.getObject();
        Process p = Runtime.getRuntime().exec(cmdline.getObjectAsString());
        if (waitForCasted.booleanValue()) {
            String line;
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            Object r = "";
            while ((line = input.readLine()) != null) {
                r = (String)r + line + "\n";
            }
            input.close();
            return new Var(r);
        }
        return new Var();
    }

    @CronapiMetaData(type="function", name="{{randomName}}", nameTags={"random"}, description="{{randomDescription}}", params={"{{randomParam0}}"}, paramsType={CronapiMetaData.ObjectType.DOUBLE}, returnType=CronapiMetaData.ObjectType.DOUBLE)
    public static final Var random(Var maxValue) throws Exception {
        return new Var(Math.round(Math.random() * maxValue.getObjectAsDouble()));
    }

    @CronapiMetaData(type="function", name="{{compressToZipName}}", nameTags={"compressToZip"}, description="{{compressToZipDescription}}", params={"{{compressToZipParam0}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var compressToZip(Var value) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DeflaterOutputStream compresser = new DeflaterOutputStream(output);
        compresser.write((byte[])value.getObject());
        compresser.finish();
        compresser.close();
        return new Var(output.toByteArray());
    }

    @CronapiMetaData(type="function", name="{{decodeZipFromByteName}}", nameTags={"decodeZipFromByte"}, description="{{decodeZipFromByteDescription}}", params={"{{decodeZipFromByteParam0}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var decodeZipFromByte(Var value) throws Exception {
        int len;
        ByteArrayInputStream input = new ByteArrayInputStream((byte[])value.getObject());
        InflaterInputStream decompresser = new InflaterInputStream(input);
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((len = decompresser.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        decompresser.close();
        out.close();
        input.close();
        return new Var(out.toByteArray());
    }

    @CronapiMetaData(type="function", name="{{sleep}}", nameTags={"sleep"}, description="{{functionToSleep}}", params={"{{timeSleepInSecond}}"}, paramsType={CronapiMetaData.ObjectType.LONG}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void sleep(Var time) throws Exception {
        long sleepTime = time.getObjectAsInt() * 1000;
        Thread.sleep(sleepTime);
    }

    @CronapiMetaData(type="function", name="{{throwException}}", nameTags={"throwException"}, description="{{functionToThrowException}}", params={"{{exceptionToBeThrow}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void throwException(Var exception) throws Exception {
        if (exception.getObject() instanceof Exception) {
            throw (Exception)Exception.class.cast(exception.getObject());
        }
        if (exception.getObject() instanceof String) {
            throw new Exception(exception.getObjectAsString());
        }
    }

    @CronapiMetaData(type="function", name="{{createExceptionName}}", nameTags={"createException"}, description="{{createExceptionName}}", params={"{{createExceptionParam0}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var createException(Var msg) throws Exception {
        Throwable e = msg.getObject() instanceof Throwable ? (Throwable)msg.getObject() : new Exception(msg.getObjectAsString());
        return new Var(e);
    }

    @CronapiMetaData(type="function", name="{{getExceptionMessage}}", nameTags={"Exception"}, description="{{getExceptionMessageDescription}}", params={"{{getExceptionMessageParam}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getExceptionMessage(Var exception) throws Exception {
        if (exception.getObject() instanceof Throwable) {
            return Var.valueOf(ErrorResponse.getExceptionMessage((Throwable)exception.getObject(), "IGNORED"));
        }
        return new Var(exception.getObjectAsString());
    }

    @CronapiMetaData(type="function", name="{{callBlocklyNoReturnName}}", nameTags={"callBlocklyNoReturn"}, description="{{callBlocklyNoReturnDescription}}", wizard="procedures_callblockly_callnoreturn", returnType=CronapiMetaData.ObjectType.VOID, arbitraryParams=true)
    public static final void callBlocklyNoReturn(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{callBlocklyNoReturnParam0}}") Var classNameWithMethod, Var ... params) throws Exception {
        Operations.callBlockly(classNameWithMethod, params);
    }

    public static final void callClientFunction(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{callClienteFunctionParam0}}") Var function, Var ... params) throws Exception {
        ClientCommand command = new ClientCommand(function.getObjectAsString());
        for (Var p : params) {
            command.addParam(p);
        }
        RestClient.getRestClient().addCommand(command);
    }

    @CronapiMetaData(type="function", name="{{callBlockly}}", nameTags={"callBlockly"}, description="{{functionToCallBlockly}}", params={"{{classNameWithMethod}}", "{{params}}"}, wizard="procedures_callblockly_callreturn", paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.OBJECT, arbitraryParams=true)
    public static final Var callBlockly(Var classNameWithMethod, Var ... params) throws Exception {
        return Operations.callBlockly(classNameWithMethod, false, "", params);
    }

    @CronapiMetaData(type="internal")
    public static String safeNameForMethodBlockly(String s) {
        Object result;
        if (s == null || s.isEmpty()) {
            return "unnamed";
        }
        s = s.replace(" ", "_");
        try {
            result = URLEncoder.encode(s, "UTF-8").replaceAll("[^\\w]", "_");
            if ("0123456789".indexOf(((String)result).substring(0, 1)) > -1) {
                result = "my_" + (String)result;
            }
        }
        catch (UnsupportedEncodingException e) {
            result = s;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @CronapiMetaData(type="internal")
    public static final Var callBlockly(Var classNameWithMethod, boolean checkSecurity, String restMethod, Var ... params) throws Exception {
        void var15_37;
        boolean bl;
        Object className = classNameWithMethod.getObjectAsString();
        String method = null;
        if (((String)className).indexOf(":") > -1) {
            method = Operations.safeNameForMethodBlockly(((String)className).substring(((String)className).indexOf(":") + 1));
            className = ((String)className).substring(0, ((String)className).indexOf(":"));
        }
        Class<?> clazz = null;
        try {
            if (IS_DEBUG) {
                CronapiClassLoader loader = CronapiClassLoader.getInstance();
                clazz = loader.findClass((String)className);
            } else {
                clazz = Class.forName((String)className);
            }
        }
        catch (Exception e) {
            String[] parts = ((String)className).split("\\.");
            Method[] simpleName = parts[parts.length - 1];
            className = "";
            for (int i = 0; i < parts.length - 1; ++i) {
                if (!((String)className).isEmpty()) {
                    className = (String)className + ".";
                }
                className = (String)className + parts[i];
            }
            if (!((String)className).isEmpty()) {
                className = (String)className + ".";
            }
            className = (String)className + Operations.reduceVariable((String)simpleName, false);
            try {
                if (IS_DEBUG) {
                    CronapiClassLoader loader = CronapiClassLoader.getInstance();
                    clazz = loader.findClass((String)className);
                } else {
                    clazz = Class.forName((String)className);
                }
            }
            catch (Exception e2) {
                try {
                    if (IS_DEBUG) {
                        CronapiClassLoader loader = CronapiClassLoader.getInstance();
                        clazz = loader.findClass("blockly." + (String)className);
                    } else {
                        clazz = Class.forName("blockly." + (String)className);
                    }
                }
                catch (Exception e3) {
                    throw new Exception(Messages.getString("blocklyNotFound"), e);
                }
            }
        }
        boolean checkSOAP = false;
        if (checkSecurity) {
            if (restMethod.equals("soap")) {
                restMethod = "POST";
                checkSOAP = true;
            }
            BlocklySecurity.checkSecurity(clazz, restMethod);
        }
        Method methodToCall = method == null ? clazz.getMethods()[0] : null;
        for (Method method2 : clazz.getMethods()) {
            if (!method2.getName().equalsIgnoreCase(method)) continue;
            methodToCall = method2;
            break;
        }
        if (methodToCall == null) {
            throw new Exception(Messages.getString("methodNotFound"));
        }
        if (params == null) {
            params = new Var[]{};
        }
        Object[] callParams = params;
        boolean namedParams = false;
        boolean hasIds = params.length > 0;
        for (Var var : params) {
            if (!StringUtils.isEmpty((CharSequence)var.getId())) continue;
            hasIds = false;
            break;
        }
        if (params.length > 0 && methodToCall.getParameterCount() > 0 && hasIds && ReflectionUtils.getAnnotation(methodToCall.getParameters()[0], "cronapi.ParamMetaData") != null) {
            void var15_34;
            void var12_22;
            namedParams = true;
            callParams = new Var[methodToCall.getParameterCount()];
            boolean bl2 = false;
            while (var12_22 < callParams.length) {
                callParams[var12_22] = Var.VAR_NULL;
                ++var12_22;
            }
            boolean bl3 = false;
            Parameter[] parameterArray = methodToCall.getParameters();
            int n = parameterArray.length;
            boolean bl4 = false;
            while (var15_34 < n) {
                void var12_24;
                Parameter parameter = parameterArray[var15_34];
                ParamMetaData annotation = (ParamMetaData)ReflectionUtils.getAnnotation(parameter, "cronapi.ParamMetaData");
                for (Var param : params) {
                    if (!param.getId().equals(annotation.description()) && !param.getId().equals(annotation.id())) continue;
                    callParams[var12_24] = param;
                    break;
                }
                ++var12_24;
                ++var15_34;
            }
        }
        if (!namedParams && methodToCall.getParameterCount() != callParams.length) {
            void var12_26;
            callParams = new Var[methodToCall.getParameterCount()];
            boolean bl5 = false;
            while (var12_26 < methodToCall.getParameterCount()) {
                callParams[var12_26] = var12_26 < params.length ? params[var12_26] : Var.VAR_NULL;
                ++var12_26;
            }
        }
        boolean bl6 = false;
        boolean isSoap = false;
        boolean audit = false;
        for (Annotation annotation : clazz.getAnnotations()) {
            String value;
            Method type;
            if (annotation.annotationType().getName().equals("cronapi.CronapiMetaData") && (type = annotation.annotationType().getMethod("type", new Class[0])) != null && (value = (String)type.invoke((Object)annotation, new Object[0])) != null && value.equals("blockly")) {
                bl = true;
            }
            if (annotation.annotationType().getName().equals("cronapi.rest.security.CronappAudit")) {
                audit = true;
            }
            if (!annotation.annotationType().getName().equals("javax.jws.WebService")) continue;
            isSoap = true;
        }
        if (!bl) {
            throw new Exception(Messages.getString("accessDenied"));
        }
        if (checkSOAP && !isSoap) {
            throw new Exception(Messages.getString("accessDenied"));
        }
        boolean bl7 = false;
        while (var15_37 < callParams.length) {
            if (callParams[var15_37] == null) {
                callParams[var15_37] = Var.VAR_NULL;
            }
            ++var15_37;
        }
        Object object = methodToCall.invoke(clazz, callParams);
        Var result = Var.valueOf(object);
        if (audit) {
            Operations.auditBlockly(clazz, methodToCall, result, (Var[])callParams);
        }
        return result;
    }

    private static void auditBlockly(Class blockly, Method function, Var result, Var[] params) throws Exception {
        DatabaseQueryManager logManager = HistoryListener.getAuditLogManager();
        if (logManager != null) {
            JsonObject json = new JsonObject();
            JsonArray arrayParams = new JsonArray();
            json.add("parameters", (JsonValue)arrayParams);
            for (Var p : params) {
                arrayParams.add(p.getObjectAsString());
            }
            json.add("result", result.getObjectAsString());
            Var auditLog = new Var(new LinkedHashMap());
            auditLog.set("type", blockly.getName());
            auditLog.set("command", function.getName());
            auditLog.set("category", "Blockly");
            auditLog.set("date", new Date());
            auditLog.set("objectData", json.toString());
            if (RestClient.getRestClient() != null) {
                auditLog.set("user", RestClient.getRestClient().getUser() != null ? RestClient.getRestClient().getUser().getUsername() : null);
                auditLog.set("host", RestClient.getRestClient().getHost());
                auditLog.set("agent", RestClient.getRestClient().getAgent());
            }
            auditLog.set("server", HistoryListener.CURRENT_IP);
            auditLog.set("affectedFields", null);
            auditLog.set("application", AppConfig.guid());
            logManager.insert(auditLog, new Object[0]);
        }
    }

    @CronapiMetaData(type="function", name="{{encryptPasswordName}}", nameTags={"encryptPassword"}, description="{{encryptPasswordDescription}}", params={"{{encryptPasswordParam0}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var encryptPassword(Var password) throws Exception {
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        return new Var(passwordEncoder.encode((CharSequence)password.getObjectAsString()));
    }

    @CronapiMetaData(type="function", name="{{MD5OfVar}}", nameTags={"string md5", "bytes md5", "md5"}, description="{{functionToReturnMD5OfVar}}", params={"{{MD5OfVarParam0}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.STRING)
    public static Var encodeMD5(Var value) throws Exception {
        return Var.valueOf(value.getMD5());
    }

    @CronapiMetaData(type="function", name="{{matchesencryptPasswordName}}", nameTags={"matchesencryptPassword"}, description="{{matchesencryptPasswordDescription}}", params={"{{matchesencryptPasswordParam0}}", "{{matchesencryptPasswordParam1}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var matchesencryptPassword(Var password, Var encrypted) throws Exception {
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        return new Var(passwordEncoder.matches((CharSequence)password.getObjectAsString(), encrypted.getObjectAsString()));
    }

    @CronapiMetaData(type="function", name="{{getHeadersFromExternalURL}}", nameTags={"getHeadersFromExternalURL"}, description="{{getHeadersFromExternalURLDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getHeadersFromExternalURL(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{HTTPMethod}}", blockType="util_dropdown", keys={"GET", "POST", "PUT", "DELETE"}, values={"{{HTTPGet}}", "{{HTTPPost}}", "{{HTTPPut}}", "{{HTTPDelete}}"}) Var method, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{contentType}}", blockType="util_dropdown", keys={"application/x-www-form-urlencoded", "application/json"}, values={"{{x_www_form_urlencoded}}", "{{app_json}}"}) Var contentType, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{URLAddress}}") Var address, @ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{paramsHTTP}}") Var params, @ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{cookieContainer}}") Var cookieContainer) throws Exception {
        return Operations.getContentFromURL(method, contentType, address, params, cookieContainer, new Var("HEADER"), Var.VAR_NULL);
    }

    public static final Var getURLFromOthers(Var method, Var contentType, Var address, Var params, Var cookieContainer) throws Exception {
        return Operations.getURLFromOthers(method, contentType, address, params, cookieContainer, new Var("DeprecatedMethodSupport", "BODY"), Var.VAR_NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CronapiMetaData(type="function", name="{{getURLFromOthersName}}", nameTags={"getURLFromOthersName"}, description="{{getURLFromOthersDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var getURLFromOthers(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{HTTPMethod}}", blockType="util_dropdown", keys={"GET", "POST", "PUT", "DELETE", "PATCH", "HEAD", "OPTIONS", "TRACE"}, values={"{{HTTPGet}}", "{{HTTPPost}}", "{{HTTPPut}}", "{{HTTPDelete}}", "PATCH", "HEAD", "OPTIONS", "TRACE"}) Var method, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{contentType}}", blockType="util_dropdown", keys={"application/x-www-form-urlencoded", "application/json", "multipart/form-data"}, values={"{{x_www_form_urlencoded}}", "{{app_json}}", "multipart/form-data"}) Var contentType, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{URLAddress}}") Var address, @ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{paramsHTTP}}") Var params, @ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{cookieContainer}}") Var cookieContainer, @ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{postData}}") Var postData, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{pathOfFile}}") Var path, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{HTTPResponse}}", blockType="util_dropdown", keys={"ALL", "BODY", "STREAM", "STATUS"}, values={"{{HTTPAll}}", "{{HTTPBody}}", "{{HTTPStream}}", "{{HTTPStatus}}"}) Var returnType) throws Exception {
        if (returnType.isEmptyOrNull().booleanValue()) {
            returnType = path.isEmptyOrNull() != false ? new Var("BODY") : new Var("STREAM");
        }
        Var content = Operations.getContentFromURL(method, contentType, address, params, cookieContainer, returnType, postData);
        try (InputStream inputStream = null;){
            if (!path.isEmptyOrNull().booleanValue()) {
                inputStream = content.getTypedObject(InputStream.class);
                try (FileOutputStream outputStream = new FileOutputStream(path.getObjectAsString());){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                Var var = Var.VAR_NULL;
                return var;
            }
            Var var = content;
            return var;
        }
    }

    @CronapiMetaData(type="function", name="{{getItemFromHttpResponseName}}", nameTags={"getItemFromHttpResponseName"}, description="{{getItemFromHttpResponseDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var getItemFromHttpResponse(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{getItemFromHttpResponseParam1}}") Var httpResponseVar, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{HTTPResponse}}", blockType="util_dropdown", keys={"HEADER", "BODY", "STREAM", "STATUS"}, values={"{{HTTPHeaders}}", "{{HTTPBody}}", "{{HTTPStream}}", "{{HTTPStatus}}"}) Var returnType) throws Exception {
        HttpResponse httpResponse = (HttpResponse)httpResponseVar.getObject();
        if (returnType.equals("HEADER")) {
            return Var.valueOf(Operations.getResponseHeaders(httpResponse));
        }
        if (returnType.equals("BODY")) {
            return Var.valueOf(Operations.getReponseAsString(httpResponse));
        }
        if (returnType.equals("STREAM")) {
            return Var.valueOf(Operations.getResponseInputStream(httpResponse));
        }
        return Var.valueOf(Operations.getReponseStatus(httpResponse));
    }

    public static Var getURLFromOthers(Var method, Var contentType, Var address, Var params, Var cookieContainer, Var postData) throws Exception {
        return Operations.getURLFromOthers(method, contentType, address, params, cookieContainer, postData, Var.VAR_NULL);
    }

    public static Var getURLFromOthers(Var method, Var contentType, Var address, Var params, Var cookieContainer, Var postData, Var path) throws Exception {
        return Operations.getURLFromOthers(method, contentType, address, params, cookieContainer, postData, path, Var.VAR_NULL);
    }

    public static final Var getContentFromURL(Var method, Var contentType, Var address, Var params, Var cookieContainer, Var returnType, Var postData) throws Exception {
        Var toReturn;
        HttpResponse httpResponse;
        boolean isCallFromDeprecatedBlockly;
        String methodAsString = method.getObjectAsString();
        CloseableHttpClient httpClient = CustomHttpClient.create();
        Object httpMethod = "POST".equalsIgnoreCase(methodAsString) ? new HttpPost(address.getObjectAsString()) : ("PUT".equalsIgnoreCase(methodAsString) ? new HttpPut(address.getObjectAsString()) : ("DELETE".equalsIgnoreCase(methodAsString) ? new HttpDelete(address.getObjectAsString()) : ("PATCH".equalsIgnoreCase(methodAsString) ? new HttpPatch(address.getObjectAsString()) : ("HEAD".equalsIgnoreCase(methodAsString) ? new HttpHead(address.getObjectAsString()) : ("OPTIONS".equalsIgnoreCase(methodAsString) ? new HttpOptions(address.getObjectAsString()) : ("TRACE".equalsIgnoreCase(methodAsString) ? new HttpTrace(address.getObjectAsString()) : new HttpGet(address.getObjectAsString())))))));
        if (!cookieContainer.isNull().booleanValue()) {
            Map headerObject = cookieContainer.getObjectAsMap();
            headerObject.entrySet().stream().forEach(arg_0 -> Operations.lambda$getContentFromURL$0((HttpRequestBase)httpMethod, arg_0));
        }
        CronappTokenManager tokenManager = (CronappTokenManager)CronappConfiguration.getBean(CronappTokenManager.class);
        tokenManager.process((HttpRequestBase)httpMethod);
        boolean bl = isCallFromDeprecatedBlockly = postData.isEmptyOrNull() == false && "DeprecatedMethodSupport".equals(postData.getId());
        if (isCallFromDeprecatedBlockly) {
            HttpRequestBase httpRequest = Operations.createBodyRequest(params, contentType, (HttpRequestBase)httpMethod);
            httpResponse = httpClient.execute((HttpUriRequest)httpRequest);
        } else {
            if (!params.isNull().booleanValue()) {
                Map mapParams = params.getObjectAsMap();
                LinkedList paramsData = new LinkedList();
                mapParams.forEach((arg_0, arg_1) -> Operations.lambda$getContentFromURL$1(paramsData, (HttpRequestBase)httpMethod, arg_0, arg_1));
                URI uri = httpMethod.getURI();
                if (!paramsData.isEmpty()) {
                    uri = new URIBuilder(httpMethod.getURI()).addParameters(paramsData).build();
                }
                httpMethod.setURI(uri);
            }
            HttpRequestBase httpRequest = Operations.createBodyRequest(postData, contentType, (HttpRequestBase)httpMethod);
            httpResponse = httpClient.execute((HttpUriRequest)httpRequest);
        }
        if (returnType != null && returnType.equals("HEADER")) {
            toReturn = Var.valueOf(Operations.getResponseHeaders(httpResponse));
        } else if (returnType != null && returnType.equals("STATUS")) {
            toReturn = Var.valueOf(Operations.getReponseStatus(httpResponse));
        } else if (returnType != null && returnType.equals("STREAM")) {
            toReturn = Var.valueOf(Operations.getResponseInputStream(httpResponse));
        } else {
            if (httpResponse.getStatusLine().getStatusCode() >= 400 && !returnType.equals("ALL")) {
                throw new RuntimeException(httpResponse.getStatusLine().getReasonPhrase());
            }
            toReturn = returnType.equals("ALL") ? Var.valueOf(httpResponse) : Var.valueOf(Operations.getReponseAsString(httpResponse));
        }
        httpMethod.completed();
        return toReturn;
    }

    private static String getReponseAsString(HttpResponse httpResponse) throws Exception {
        Scanner scanner = httpResponse.getEntity() != null && httpResponse.getEntity().getContent() != null ? new Scanner(httpResponse.getEntity().getContent(), CronapiConfigurator.ENCODING) : new Scanner("");
        String response = "";
        try {
            response = scanner.useDelimiter("\\A").next();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        scanner.close();
        return response;
    }

    private static Map<String, String> getResponseHeaders(HttpResponse httpResponse) {
        Header[] headers;
        HashMap<String, String> responseMap = new HashMap<String, String>();
        for (Header header : headers = httpResponse.getAllHeaders()) {
            responseMap.put(header.getName(), header.getValue());
        }
        return responseMap;
    }

    private static int getReponseStatus(HttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode();
    }

    private static InputStream getResponseInputStream(HttpResponse httpResponse) throws Exception {
        InputStream content;
        if (httpResponse.getEntity() != null && (content = httpResponse.getEntity().getContent()) != null) {
            return content;
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    private static HttpRequestBase createBodyRequest(Var payload, Var contentType, HttpRequestBase httpMethod) throws UnsupportedEncodingException {
        if (!payload.isNull().booleanValue()) {
            String ct = contentType.getObjectAsString();
            HttpWithBody httpMethodWidthBody = new HttpWithBody(httpMethod, httpMethod.getMethod());
            if (APPLICATION_X_WWW_FORM_URLENCODED.equals(ct)) {
                Map mapObject = payload.getObjectAsMap();
                LinkedList paramsData = new LinkedList();
                mapObject.forEach((key, value) -> {
                    String obj = String.valueOf(value);
                    if (value instanceof Var) {
                        obj = ((Var)value).getObjectAsString();
                    }
                    BasicNameValuePair item = new BasicNameValuePair(String.valueOf(key), obj);
                    paramsData.add(item);
                });
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(paramsData, CronapiConfigurator.ENCODING);
                urlEncodedFormEntity.setContentType(ct);
                httpMethodWidthBody.setEntity((HttpEntity)urlEncodedFormEntity);
            } else if (MULTIPART_FORM_DATA.equalsIgnoreCase(ct)) {
                MultipartEntityBuilder multipartEntity = MultipartEntityBuilder.create();
                Map body = payload.getObjectAsMap();
                body.entrySet().forEach(entry -> Operations.addPart(multipartEntity, (String)entry.getKey(), (Var)entry.getValue()));
                multipartEntity.setContentType(ContentType.MULTIPART_FORM_DATA);
                httpMethodWidthBody.setEntity(multipartEntity.build());
            } else {
                StringEntity stringEntity = new StringEntity(payload.getObjectAsString(), Charset.forName(CronapiConfigurator.ENCODING));
                stringEntity.setContentType(ct);
                httpMethodWidthBody.setEntity((HttpEntity)stringEntity);
            }
            return httpMethodWidthBody;
        }
        return httpMethod;
    }

    private static void addPart(MultipartEntityBuilder multipartEntity, String key, Var value) {
        Object objectValue = value.getObject();
        if (objectValue instanceof LinkedHashMap) {
            LinkedHashMap map = (LinkedHashMap)objectValue;
            Object multipartValue = ((Var)map.get("value")).getObject();
            Object contentType = ((Var)map.get("contentType")).getObject();
            Object filename = ((Var)map.get("filename")).getObject();
            if (multipartValue instanceof File) {
                multipartEntity.addBinaryBody(key, (File)multipartValue, Optional.ofNullable(ContentType.getByMimeType((String)String.valueOf(contentType))).orElse(ContentType.DEFAULT_BINARY), StringUtils.defaultString((String)String.valueOf(filename)));
            } else if (multipartValue instanceof InputStream) {
                multipartEntity.addBinaryBody(key, (InputStream)multipartValue, Optional.ofNullable(ContentType.getByMimeType((String)String.valueOf(contentType))).orElse(ContentType.DEFAULT_BINARY), StringUtils.defaultString((String)String.valueOf(filename)));
            } else if (multipartValue instanceof byte[]) {
                multipartEntity.addBinaryBody(key, (byte[])multipartValue, Optional.ofNullable(ContentType.getByMimeType((String)String.valueOf(contentType))).orElse(ContentType.DEFAULT_BINARY), StringUtils.defaultString((String)String.valueOf(filename)));
            }
        } else if (objectValue instanceof String) {
            multipartEntity.addTextBody(key, (String)objectValue);
        } else if (objectValue instanceof File) {
            multipartEntity.addBinaryBody(key, (File)objectValue);
        } else if (objectValue instanceof InputStream) {
            multipartEntity.addBinaryBody(key, (InputStream)objectValue);
        } else if (objectValue instanceof byte[]) {
            multipartEntity.addBinaryBody(key, (byte[])objectValue);
        }
    }

    @CronapiMetaData(type="function", name="{{getFormDataObject}}", nameTags={"multipart", "form", "arquivo", "file", "bin\u00e1rio", "binary", "formul\u00e1rio"}, description="{{getFormDataObjectDesc}}", returnType=CronapiMetaData.ObjectType.MAP)
    public static final Var getFormDataObject(@ParamMetaData(description="{{value}}") Var value, @ParamMetaData(description="{{contentType}}") Var contentType, @ParamMetaData(description="{{fileName}}") Var filename) throws Exception {
        return Var.valueOf(MULTIPART_FORM_DATA, cronapi.map.Operations.createObjectMapWith(Var.valueOf("value", value), Var.valueOf("contentType", contentType), Var.valueOf("filename", filename)));
    }

    @CronapiMetaData(type="function", name="{{getFromSession}}", nameTags={"getFromSession"}, description="{{getFromSessionDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getValueFromSession(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fieldName}}") Var fieldName) {
        return Var.valueOf(RestClient.getRestClient().getSessionValue(fieldName.toString()));
    }

    @CronapiMetaData(type="function", name="{{getRequestedMethodName}}", nameTags={"verb", "request", "http"}, description="{{getRequestedMethodDescription}}")
    public static final Var getRequestedMethod() throws Exception {
        return Var.valueOf(RestClient.getRestClient().getMethod());
    }

    @CronapiMetaData(type="function", name="{{getRequestedHeadersName}}", nameTags={"header", "request", "http"}, description="{{getRequestedHeadersDescription}}")
    public static final Var getRequestedHeaders() throws Exception {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        Iterator headers = RestClient.getRestClient().getRequest().getHeaderNames().asIterator();
        while (headers.hasNext()) {
            String headerName = (String)headers.next();
            headersMap.put(headerName, RestClient.getRestClient().getRequest().getHeader(headerName));
        }
        return Var.valueOf(headersMap);
    }

    @CronapiMetaData(type="function", name="{{setInSession}}", nameTags={"setInSession"}, description="{{setInSessionDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final void setInSession(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fieldName}}") Var fieldName, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fieldValue}}") Var fieldValue) throws Exception {
        RestClient.getRestClient().updateSessionValue(fieldName.toString(), fieldValue);
    }

    public static void readLinesFromStream(Var input, Callback callback) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input.getObject()));
        while ((line = reader.readLine()) != null) {
            callback.call(Var.valueOf(line));
        }
    }

    public static final void readBytesFromStream(Var input, Var size, Callback callback) throws Exception {
        byte[] buffer = new byte[size.getObjectAsInt() > 0 ? size.getObjectAsInt() : 1024];
        InputStream ios = (InputStream)input.getObject();
        int read = 0;
        while ((read = ios.read(buffer)) != -1) {
            byte[] readBytes = Arrays.copyOf(buffer, read);
            callback.call(Var.valueOf(readBytes));
        }
    }

    @CronapiMetaData(type="function", name="{{generateUUIDName}}", nameTags={"generateUUID"}, description="{{generateUUIDDescription}}", paramsType={CronapiMetaData.ObjectType.STRING})
    public static final Var generateUUID() {
        return Var.valueOf(UUID.randomUUID().toString());
    }

    @CronapiMetaData(type="function", name="{{executeAsync}}", nameTags={"executeAsync"}, description="{{executeAsyncDescription}}", returnType=CronapiMetaData.ObjectType.VOID, params={"{{cmd}}"}, paramsType={CronapiMetaData.ObjectType.STATEMENT})
    public static final void executeAsync(Runnable cmd) throws Exception {
        threadPool.execute(RestClient.getContextRunnable(cmd, true));
    }

    @CronapiMetaData(type="function", name="{{scheduleExecution}}", nameTags={"scheduleExecution"}, description="{{scheduleExecutionDescription}}", returnType=CronapiMetaData.ObjectType.VOID)
    public static final void scheduleExecution(@ParamMetaData(type=CronapiMetaData.ObjectType.STATEMENT, description="{{cmd}}") Runnable cmd, @ParamMetaData(type=CronapiMetaData.ObjectType.LONG, description="{{initialTime}}") Var initialTime, @ParamMetaData(type=CronapiMetaData.ObjectType.LONG, description="{{updateTime}}") Var updateTime, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{timeUnit}}", blockType="util_dropdown", keys={"SECONDS", "MILLISECONDS", "MINUTES", "HOURS"}, values={"{{SECONDS}}", "{{MILLISECONDS}}", "{{MINUTES}}", "{{HOURS}}"}) Var unit) throws Exception {
        TimeUnit timeUnit = TimeUnit.SECONDS;
        if ("SECONDS".equalsIgnoreCase(unit.getObjectAsString())) {
            timeUnit = TimeUnit.SECONDS;
        }
        if ("MILLISECONDS".equalsIgnoreCase(unit.getObjectAsString())) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        if ("MINUTES".equalsIgnoreCase(unit.getObjectAsString())) {
            timeUnit = TimeUnit.MINUTES;
        }
        if ("HOURS".equalsIgnoreCase(unit.getObjectAsString())) {
            timeUnit = TimeUnit.HOURS;
        }
        long init = initialTime.isNull() != false ? 0L : initialTime.getObjectAsLong();
        long update = updateTime.isNull() != false ? 0L : updateTime.getObjectAsLong();
        Runnable run = RestClient.getContextRunnable(cmd, true);
        if (update == 0L) {
            executor.schedule(run, init, timeUnit);
        } else {
            executor.scheduleWithFixedDelay(run, init, update, timeUnit);
        }
    }

    @CronapiMetaData(type="function", name="{{uploadName}}", nameTags={"upload", "enviar"}, description="{{uploadDescription}}")
    public static final void upload(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{uploadParam}}") Var description, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, defaultValue="*", description="{{uploadParam0}}") Var filter, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, defaultValue="20MB", description="{{uploadParam1}}") Var maxSize, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{uploadParam2}}", blockType="util_dropdown", keys={"true", "false"}, values={"{{yes}}", "{{no}}"}) Var multiple, @ParamMetaData(type=CronapiMetaData.ObjectType.STATEMENTSENDER, description="{{uploadParam3}}") Callback callback) throws Exception {
        String id = DownloadREST.authorizeUpload(callback);
        RestClient.getRestClient().addCommand("cronapi.util.upload").addParam(id, description, filter, maxSize, multiple);
    }

    @CronapiMetaData(type="internal")
    public static String translateAcentos(String aValue) {
        String CHR_ACENTUADA = "\u00e0\u00e8\u00ec\u00f2\u00f9\u00e1\u00e9\u00ed\u00f3\u00fa\u00e2\u00ea\u00ee\u00f4\u00fb\u00e3\u00f5\u00e7\u00f1\u00e4\u00eb\u00ef\u00f6\u00fc\u00c0\u00c8\u00cc\u00d2\u00d9\u00c1\u00c9\u00cd\u00d3\u00da\u00c2\u00ca\u00ce\u00d4\u00db\u00c3\u00d5\u00c7\u00d1\u00c4\u00cb\u00cf\u00d6\u00dc";
        String CHR_NAO_ACENTUADA = "aeiouaeiouaeiouaocnaeiouAEIOUAEIOUAEIOUAOCNAEIOU";
        StringBuilder result = new StringBuilder();
        for (int idx = 0; idx < aValue.length(); ++idx) {
            int idxpos = "\u00e0\u00e8\u00ec\u00f2\u00f9\u00e1\u00e9\u00ed\u00f3\u00fa\u00e2\u00ea\u00ee\u00f4\u00fb\u00e3\u00f5\u00e7\u00f1\u00e4\u00eb\u00ef\u00f6\u00fc\u00c0\u00c8\u00cc\u00d2\u00d9\u00c1\u00c9\u00cd\u00d3\u00da\u00c2\u00ca\u00ce\u00d4\u00db\u00c3\u00d5\u00c7\u00d1\u00c4\u00cb\u00cf\u00d6\u00dc".indexOf(aValue.charAt(idx));
            if (idxpos != -1) {
                result.append("aeiouaeiouaeiouaocnaeiouAEIOUAEIOUAEIOUAOCNAEIOU".charAt(idxpos));
                continue;
            }
            result.append(aValue.charAt(idx));
        }
        return result.toString();
    }

    @CronapiMetaData(type="internal")
    public static String reduceVariable(String var, boolean notClassName) {
        Object reducedVariable = null;
        if (var != null) {
            if (notClassName) {
                reducedVariable = Operations.translateAcentos(var.toUpperCase()).trim().replaceAll("\\s", "_");
                Pattern pattern = Pattern.compile("^\\d+|\\W");
                Matcher matcher = pattern.matcher((CharSequence)reducedVariable);
                reducedVariable = matcher.replaceAll("_");
            } else {
                int spacePosition;
                reducedVariable = Operations.translateAcentos(var);
                Pattern pattern = Pattern.compile("\\W");
                Matcher matcher = pattern.matcher((CharSequence)reducedVariable);
                reducedVariable = matcher.replaceAll(" ").trim();
                pattern = Pattern.compile("^[\\d\\W]+");
                matcher = pattern.matcher((CharSequence)reducedVariable);
                reducedVariable = matcher.replaceAll(" ").trim();
                if (((String)(reducedVariable = ((String)reducedVariable).replaceAll("\\s{2,}", " ").replaceAll("_", " ").trim())).length() > 1) {
                    reducedVariable = ((String)reducedVariable).substring(0, 1).toUpperCase() + ((String)reducedVariable).substring(1);
                }
                while ((spacePosition = ((String)reducedVariable).indexOf(" ")) != -1) {
                    String aux = ((String)reducedVariable).substring(spacePosition + 1);
                    reducedVariable = ((String)reducedVariable).substring(0, spacePosition) + Operations.firstToUpper(aux);
                }
            }
        }
        if (reducedVariable == null || ((String)reducedVariable).trim().length() == 0) {
            return Operations.reduceVariable((notClassName ? "Identifier" : "Class") + var, notClassName);
        }
        return reducedVariable;
    }

    @CronapiMetaData(type="internal")
    public static String firstToUpper(String text) {
        if (text.length() >= 2) {
            return text.substring(0, 1).toUpperCase() + text.substring(1).toLowerCase();
        }
        return text.toUpperCase();
    }

    @CronapiMetaData(type="function", name="{{redirect}}", nameTags={"redirecionar", "redirect"}, description="{{redirectDescription}}")
    public static final void redirect(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{location}}") Var location) throws Exception {
        RestClient.getRestClient().getResponse().sendRedirect(location.getObjectAsString());
    }

    @CronapiMetaData(type="function", name="{{createDownloadURL}}", nameTags={"download", "url"}, description="{{createDownloadURLDescription}}")
    public static Var createDownloadLink(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{createDownloadURLParam}}") Var file) {
        return Var.valueOf(DownloadREST.getDownloadUrl(new File(file.toString())));
    }

    @CronapiMetaData(type="function", name="{{getSystemParam}}", nameTags={"system", "parameter"}, description="{{getSystemParam}}")
    public static Var getSystemParameter(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{getSystemParamKey}}") Var key) {
        Var value = CronapiBeanConfigurator.INIT_PARAMS.get(key.toString());
        if (value != null) {
            return value;
        }
        return Var.VAR_EMPTY;
    }

    @CronapiMetaData(type="function", name="{{getSystemProfile}}", nameTags={"system", "profile"}, description="{{getSystemProfile}}")
    public static Var getSystemProfile() {
        return Operations.getSystemParameter(Var.valueOf("app.profile"));
    }

    private static Level toLevel(String strLevel) {
        Level level = Level.INFO;
        if (strLevel.equals("FINE")) {
            level = Level.FINE;
        } else if (strLevel.equals("FINER")) {
            level = Level.FINER;
        } else if (strLevel.equals("FINEST")) {
            level = Level.FINEST;
        } else if (strLevel.equals("SEVERE")) {
            level = Level.SEVERE;
        } else if (strLevel.equals("WARNING")) {
            level = Level.WARNING;
        } else if (strLevel.equals("CONFIG")) {
            level = Level.CONFIG;
        } else if (strLevel.equals("ALL")) {
            level = Level.ALL;
        } else if (strLevel.equals("OFF")) {
            level = Level.OFF;
        }
        return level;
    }

    @CronapiMetaData(type="function", name="{{log}}", nameTags={"log", "imprimir", "logging", "logar"}, description="{{logDescription}}")
    public static void log(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{logCategory}}", defaultValue="General") Var category, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{logLevel}}", blockType="util_dropdown", keys={"INFO", "SEVERE", "WARNING", "CONFIG", "FINE", "FINER", "FINEST"}, values={"{{INFO}}", "{{SEVERE}}", "{{WARNING}}", "{{CONFIG}}", "{{FINE}}", "{{FINER}}", "{{FINEST}}"}, defaultValue="INFO") Var type, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{logMessage}}") Var message, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{logDetail}}") Var exception) {
        Logger log;
        if (category == null || category.isEmptyOrNull().booleanValue()) {
            category = Var.valueOf("General");
        }
        if ((log = LOGGERS.get(category.getObjectAsString())) == null) {
            log = Logger.getLogger(category.getObjectAsString());
            if (LOG_DEFINED) {
                log.setLevel(LOG_LEVEL);
                for (Logger parent = log.getParent(); parent != null; parent = parent.getParent()) {
                    for (Handler handler : parent.getHandlers()) {
                        handler.setLevel(LOG_LEVEL);
                    }
                }
            } else if (!Operations.getSystemParameter(Var.valueOf("app.loglevel")).isEmptyOrNull().booleanValue()) {
                Level newLevel = Operations.toLevel(Operations.getSystemParameter(Var.valueOf("app.loglevel")).getObjectAsString());
                log.setLevel(newLevel);
                for (Logger parent = log.getParent(); parent != null; parent = parent.getParent()) {
                    for (Handler handler : parent.getHandlers()) {
                        handler.setLevel(newLevel);
                    }
                }
            }
            LOGGERS.put(category.getObjectAsString(), log);
        }
        Level level = Operations.toLevel(type.getObjectAsString());
        if (exception != null && !exception.isEmptyOrNull().booleanValue() && exception.getObject() instanceof Throwable) {
            log.log(level, message.getObjectAsString(), (Throwable)exception.getObject());
        } else if (exception != null && !exception.isEmptyOrNull().booleanValue()) {
            log.log(level, message.getObjectAsString(), exception.getObjectAsString());
        } else {
            log.log(level, message.getObjectAsString());
        }
    }

    @CronapiMetaData(type="function", name="{{audit}}", nameTags={"audit", "auditar"}, description="{{auditDescription}}")
    public static void audit(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{auditType}}", defaultValue="General") Var type, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{auditCommand}}") Var command, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{auditCategory}}", defaultValue="Trace") Var category, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{auditData}}") Var data) throws Exception {
        DatabaseQueryManager logManager = HistoryListener.getAuditLogManager();
        if (logManager != null) {
            Var auditLog = new Var(new LinkedHashMap());
            auditLog.set("type", type.getObjectAsString());
            auditLog.set("command", command.getObjectAsString());
            auditLog.set("category", category.getObjectAsString());
            auditLog.set("date", new Date());
            auditLog.set("objectData", data.getObjectAsString());
            if (RestClient.getRestClient() != null) {
                auditLog.set("user", RestClient.getRestClient().getUser() != null ? RestClient.getRestClient().getUser().getUsername() : null);
                auditLog.set("host", RestClient.getRestClient().getHost());
                auditLog.set("agent", RestClient.getRestClient().getAgent());
            }
            auditLog.set("server", HistoryListener.CURRENT_IP);
            auditLog.set("affectedFields", null);
            auditLog.set("application", AppConfig.guid());
            logManager.insert(auditLog, new Object[0]);
        }
    }

    private static SecretKeySpec getKey(String myKey) throws Exception {
        MessageDigest sha = null;
        byte[] key = myKey.getBytes("UTF-8");
        sha = MessageDigest.getInstance("SHA-1");
        key = sha.digest(key);
        key = Arrays.copyOf(key, 16);
        return new SecretKeySpec(key, "AES");
    }

    @CronapiMetaData(type="function", name="{{getApplicationId}}", nameTags={"application", "id"}, description="{{getApplicationIdDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var getApplicationId() {
        return Var.valueOf(AppConfig.getApplicationId());
    }

    @CronapiMetaData(type="function", name="{{encryptName}}", nameTags={"encrypt"}, description="{{encryptDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var encrypt(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{encryptMessage}}") Var messageVar, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{encryptKey}}") Var keyVar) throws Exception {
        byte[] message = messageVar.getObject() instanceof byte[] ? messageVar.getObjectAsByteArray() : messageVar.getObjectAsString().getBytes();
        SecretKeySpec secretKey = Operations.getKey(keyVar.getObjectAsString());
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
        cipher.init(1, secretKey);
        byte[] outputBytes = cipher.doFinal(message);
        if (messageVar.getObject() instanceof byte[]) {
            return Var.valueOf(outputBytes);
        }
        return Var.valueOf(new String(Base64.getEncoder().encode(outputBytes)));
    }

    @CronapiMetaData(type="function", name="{{decryptName}}", nameTags={"encrypt"}, description="{{decryptDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var decrypt(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{decryptMessage}}") Var messageVar, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{decryptKey}}") Var keyVar) throws Exception {
        SecretKeySpec secretKey = Operations.getKey(keyVar.getObjectAsString());
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
        cipher.init(2, secretKey);
        byte[] message = messageVar.getObject() instanceof byte[] ? messageVar.getObjectAsByteArray() : Base64.getDecoder().decode(messageVar.getObjectAsString());
        byte[] outputBytes = cipher.doFinal(message);
        if (messageVar.getObject() instanceof byte[]) {
            return Var.valueOf(outputBytes);
        }
        return Var.valueOf(new String(outputBytes));
    }

    @CronapiMetaData(type="function", name="{{getFromThread}}", nameTags={"getFromSession"}, description="{{getFromThreadDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getFromThread(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fieldName}}") Var fieldName) throws Exception {
        return Var.valueOf(RestClient.getRestClient().getThreadValue(fieldName.toString()));
    }

    @CronapiMetaData(type="function", name="{{setInThread}}", nameTags={"setInSession"}, description="{{setInThreadDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final void setInThread(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fieldName}}") Var fieldName, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fieldValue}}") Var fieldValue) throws Exception {
        RestClient.getRestClient().updateThreadValue(fieldName.toString(), fieldValue);
    }

    @CronapiMetaData(type="function", name="{{getFromRequest}}", nameTags={"getFromSession"}, description="{{getFromRequestDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getFromRequest(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fieldName}}") Var fieldName) throws Exception {
        return Var.valueOf(RestClient.getRestClient().getRequestValue(fieldName.toString()));
    }

    @CronapiMetaData(type="function", name="{{setInRequest}}", nameTags={"setInSession"}, description="{{setInThreadDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final void setInRequest(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fieldName}}") Var fieldName, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fieldValue}}") Var fieldValue) throws Exception {
        RestClient.getRestClient().updateRequestValue(fieldName.toString(), fieldValue);
    }

    private static Integer getFactorByMeasurementUnit(String measurementUnit) {
        int factor = 0;
        if (measurementUnit.equals("SECONDS")) {
            factor = 1;
        } else if (measurementUnit.equals("MINUTES")) {
            factor = 60;
        } else if (measurementUnit.equals("HOURS")) {
            factor = 3600;
        } else if (measurementUnit.equals("DAYS")) {
            factor = 86400;
        }
        return factor;
    }

    private static Integer getMaxAge(Integer expiration, Integer factor) {
        int maxAge = 0;
        maxAge = expiration.toString().isEmpty() || expiration == 0 ? Integer.MAX_VALUE : expiration * factor;
        return maxAge;
    }

    private static String createDataCookie(String key, String value, Integer maxAge, boolean httpOnly, boolean secure) {
        StringBuilder sb = new StringBuilder();
        sb.append(key).append("=").append(value).append("; ");
        sb.append("Max-Age").append("=").append(maxAge).append("; ");
        sb.append("SameSite").append("=").append("Lax").append("; ");
        sb.append("Path").append("=").append("/");
        if (httpOnly) {
            sb.append("; ").append("HttpOnly");
        }
        if (secure) {
            sb.append("; ").append("Secure");
        }
        return sb.toString();
    }

    public static Var setCookie(Var key, Var value, Var measurementUnit, Var expiration) throws Exception {
        return Operations.setCookie(key, value, measurementUnit, expiration, Var.VAR_FALSE, Var.VAR_FALSE);
    }

    @CronapiMetaData(type="function", name="{{setCookie}}", nameTags={"Cookie", "Storage"}, description="{{setCookieDesc}}")
    public static Var setCookie(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{cookieKey}}") Var key, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{cookieValue}}") Var value, @ParamMetaData(description="{{measurementUnit}}", blockType="util_dropdown", keys={"SECONDS", "MINUTES", "HOURS", "DAYS"}, values={"{{SECONDS}}", "{{MINUTES}}", "{{HOURS}}", "{{DAYS}}"}) Var measurementUnit, @ParamMetaData(type=CronapiMetaData.ObjectType.LONG, description="{{expirationTime}}") Var expiration, @ParamMetaData(type=CronapiMetaData.ObjectType.BOOLEAN, description="{{httpOnly}}", blockType="util_dropdown", keys={"true", "false"}, values={"{{yes}}", "{{no}}"}, defaultValue="true") Var httpOnly, @ParamMetaData(type=CronapiMetaData.ObjectType.BOOLEAN, description="{{secure}}", blockType="util_dropdown", keys={"true", "false"}, values={"{{yes}}", "{{no}}"}, defaultValue="true") Var secure) throws Exception {
        int factor = Operations.getFactorByMeasurementUnit(measurementUnit.getObjectAsString());
        int maxAge = Operations.getMaxAge(expiration.getObjectAsInt(), factor);
        HttpServletResponse res = RestClient.getRestClient().getResponse();
        key = Var.valueOf(URLEncoder.encode(key.getObjectAsString(), DEFAULT_CHARSET));
        res.addHeader("Set-Cookie", Operations.createDataCookie(key.getObjectAsString(), value.getObjectAsString(), maxAge, httpOnly.getObjectAsBoolean(), secure.getObjectAsBoolean()));
        return Var.VAR_NULL;
    }

    @CronapiMetaData(type="function", name="{{getCookie}}", nameTags={"Cookie", "Storage"}, description="{{getCookieDesc}}")
    public static Var getCookie(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{cookieKey}}") Var key) throws Exception {
        String value = null;
        HttpServletRequest req = RestClient.getRestClient().getRequest();
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(URLEncoder.encode(key.getObjectAsString(), DEFAULT_CHARSET))) continue;
                value = cookie.getValue();
                break;
            }
        }
        return Var.valueOf(value);
    }

    @CronapiMetaData(type="function", name="{{getBaseUrl}}", nameTags={"Base", "Url"}, description="{{getBaseUrlDesc}}")
    public static Var getBaseUrl() throws Exception {
        StringBuffer sb = new StringBuffer();
        HttpServletRequest req = RestClient.getRestClient().getRequest();
        String scheme = StringUtils.defaultString((String)req.getHeader("X-Forwarded-Proto"), (String)req.getScheme());
        String serverName = StringUtils.defaultString((String)req.getHeader("X-Forwarded-Host"), (String)req.getServerName());
        String port = StringUtils.defaultString((String)req.getHeader("X-Forwarded-Port"), (String)String.valueOf(req.getServerPort()));
        sb.append(scheme).append("://").append(serverName);
        if (!(StringUtils.isBlank((CharSequence)port) || scheme.equals("http") && port.equals("80") || scheme.equals("https") && port.equals("443"))) {
            sb.append(":").append(port);
        }
        return Var.valueOf(sb);
    }

    @CronapiMetaData(type="function", name="{{callSOAP}}", nameTags={"SOAP", "webservices", "ws", "envelope", "url"}, description="{{callSOAPDesc}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var callSOAP(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{callSOAPurlVar}}") Var urlVar, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{callSOAPsoapAction}}") Var soapAction, @ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{callSOAPheaders}}") Var headers, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{callSOAPcontent}}") Var content) throws Exception {
        Header header;
        Var result = Var.VAR_NULL;
        CloseableHttpClient client = CustomHttpClient.create();
        String url = urlVar.getObjectAsString();
        HttpPost httpPost = new HttpPost(url);
        if (!soapAction.isEmptyOrNull().booleanValue()) {
            httpPost.setHeader("SOAPAction", soapAction.getObjectAsString());
        }
        if (headers.getObject() instanceof Map) {
            Map headersMap = headers.getObjectAsMap();
            headersMap.entrySet().forEach(entry -> httpPost.addHeader(Var.valueOf(entry.getKey()).getObjectAsString(), Var.valueOf(entry.getValue()).getObjectAsString()));
        }
        if ((header = httpPost.getFirstHeader("Content-Type")) == null) {
            httpPost.addHeader("Content-Type", "text/xml");
        }
        StringEntity entity = new StringEntity(content.getObjectAsString(), CronapiConfigurator.ENCODING);
        httpPost.setEntity((HttpEntity)entity);
        HttpResponse response = client.execute((HttpUriRequest)httpPost);
        if (response != null && response.getStatusLine().getStatusCode() >= 400) {
            throw new RuntimeException(response.getStatusLine().getReasonPhrase());
        }
        HttpEntity responseEntity = response.getEntity();
        if (responseEntity != null) {
            result = Var.valueOf(EntityUtils.toString((HttpEntity)responseEntity));
        }
        return result;
    }

    @CronapiMetaData(type="function", name="{{getIP}}", nameTags={"Ip", "Obter Ip"}, description="{{getIpDesc}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var getIp() throws Exception {
        RestClient.getRestClient();
        String probableIp = RestClient.getClientIpAddress();
        if (StringUtils.isNotEmpty((CharSequence)probableIp) && probableIp.contains(",")) {
            probableIp = probableIp.split(",")[0];
        }
        return Var.valueOf(probableIp);
    }

    private static /* synthetic */ void lambda$getContentFromURL$1(LinkedList paramsData, HttpRequestBase httpMethod, Object key, Object value) {
        String obj = String.valueOf(value);
        if (value instanceof Var) {
            obj = ((Var)value).getObjectAsString();
        }
        BasicNameValuePair item = new BasicNameValuePair(String.valueOf(key), obj);
        paramsData.add(item);
        httpMethod.getParams().setParameter(URLEncoder.encode(String.valueOf(key)), (Object)obj);
    }

    private static /* synthetic */ void lambda$getContentFromURL$0(HttpRequestBase httpMethod, Map.Entry entry) {
        httpMethod.addHeader(Var.valueOf(entry.getKey()).getObjectAsString(), Var.valueOf(entry.getValue()).getObjectAsString());
    }

    static {
        THREAD_POOLSIZE = 50;
        LOGGERS = new ConcurrentHashMap();
        LOG_LEVEL = Level.INFO;
        LOG_DEFINED = false;
        if (!StringUtils.isEmpty((CharSequence)System.getenv("CronappLogLevel"))) {
            LOG_LEVEL = Operations.toLevel(System.getenv("CronappLogLevel"));
            LOG_DEFINED = true;
        } else if (!StringUtils.isEmpty((CharSequence)System.getProperty("CronappLogLevel"))) {
            LOG_LEVEL = Operations.toLevel(System.getProperty("CronappLogLevel"));
            LOG_DEFINED = true;
        }
        String SO = System.getProperty("os.name");
        if (SO.indexOf(32) > -1) {
            SO = SO.substring(0, SO.indexOf(32));
        }
        IS_WINDOWS = SO.equalsIgnoreCase("Windows");
        IS_LINUX = SO.equalsIgnoreCase("Linux");
        String cmd = ManagementFactory.getRuntimeMXBean().getInputArguments().toString();
        IS_DEBUG = cmd.indexOf("-agentlib:jdwp") > 0 || cmd.indexOf("-Xrunjdwp") > 0;
        threadPool = Executors.newFixedThreadPool(THREAD_POOLSIZE);
        executor = new ScheduledThreadPoolExecutor(THREAD_POOLSIZE);
        DEFAULT_CHARSET = StandardCharsets.UTF_8.toString();
    }
}

