/*
 * Decompiled with CFR 0.152.
 */
package cronapi.database;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.google.gson.JsonObject;
import cronapi.QueryManager;
import cronapi.RestClient;
import cronapi.Utils;
import cronapi.Var;
import cronapi.cloud.FieldData;
import cronapi.database.CronappDescriptorQueryManager;
import cronapi.database.CronappMultitenantPolicy;
import cronapi.database.DataSourceFilter;
import cronapi.database.EntityMetadata;
import cronapi.database.JPAUtil;
import cronapi.database.JPQLConverter;
import cronapi.database.NativeDatasource;
import cronapi.database.RelationMetadata;
import cronapi.database.TransactionManager;
import cronapi.i18n.Messages;
import cronapi.odata.server.DatasourceExtension;
import cronapi.odata.server.JPQLParserUtil;
import cronapi.rest.security.CronappSecurity;
import cronapi.util.ReflectionUtils;
import cronapi.util.StorageService;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.jpa.processor.core.ODataJPAConfig;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmModel;
import org.eclipse.persistence.annotations.Multitenant;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.MultitenantPolicy;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.jpql.HermesParser;
import org.eclipse.persistence.internal.jpa.metamodel.EntityTypeImpl;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.GrantedAuthority;

public class DataSource
implements JsonSerializable {
    private static final Logger log = LoggerFactory.getLogger(DataSource.class);
    private JsonObject customQuery;
    private String entity;
    private String simpleEntity;
    private Class domainClass;
    private String filter;
    private Var[] params;
    private int pageSize;
    private Page page;
    private int index;
    private int current;
    private Pageable pageRequest;
    private Object insertedElement = null;
    private EntityManager customEntityManager;
    private DataSourceFilter dsFilter;
    private boolean multiTenant = true;
    private boolean plainData = false;
    private boolean useUrlParams = false;
    private boolean countData = false;
    private boolean useOdataRequest = false;
    private boolean isEor = false;
    private boolean useOffset = false;
    private DatabaseQuery queryParsed;
    private String namespace;
    private boolean isNative;
    private boolean alowFetchNext = true;

    public DataSource(String entity) {
        this(entity, 100);
    }

    public DataSource(JsonObject query) {
        this(query.get("entityFullName").getAsString(), 100);
        this.customQuery = query;
        QueryManager.checkMultiTenant(query, this);
    }

    public DataSource(String entity, EntityManager entityManager) {
        this(entity, 100);
        this.customEntityManager = entityManager;
    }

    public DataSource(String entity, int pageSize) {
        if (entity.contains(".entity.")) {
            CronappDescriptorQueryManager.enableMultitenant();
            this.entity = entity;
            this.simpleEntity = entity.substring(entity.lastIndexOf(".") + 1);
            this.pageSize = pageSize;
            this.pageRequest = PageRequest.of((int)0, (int)pageSize);
            this.instantiateRepository();
        } else {
            this.instanceNative(entity, pageSize);
        }
    }

    private void instanceNative(String namespace, int pageSize) {
        this.namespace = namespace;
        this.pageSize = pageSize;
        this.pageRequest = PageRequest.of((int)0, (int)pageSize);
        this.isNative = true;
    }

    public EntityManager getEntityManager(Class domainClass) {
        EntityManager em = this.customEntityManager != null ? this.customEntityManager : TransactionManager.getEntityManager(domainClass);
        this.enableTenantToogle(em);
        return em;
    }

    public Class getDomainClass() {
        return this.domainClass;
    }

    public String getSimpleEntity() {
        return this.simpleEntity;
    }

    public String getEntity() {
        return this.entity;
    }

    private void instantiateRepository() {
        try {
            this.domainClass = Class.forName(this.entity);
        }
        catch (ClassNotFoundException cnfex) {
            throw new RuntimeException(cnfex);
        }
    }

    private void enableTenantToogle(EntityManager em) {
        try {
            for (javax.persistence.metamodel.EntityType type : em.getMetamodel().getEntities()) {
                DescriptorQueryManager old = ((EntityTypeImpl)type).getDescriptor().getQueryManager();
                ClassDescriptor desc = ((EntityTypeImpl)type).getDescriptor();
                if (desc.getMultitenantPolicy() != null && !(desc.getMultitenantPolicy() instanceof CronappMultitenantPolicy)) {
                    desc.setMultitenantPolicy((MultitenantPolicy)new CronappMultitenantPolicy(desc.getMultitenantPolicy()));
                }
                if (!CronappDescriptorQueryManager.needProxy(old)) continue;
                desc.setQueryManager(CronappDescriptorQueryManager.build(old));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void startMultitenant(EntityManager em) {
        if (!this.multiTenant) {
            CronappDescriptorQueryManager.disableMultitenant();
        }
    }

    private void endMultitetant() {
        if (!this.multiTenant) {
            CronappDescriptorQueryManager.enableMultitenant();
        }
    }

    public long count() {
        Long[] total = (Long[])this.fetch(true);
        if (total != null && total.length > 0) {
            return total[0];
        }
        return 0L;
    }

    public Object[] fetch() {
        return this.fetch(false);
    }

    public Object[] fetch(boolean isCount) {
        this.isEor = false;
        if (this.isNative) {
            return this.fetchNative(isCount);
        }
        Object jpql = this.filter;
        Var[] params = this.params;
        if (jpql == null) {
            jpql = "select e from " + this.simpleEntity + " e";
        }
        boolean containsNoTenant = ((String)jpql).contains("/*notenant*/");
        jpql = ((String)jpql).replace("/*notenant*/", "");
        if (containsNoTenant) {
            this.multiTenant = false;
        }
        if (this.dsFilter != null) {
            this.dsFilter.applyTo(this.domainClass, (String)jpql, params);
            params = this.dsFilter.getAppliedParams();
            jpql = this.dsFilter.getAppliedJpql();
        }
        try {
            int idx;
            String realParamName;
            boolean namedParams = params.length > 0 && params[0].getId() != null || this.useUrlParams;
            JPQLParserUtil.ODataInfo info = null;
            if (this.useOdataRequest && (info = JPQLParserUtil.addODdataRequest((String)jpql, params)) != null) {
                if (info.jpql != null) {
                    jpql = info.jpql;
                }
                if (info.params != null) {
                    params = info.params;
                }
            }
            List<String> parsedParams = JPQLParserUtil.parseParams((String)jpql);
            int o = 0;
            for (String string : parsedParams) {
                jpql = ((String)jpql).replaceFirst(":" + string, ":param" + o);
                ++o;
            }
            LinkedHashMap<String, Var> paramsValues = null;
            if (namedParams) {
                paramsValues = new LinkedHashMap<String, Var>();
                if (this.useUrlParams) {
                    for (String key : parsedParams) {
                        paramsValues.put(key, Var.valueOf(RestClient.getRestClient().getParameter(key)));
                    }
                } else {
                    for (Var p : params) {
                        paramsValues.put(p.getId(), p);
                    }
                }
            }
            EntityManager entityManager = this.getEntityManager(this.domainClass);
            this.startMultitenant(entityManager);
            AbstractSession session = (AbstractSession)((EntityManagerImpl)entityManager.getDelegate()).getActiveSession();
            HermesParser parser = new HermesParser();
            DatabaseQuery queryParsed = parser.buildQuery((CharSequence)jpql, session);
            EJBQueryImpl query = new EJBQueryImpl((String)jpql, (EntityManagerImpl)entityManager.getDelegate());
            JPAUtil.prepareQuery((Query)query);
            List argsTypes = queryParsed.getArgumentTypes();
            List argsNames = queryParsed.getArguments();
            for (String name : argsNames) {
                query.setParameter(name, null);
            }
            if (namedParams) {
                for (int i = 0; i < parsedParams.size(); ++i) {
                    String paramName = "param" + i;
                    realParamName = parsedParams.get(i);
                    idx = argsNames.indexOf(paramName);
                    Var value = (Var)paramsValues.get(realParamName);
                    if (this.customQuery != null && QueryManager.hasParameterValue(this.customQuery, realParamName)) {
                        query.setParameter(paramName, QueryManager.getParameterValue(this.customQuery, realParamName, new HashMap<String, Var>()).getObject((Class)argsTypes.get(idx)));
                        continue;
                    }
                    if (value == null) continue;
                    query.setParameter(paramName, value.getObject((Class)argsTypes.get(idx)));
                }
            } else {
                for (int i2 = 0; i2 < parsedParams.size(); ++i2) {
                    String param = "param" + i2;
                    realParamName = parsedParams.get(i2);
                    idx = argsNames.indexOf(param);
                    Var p = null;
                    if (i2 <= params.length - 1) {
                        p = params[i2];
                    }
                    if (this.customQuery != null && QueryManager.hasParameterValue(this.customQuery, realParamName)) {
                        query.setParameter(param, QueryManager.getParameterValue(this.customQuery, realParamName, new HashMap<String, Var>()).getObject((Class)argsTypes.get(idx)));
                        continue;
                    }
                    if (p != null) {
                        query.setParameter(param, p.getObject((Class)argsTypes.get(idx)));
                        continue;
                    }
                    query.setParameter(param, null);
                }
            }
            if (this.pageRequest != null && !isCount) {
                if (info != null && info.first != null) {
                    query.setFirstResult(info.first.intValue());
                } else if (this.useOffset) {
                    query.setFirstResult(this.pageRequest.getPageNumber());
                } else {
                    query.setFirstResult(this.pageRequest.getPageNumber() * this.pageRequest.getPageSize());
                }
                if (info != null && info.max != null) {
                    query.setMaxResults(info.max.intValue());
                } else {
                    query.setMaxResults(this.pageRequest.getPageSize());
                }
            }
            if (isCount) {
                Object[] i2 = new Long[]{JPQLParserUtil.countAsLong((String)jpql, (Query)query, entityManager)};
                return i2;
            }
            List resultsInPage = query.getResultList();
            if (this.plainData && !isCount) {
                String context = this.entity.substring(0, this.entity.indexOf("."));
                JPAEdmModel model = new JPAEdmModel(entityManager.getMetamodel(), context);
                model.getBuilder().build();
                DatasourceExtension extension = new DatasourceExtension((EntityManagerImpl)entityManager, 1);
                extension.jpql((String)jpql, false);
                extension.extendJPAEdmSchema(model.getEdmSchemaView().getEdmSchema());
                resultsInPage = this.normalizeList(resultsInPage, extension.getJpqlEntity());
            }
            Long total = 0L;
            if (!isCount) {
                Object[] countResult;
                if (this.countData && !ArrayUtils.isEmpty((Object[])(countResult = this.fetch(true)))) {
                    total = (Long)countResult[0];
                }
                this.queryParsed = queryParsed;
            }
            this.page = new PageImpl(resultsInPage, this.pageRequest, total.longValue());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.enableMultiTenant();
        }
        if (this.page.getNumberOfElements() > 0) {
            this.current = 0;
        }
        if (isCount) {
            return new Long[]{(long)((Long)this.page.getContent().get(0))};
        }
        return this.page.getContent().toArray();
    }

    private List normalizeList(List entities, EntityType entityType) {
        if (entities != null && !entities.isEmpty()) {
            try {
                LinkedList<Var> newEntities = new LinkedList<Var>();
                for (Object e : entities) {
                    if (Objects.isNull(e)) continue;
                    Var entity = Var.valueOf(new LinkedHashMap());
                    for (Property property : entityType.getProperties()) {
                        if (property.getComposite() != null) {
                            Object value = "";
                            for (Property p : property.getComposite()) {
                                JPAEdmMappingImpl mapping;
                                Object compositeObj;
                                Object compositeValue;
                                if (!((String)value).isEmpty()) {
                                    value = (String)value + ODataJPAConfig.COMPOSITE_SEPARATOR;
                                }
                                if ((compositeValue = this.getPropertyValue(p, compositeObj = (mapping = (JPAEdmMappingImpl)property.getMapping()).getComplexIndex() != -1 && e.getClass().isArray() && !(e instanceof byte[]) ? Var.valueOf(((Object[])e)[mapping.getComplexIndex()]) : e, p.isForeignKey())) == null) {
                                    value = (String)value + "null";
                                    continue;
                                }
                                value = (String)value + Var.valueOf(compositeValue).getObjectAsString();
                            }
                            entity.set(property.getName(), value);
                            continue;
                        }
                        String key = property.getName();
                        entity.set(key, this.getPropertyValue(property, e, property.isForeignKey()));
                    }
                    newEntities.add(entity);
                }
                entities = newEntities;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return entities;
    }

    private Object getPropertyValue(Property property, Object obj, boolean isForeignKey) {
        JPAEdmMappingImpl mapping = (JPAEdmMappingImpl)property.getMapping();
        if (mapping != null) {
            Var sub = mapping.getComplexIndex() != -1 && obj.getClass().isArray() && !(obj instanceof byte[]) ? Var.valueOf(((Object[])obj)[mapping.getComplexIndex()]) : Var.valueOf(obj);
            if (mapping.isPath()) {
                return sub.get(mapping.getPath());
            }
            if (!isForeignKey) {
                return sub.get(mapping.getInternalName());
            }
            Object result = sub.get(mapping.getInternalName().substring(mapping.getInternalName().indexOf(".") + 1));
            if (result != null) {
                return result;
            }
            if (obj.getClass().isArray()) {
                for (Object objCheck : (Object[])obj) {
                    sub = Var.valueOf(objCheck);
                    result = sub.get(mapping.getInternalName().substring(mapping.getInternalName().indexOf(".") + 1));
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    public EntityMetadata getMetadata() {
        return new EntityMetadata(this.domainClass);
    }

    public void insert() {
        try {
            this.insertedElement = this.domainClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object toObject(Map<?, ?> values) {
        try {
            Object insertedElement = this.domainClass.newInstance();
            for (Object key : values.keySet()) {
                Utils.updateFieldOnFiltered(insertedElement, key.toString(), values.get(key));
            }
            return insertedElement;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void insert(Object value) {
        try {
            if (value instanceof Var) {
                value = ((Var)value).getObject();
            }
            if (value instanceof Map) {
                this.insertedElement = this.domainClass.newInstance();
                Map values = (Map)value;
                for (Object key : values.keySet()) {
                    try {
                        this.updateField(key.toString(), values.get(key));
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.insertedElement = value;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object save() {
        return this.save(true);
    }

    private void processCloudFields(Object toSaveParam) {
        Object toSave = toSaveParam != null ? toSaveParam : (this.insertedElement != null ? this.insertedElement : this.getObject());
        if (toSave != null) {
            Utils.processCloudFields(toSave);
        }
    }

    public Object save(boolean returnCursorAfterInsert) {
        return this.save(returnCursorAfterInsert, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object save(boolean returnCursorAfterInsert, boolean returnRefreshed) {
        try {
            Object saved;
            this.processCloudFields(null);
            EntityManager em = this.getEntityManager(this.domainClass);
            try {
                Object toSave;
                this.startMultitenant(em);
                if (!em.getTransaction().isActive()) {
                    em.getTransaction().begin();
                }
                boolean merge = true;
                if (this.insertedElement != null) {
                    toSave = this.insertedElement;
                    if (returnCursorAfterInsert) {
                        this.insertedElement = null;
                    }
                    if (!returnRefreshed) {
                        for (Field field : toSave.getClass().getDeclaredFields()) {
                            try {
                                Object value = ReflectionUtils.getField(toSave, field.getName());
                                if (value == null || !Utils.isEntityClass(value)) continue;
                                ((UnitOfWorkImpl)((EntityManagerImpl)em.getDelegate()).getUnitOfWork()).getCloneMapping().put(value, value);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        merge = false;
                    }
                    em.persist(toSave);
                } else {
                    toSave = this.getObject();
                }
                saved = merge ? em.merge(toSave) : toSave;
                if (toSave.getClass().getAnnotation(Multitenant.class) != null) {
                    em.flush();
                    if (this.multiTenant) {
                        em.refresh(toSave);
                    }
                }
            }
            finally {
                this.endMultitetant();
            }
            return saved;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object saveAfterCommit(AbstractSession session) {
        try {
            Object toSave;
            if (this.insertedElement != null) {
                toSave = this.insertedElement;
                session.insertObject(toSave);
            } else {
                toSave = this.getObject();
            }
            return toSave;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(Var[] primaryKeys) {
        this.insert();
        int i = 0;
        Var[] params = new Var[primaryKeys.length];
        EntityManager em = this.getEntityManager(this.domainClass);
        javax.persistence.metamodel.EntityType type = em.getMetamodel().entity(this.domainClass);
        String jpql = " DELETE FROM " + this.entity.substring(this.entity.lastIndexOf(".") + 1) + " WHERE ";
        List<TypeKey> keys = this.getKeys(type);
        boolean first = true;
        for (TypeKey key : keys) {
            if (!first) {
                jpql = jpql + " AND ";
            }
            first = false;
            jpql = jpql + key.name + " = :p" + i;
            params[i] = Var.valueOf("p" + i, primaryKeys[i].getObject(key.field.getType().getJavaType()));
            ++i;
        }
        this.execute(jpql, params);
    }

    public void delete() {
        EntityManager em = this.getEntityManager(this.domainClass);
        try {
            Object toRemove = this.getObject();
            this.startMultitenant(em);
            if (!em.getTransaction().isActive()) {
                em.getTransaction().begin();
            }
            toRemove = em.merge(toRemove);
            em.remove(toRemove);
            if (!this.multiTenant) {
                em.flush();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.endMultitetant();
        }
    }

    public void updateField(String fieldName, Object fieldValue) {
        Utils.updateFieldOnFiltered(this.getObject(), fieldName, fieldValue);
    }

    public void updateFields(Var ... fields) {
        for (Var field : fields) {
            this.updateField(field.getId(), field.getObject());
        }
    }

    public void filterByPk(Var[] params) {
        this.filter(null, PageRequest.of((int)1, (int)1), params);
    }

    public void filter(Var data, Var[] extraParams) {
        EntityManager em = this.getEntityManager(this.domainClass);
        javax.persistence.metamodel.EntityType type = em.getMetamodel().entity(this.domainClass);
        int i = 0;
        String jpql = " select e FROM " + this.entity.substring(this.entity.lastIndexOf(".") + 1) + " e WHERE ";
        Vector<Var> params = new Vector<Var>();
        for (Object obj : JPAUtil.getAjustedAttributes(type)) {
            SingularAttribute field = (SingularAttribute)obj;
            if (!field.isId()) continue;
            if (i > 0) {
                jpql = jpql + " AND ";
            }
            jpql = jpql + "e." + field.getName() + " = :p" + i;
            params.add(Var.valueOf("p" + i, data.getField(field.getName()).getObject(field.getType().getJavaType())));
            ++i;
        }
        if (extraParams != null) {
            for (Var p : extraParams) {
                jpql = jpql + "e." + p.getId() + " = :p" + i;
                params.add(Var.valueOf("p" + i, p.getObject()));
                ++i;
            }
        }
        Var[] arr = params.toArray(new Var[params.size()]);
        this.filter(jpql, arr);
    }

    public void update(Var data) {
        try {
            List<String> fieldsByteHeaderSignature = Utils.getFieldsWithAnnotationByteHeaderSignature(this.domainClass);
            LinkedList<String> fields = data.keySet();
            for (String key : fields) {
                if (fieldsByteHeaderSignature.contains(key) && !this.isFieldByteWithoutHeader(key, data.getField(key)) || key.equalsIgnoreCase(Class.class.getSimpleName())) continue;
                try {
                    this.updateField(key, data.getField(key));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isFieldByteWithoutHeader(String fieldName, Object fieldValue) {
        Method setMethod;
        boolean result = false;
        if (fieldValue instanceof Var) {
            if (((Var)fieldValue).getObject() == null) {
                return true;
            }
            if (StorageService.isTempFileJson(((Var)fieldValue).getObject().toString())) {
                return true;
            }
        }
        if ((setMethod = Utils.findMethod(this.getObject(), "set" + fieldName)) != null) {
            if (fieldValue instanceof Var) {
                fieldValue = ((Var)fieldValue).getObject(setMethod.getParameterTypes()[0]);
            } else {
                Var tVar = Var.valueOf(fieldValue);
                fieldValue = tVar.getObject(setMethod.getParameterTypes()[0]);
            }
            byte[] header = StorageService.getFileBytesMetadata((byte[])fieldValue);
            result = header == null;
        }
        return result;
    }

    public Object getObject() {
        if (this.insertedElement != null) {
            return this.insertedElement;
        }
        if (this.current < 0 || this.current > this.page.getContent().size() - 1) {
            return null;
        }
        return this.page.getContent().get(this.current);
    }

    public Object getObject(String fieldName) {
        try {
            Method getMethod = Utils.findMethod(this.getObject(), "get" + fieldName);
            if (getMethod != null) {
                return getMethod.invoke(this.getObject(), new Object[0]);
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void next() {
        if (this.isEor) {
            this.current = -1;
            return;
        }
        if (this.page.getNumberOfElements() > this.current + 1) {
            ++this.current;
        } else if (this.alowFetchNext) {
            this.pageRequest = PageRequest.of((int)(this.page.getNumber() + 1), (int)this.page.getSize());
            this.fetch();
            if (this.page.getNumberOfElements() > 0) {
                this.current = 0;
            } else {
                this.current = -1;
                this.isEor = true;
            }
        } else {
            this.isEor = true;
            this.current = -1;
        }
    }

    public void nextOnPage() {
        ++this.current;
    }

    public boolean hasNext() {
        if (this.page.getNumberOfElements() > this.current + 1) {
            return true;
        }
        return this.page.hasNext();
    }

    public boolean hasData() {
        return this.getObject() != null;
    }

    public boolean previous() {
        if (this.current - 1 >= 0) {
            --this.current;
        } else if (this.page.hasPrevious()) {
            this.pageRequest = this.page.previousPageable();
            this.fetch();
            this.current = this.page.getNumberOfElements() - 1;
        } else {
            return false;
        }
        return true;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getCurrent() {
        return this.current;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.pageRequest = PageRequest.of((int)0, (int)pageSize);
        this.current = -1;
    }

    public void filter(String filter, Var ... params) {
        this.filter = filter;
        this.params = params;
        this.pageRequest = PageRequest.of((int)0, (int)this.pageSize);
        this.current = -1;
        this.fetch();
    }

    public void setDataSourceFilter(DataSourceFilter dsFilter) {
        this.dsFilter = dsFilter;
    }

    public void filter(String filter, PageRequest pageRequest, Var ... params) {
        if (filter == null) {
            if (params.length > 0) {
                EntityManager em = this.getEntityManager(this.domainClass);
                javax.persistence.metamodel.EntityType type = em.getMetamodel().entity(this.domainClass);
                int i = 0;
                String jpql = "Select e from " + this.simpleEntity + " e where (";
                for (Object obj : JPAUtil.getAjustedAttributes(type)) {
                    SingularAttribute field = (SingularAttribute)obj;
                    if (!field.isId()) continue;
                    if (i > 0) {
                        jpql = jpql + " and ";
                    }
                    jpql = jpql + "e." + field.getName() + " = :p" + i;
                    params[i].setId("p" + i);
                    ++i;
                }
                jpql = jpql + ")";
                filter = jpql;
            } else {
                filter = "Select e from " + this.simpleEntity + " e ";
            }
        } else {
            List<String> parsedParams = JPQLParserUtil.parseParams((String)filter);
            if (params.length > parsedParams.size() && this.domainClass != null) {
                String alias = JPQLConverter.getAliasFromSql((String)filter);
                EntityManager em = this.getEntityManager(this.domainClass);
                javax.persistence.metamodel.EntityType type = em.getMetamodel().entity(this.domainClass);
                int i = 0;
                Object filterForId = " (";
                for (Object obj : JPAUtil.getAjustedAttributes(type)) {
                    SingularAttribute field = (SingularAttribute)obj;
                    if (!field.isId()) continue;
                    if (i > 0) {
                        filterForId = (String)filterForId + " and ";
                    }
                    filterForId = (String)filterForId + alias + "." + field.getName() + " = :id" + i;
                    ++i;
                }
                filterForId = (String)filterForId + ")";
                filterForId = ((String)filter).toLowerCase().indexOf("where") > -1 ? " and " + (String)filterForId : " where " + (String)filterForId;
                filter = Utils.addFilterInSQLClause((String)filter, (String)filterForId);
            }
        }
        this.params = params;
        this.filter = filter;
        this.pageRequest = pageRequest;
        this.current = -1;
        this.fetch();
    }

    private Class forName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Object newInstance(String name) {
        try {
            return Class.forName(name).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void alowFetchNext(boolean alowFetchNext) {
        this.alowFetchNext = alowFetchNext;
    }

    private void addKeys(EntityManager em, javax.persistence.metamodel.EntityType type, String parent, List<TypeKey> keys) {
        for (Object obj : JPAUtil.getAjustedAttributes(type)) {
            SingularAttribute field = (SingularAttribute)obj;
            if (!field.isId()) continue;
            if (field.getType().getPersistenceType() == Type.PersistenceType.BASIC) {
                TypeKey key = new TypeKey();
                key.name = parent == null ? field.getName() : parent + "." + field.getName();
                key.field = field;
                keys.add(key);
                continue;
            }
            javax.persistence.metamodel.EntityType subType = (javax.persistence.metamodel.EntityType)field.getType();
            this.addKeys(em, subType, (String)(parent == null ? field.getName() : parent + "." + field.getName()), keys);
        }
    }

    private List<TypeKey> getKeys(javax.persistence.metamodel.EntityType type) {
        EntityManager em = this.getEntityManager(this.domainClass);
        LinkedList<TypeKey> keys = new LinkedList<TypeKey>();
        this.addKeys(em, type, null, keys);
        return keys;
    }

    public void deleteRelation(String refId, Var[] primaryKeys, Var[] relationKeys) {
        EntityMetadata metadata = this.getMetadata();
        RelationMetadata relationMetadata = metadata.getRelations().get(refId);
        EntityManager em = this.getEntityManager(this.domainClass);
        int i = 0;
        String jpql = null;
        Var[] params = null;
        if (relationMetadata.getAssossiationName() != null) {
            params = new Var[relationKeys.length + primaryKeys.length];
            jpql = " DELETE FROM " + relationMetadata.gettAssossiationSimpleName() + " WHERE ";
            javax.persistence.metamodel.EntityType type = em.getMetamodel().entity(this.domainClass);
            List<TypeKey> keys = this.getKeys(type);
            for (TypeKey typeKey : keys) {
                if (i > 0) {
                    jpql = (String)jpql + " AND ";
                }
                jpql = (String)jpql + relationMetadata.getAssociationAttribute().getName() + "." + typeKey.name + " = :p" + i;
                params[i] = Var.valueOf("p" + i, primaryKeys[i].getObject(typeKey.field.getType().getJavaType()));
                ++i;
            }
            int v = 0;
            type = em.getMetamodel().entity(this.forName(relationMetadata.getAssossiationName()));
            keys = this.getKeys(type);
            for (TypeKey key : keys) {
                if (i > 0) {
                    jpql = (String)jpql + " AND ";
                }
                jpql = (String)jpql + relationMetadata.getAttribute().getName() + "." + key.name + " = :p" + i;
                params[i] = Var.valueOf("p" + i, relationKeys[v].getObject(key.field.getType().getJavaType()));
                ++i;
                ++v;
            }
        } else {
            params = new Var[relationKeys.length];
            jpql = " DELETE FROM " + relationMetadata.getSimpleName() + " WHERE ";
            javax.persistence.metamodel.EntityType type = em.getMetamodel().entity(this.forName(relationMetadata.getName()));
            List<TypeKey> keys = this.getKeys(type);
            for (TypeKey typeKey : keys) {
                if (i > 0) {
                    jpql = jpql + " AND ";
                }
                jpql = jpql + typeKey.name + " = :p" + i;
                params[i] = Var.valueOf("p" + i, relationKeys[i].getObject(typeKey.field.getType().getJavaType()));
                ++i;
            }
        }
        this.execute(jpql, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object insertRelation(String refId, Map<?, ?> data, Var ... primaryKeys) {
        EntityMetadata metadata = this.getMetadata();
        RelationMetadata relationMetadata = metadata.getRelations().get(refId);
        EntityManager em = this.getEntityManager(this.domainClass);
        Object result = null;
        try {
            this.startMultitenant(em);
            this.filter(null, PageRequest.of((int)0, (int)100), primaryKeys);
            Object insertion = null;
            if (relationMetadata.getAssossiationName() != null) {
                insertion = this.newInstance(relationMetadata.getAssossiationName());
                Utils.updateFieldOnFiltered(insertion, relationMetadata.getAttribute().getName(), Var.valueOf(data).getObject(this.forName(relationMetadata.getName())));
                Utils.updateFieldOnFiltered(insertion, relationMetadata.getAssociationAttribute().getName(), this.getObject());
                result = this.getObject();
            } else {
                insertion = Var.valueOf(data).getObject(this.forName(relationMetadata.getName()));
                Utils.updateFieldOnFiltered(insertion, relationMetadata.getAttribute().getName(), this.getObject());
                result = insertion;
            }
            this.processCloudFields(insertion);
            if (!em.getTransaction().isActive()) {
                em.getTransaction().begin();
            }
            em.persist(insertion);
            if (!this.multiTenant) {
                em.flush();
            }
        }
        finally {
            this.endMultitetant();
        }
        return result;
    }

    public void resolveRelation(String refId) {
        EntityMetadata metadata = this.getMetadata();
        RelationMetadata relationMetadata = metadata.getRelations().get(refId);
        if (relationMetadata.getAssossiationName() != null) {
            try {
                this.domainClass = Class.forName(relationMetadata.getAttribute().getJavaType().getName());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            try {
                this.domainClass = Class.forName(relationMetadata.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public void filterByRelation(String refId, PageRequest pageRequest, Var ... primaryKeys) {
        EntityMetadata metadata = this.getMetadata();
        RelationMetadata relationMetadata = metadata.getRelations().get(refId);
        EntityManager em = this.getEntityManager(this.domainClass);
        javax.persistence.metamodel.EntityType type = null;
        String name = null;
        Object selectAttr = "";
        String filterAttr = relationMetadata.getAttribute().getName();
        type = em.getMetamodel().entity(this.domainClass);
        if (relationMetadata.getAssossiationName() != null) {
            name = relationMetadata.gettAssossiationSimpleName();
            selectAttr = "." + relationMetadata.getAttribute().getName();
            filterAttr = relationMetadata.getAssociationAttribute().getName();
            try {
                this.domainClass = Class.forName(relationMetadata.getAttribute().getJavaType().getName());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            name = relationMetadata.getSimpleName();
            try {
                this.domainClass = Class.forName(relationMetadata.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        int i = 0;
        String jpql = "Select e" + (String)selectAttr + " from " + name + " e where ";
        for (Object obj : JPAUtil.getAjustedAttributes(type)) {
            SingularAttribute field = (SingularAttribute)obj;
            if (!field.isId()) continue;
            if (i > 0) {
                jpql = jpql + " and ";
            }
            jpql = jpql + "e." + filterAttr + "." + field.getName() + " = :p" + i;
            primaryKeys[i].setId("p" + i);
        }
        this.filter(jpql, pageRequest, primaryKeys);
    }

    public void clear() {
        this.pageRequest = PageRequest.of((int)0, (int)100);
        this.current = -1;
        this.page = null;
    }

    public Var execute(String query, Var ... params) {
        if (this.isNative) {
            return this.executeNative(query, params);
        }
        EntityManager em = this.getEntityManager(this.domainClass);
        try {
            int i;
            this.startMultitenant(em);
            boolean namedParams = params.length > 0 && params[0].getId() != null || this.useUrlParams;
            List<String> parsedParams = JPQLParserUtil.parseParams(query);
            List<String> nonWhereParams = JPQLParserUtil.getNonWhereParams(query);
            int o = 0;
            for (String param : parsedParams) {
                query = query.replaceFirst(":" + param, ":param" + o);
                ++o;
            }
            TypedQuery strQuery = em.createQuery(query, this.domainClass);
            AbstractSession session = (AbstractSession)((EntityManagerImpl)em.getDelegate()).getActiveSession();
            LinkedHashMap<String, Var> paramsValues = null;
            if (namedParams) {
                paramsValues = new LinkedHashMap<String, Var>();
                if (this.useUrlParams) {
                    for (String key : parsedParams) {
                        paramsValues.put(key, Var.valueOf(RestClient.getRestClient().getParameter(key)));
                    }
                } else {
                    for (Var p : params) {
                        paramsValues.put(p.getId(), p);
                    }
                }
            }
            HermesParser parser = new HermesParser();
            DatabaseQuery queryParsed = parser.buildQuery((CharSequence)query, session);
            List argsTypes = queryParsed.getArgumentTypes();
            List argsNames = queryParsed.getArguments();
            for (String name : argsNames) {
                strQuery.setParameter(name, null);
            }
            Object instanceForUpdate = this.domainClass.newInstance();
            if (namedParams) {
                for (i = 0; i < parsedParams.size(); ++i) {
                    Var value;
                    String paramName = "param" + i;
                    String realParamName = parsedParams.get(i);
                    if (paramsValues == null || (value = (Var)paramsValues.get(realParamName)) == null) continue;
                    int idx = argsNames.indexOf(paramName);
                    strQuery.setParameter(paramName, value.getObject((Class)argsTypes.get(idx)));
                    if (!nonWhereParams.contains(realParamName)) continue;
                    try {
                        Utils.updateField(instanceForUpdate, realParamName, value.getObject((Class)argsTypes.get(idx)));
                        continue;
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                for (i = 0; i < parsedParams.size(); ++i) {
                    String param = "param" + i;
                    Var p = null;
                    if (i <= params.length - 1) {
                        p = params[i];
                    }
                    if (p != null) {
                        int idx = argsNames.indexOf(param);
                        strQuery.setParameter(param, p.getObject((Class)argsTypes.get(idx)));
                        if (!nonWhereParams.contains(parsedParams.get(i))) continue;
                        try {
                            Utils.updateField(instanceForUpdate, parsedParams.get(i), p.getObject((Class)argsTypes.get(idx)));
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    strQuery.setParameter(param, null);
                }
            }
            this.processCloudFields(instanceForUpdate);
            this.updateQueryParamsValues(instanceForUpdate, paramsValues, parsedParams, strQuery);
            try {
                if (!em.getTransaction().isActive()) {
                    em.getTransaction().begin();
                }
                Var i2 = Var.valueOf(strQuery.executeUpdate());
                return i2;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        finally {
            this.endMultitetant();
        }
    }

    private void updateQueryParamsValues(Object instanceForUpdate, Map<String, Var> paramsValues, List<String> parsedParams, TypedQuery<?> strQuery) {
        List<FieldData> fieldsAnnotationCloud = Utils.getFieldsWithAnnotationCloud(instanceForUpdate);
        block0: for (FieldData fieldData : fieldsAnnotationCloud) {
            Object content;
            String field = fieldData.field.getName();
            if (!paramsValues.containsKey(field) || paramsValues.get(field).isNull().booleanValue() || (content = Utils.getFieldValue(instanceForUpdate, field)).toString().equals(paramsValues.get(field).getObjectAsString())) continue;
            for (int fi = 0; fi < parsedParams.size(); ++fi) {
                String paramName = "param" + fi;
                String realParamName = parsedParams.get(fi);
                if (!realParamName.equals(field)) continue;
                strQuery.setParameter(paramName, content);
                continue block0;
            }
        }
    }

    public Var getTotalElements() {
        return new Var(this.page.getTotalElements());
    }

    public String toString() {
        if (this.page != null) {
            return this.page.getContent().toString();
        }
        return "[]";
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (this.queryParsed instanceof ReportQuery) {
            gen.writeStartArray();
            for (Object row : this.page.getContent()) {
                if (!row.getClass().isArray()) continue;
                Object[] array = (Object[])row;
                gen.writeStartObject();
                int i = 0;
                for (ReportItem item : ((ReportQuery)this.queryParsed).getItems()) {
                    String name = item.getName();
                    if (name == null || name.isEmpty()) {
                        name = "expression";
                    }
                    gen.writeFieldName(name);
                    gen.writeObject(array[i]);
                    ++i;
                }
                gen.writeEndObject();
            }
            gen.writeEndArray();
        } else {
            gen.writeObject((Object)this.page.getContent());
        }
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        gen.writeObject((Object)this.page.getContent());
    }

    public void checkRESTSecurity(String method) throws Exception {
        this.checkRESTSecurity(this.domainClass, method);
    }

    public void checkRESTSecurity(String relationId, String method) throws Exception {
        EntityMetadata metadata = this.getMetadata();
        RelationMetadata relationMetadata = metadata.getRelations().get(relationId);
        this.checkRESTSecurity(Class.forName(relationMetadata.getName()), method);
    }

    public String getRelationEntity(String relationId) throws Exception {
        EntityMetadata metadata = this.getMetadata();
        RelationMetadata relationMetadata = metadata.getRelations().get(relationId);
        return relationMetadata.getName();
    }

    private void checkRESTSecurity(Class clazz, String method) throws Exception {
        CronappSecurity cronappSecurity;
        Method methodPermission;
        CronappSecurity security = clazz.getAnnotation(CronappSecurity.class);
        boolean authorized = false;
        if (security instanceof CronappSecurity && (methodPermission = (cronappSecurity = security).getClass().getMethod(method.toLowerCase(), new Class[0])) != null) {
            String[] authorities;
            String value = (String)methodPermission.invoke((Object)cronappSecurity, new Object[0]);
            if (value == null || value.trim().isEmpty()) {
                value = "authenticated";
            }
            for (String role : authorities = value.trim().split(";")) {
                if (role.equalsIgnoreCase("authenticated")) {
                    boolean bl = authorized = RestClient.getRestClient().getUser() != null;
                    if (authorized) break;
                }
                if (role.equalsIgnoreCase("permitAll") || role.equalsIgnoreCase("public")) {
                    authorized = true;
                    break;
                }
                for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                    if (!role.equalsIgnoreCase(authority.getAuthority())) continue;
                    authorized = true;
                    break;
                }
                if (authorized) break;
            }
        }
        if (!authorized) {
            throw new RuntimeException(Messages.getString("notAllowed"));
        }
    }

    public void disableMultiTenant() {
        this.multiTenant = false;
    }

    public void enableMultiTenant() {
        this.multiTenant = true;
    }

    public String getFilter() {
        return this.filter;
    }

    public Var getIds() {
        if (this.getObject() == null) {
            return Var.VAR_NULL;
        }
        EntityManager em = this.getEntityManager(this.domainClass);
        javax.persistence.metamodel.EntityType type = em.getMetamodel().entity(this.domainClass);
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object obj : JPAUtil.getAjustedAttributes(type)) {
            SingularAttribute field = (SingularAttribute)obj;
            if (!field.isId()) continue;
            result.add(this.getObject(field.getName()));
        }
        return Var.valueOf(result);
    }

    public Var getId() {
        if (this.getObject() == null) {
            return Var.VAR_NULL;
        }
        EntityManager em = this.getEntityManager(this.domainClass);
        javax.persistence.metamodel.EntityType type = em.getMetamodel().entity(this.domainClass);
        for (Object obj : JPAUtil.getAjustedAttributes(type)) {
            SingularAttribute field = (SingularAttribute)obj;
            if (!field.isId()) continue;
            return Var.valueOf(this.getObject(field.getName()));
        }
        return Var.VAR_NULL;
    }

    public Object getObjectWithId(Var[] ids) {
        EntityManager em = this.getEntityManager(this.domainClass);
        javax.persistence.metamodel.EntityType type = em.getMetamodel().entity(this.domainClass);
        Object instanceDomain = null;
        try {
            instanceDomain = this.domainClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int i = 0;
        for (Object obj : JPAUtil.getAjustedAttributes(type)) {
            SingularAttribute field = (SingularAttribute)obj;
            if (!field.isId()) continue;
            Utils.updateField(instanceDomain, field.getName(), ids[i].getObject(field.getType().getJavaType()));
            ++i;
        }
        return instanceDomain;
    }

    public void validate(String jpql) {
        EntityManager em = this.getEntityManager(this.domainClass);
        AbstractSession session = (AbstractSession)((EntityManagerImpl)em.getDelegate()).getActiveSession();
        HermesParser parser = new HermesParser();
        try {
            parser.buildQuery((CharSequence)jpql, session);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isPlainData() {
        return this.plainData;
    }

    public void setPlainData(boolean plainData) {
        this.plainData = plainData;
    }

    public boolean useUrlParams() {
        return this.useUrlParams;
    }

    public void setUseUrlParams(boolean useUrlParams) {
        this.useUrlParams = useUrlParams;
    }

    public void flush() {
        EntityManager em = this.getEntityManager(this.domainClass);
        em.flush();
    }

    public void setUseOdataRequest(boolean useOdataRequest) {
        this.useOdataRequest = useOdataRequest;
    }

    public void setUseOffset(boolean useOffset) {
        this.useOffset = useOffset;
    }

    private Object[] fetchNative(boolean isCount) {
        this.page = new NativeDatasource(this.namespace).query(this.filter, this.pageRequest, isCount, this.params);
        if (this.page.getNumberOfElements() > 0) {
            this.current = 0;
        }
        if (isCount) {
            return new Long[]{(long)((Long)this.page.getContent().get(0))};
        }
        return this.page.getContent().toArray();
    }

    private Var executeNative(String query, Var ... params) {
        return Var.valueOf(new NativeDatasource(this.namespace).execute(query, params));
    }

    private static class TypeKey {
        String name;
        SingularAttribute field;

        private TypeKey() {
        }
    }
}

