/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.textline.api;

import io.craft.atom.protocol.ProtocolDecoder;
import io.craft.atom.protocol.textline.TextLineDecoder;
import java.nio.charset.Charset;

public class TextLineDecoderBuilder {
    private String delimiter = "\n";
    private Charset charset = Charset.forName("utf-8");
    private int defaultBufferSize = 2048;
    private int maxSize = this.defaultBufferSize * 1024;

    public TextLineDecoderBuilder(Charset charset, String delimiter) {
        this.delimiter = delimiter;
        this.charset = charset;
    }

    public TextLineDecoderBuilder defaultBufferSize(int defaultBufferSize) {
        this.defaultBufferSize = defaultBufferSize;
        return this;
    }

    public TextLineDecoderBuilder maxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public ProtocolDecoder<String> build() {
        return new TextLineDecoder(this.charset, this.delimiter, this.defaultBufferSize, this.maxSize);
    }
}

