/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.textline;

import io.craft.atom.protocol.AbstractProtocolDecoder;
import io.craft.atom.protocol.ProtocolDecoder;
import io.craft.atom.protocol.ProtocolException;
import io.craft.atom.protocol.ProtocolExceptionType;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class TextLineDecoder
extends AbstractProtocolDecoder
implements ProtocolDecoder<String> {
    private String delimiter = "\n";
    private byte[] delimiterBytes = this.delimiter.getBytes(this.charset);
    private int delimiterLen = this.delimiterBytes.length;

    public TextLineDecoder() {
    }

    public TextLineDecoder(Charset charset) {
        this.charset = charset;
    }

    public TextLineDecoder(Charset charset, String delimiter) {
        this(charset);
        this.delimiter = delimiter;
        this.delimiterBytes = delimiter.getBytes(this.charset);
        this.delimiterLen = this.delimiterBytes.length;
    }

    public TextLineDecoder(Charset charset, String delimiter, int defaultBufferSize) {
        this(charset, delimiter);
        this.defaultBufferSize = defaultBufferSize;
        this.buf.reset(defaultBufferSize);
    }

    public TextLineDecoder(Charset charset, String delimiter, int defaultBufferSize, int maxSize) {
        this(charset, delimiter, defaultBufferSize);
        this.maxSize = maxSize;
    }

    public List<String> decode(byte[] bytes) throws ProtocolException {
        ArrayList<String> strs = new ArrayList<String>();
        this.adapt();
        this.buf.append(bytes);
        while (this.searchIndex < this.buf.length()) {
            int idx = this.buf.indexOf(this.delimiterBytes, this.searchIndex);
            if (idx < 0) {
                if (this.buf.length() > this.maxSize) {
                    this.buf.reset(this.defaultBufferSize);
                    throw new ProtocolException(ProtocolExceptionType.LINE_LENGTH_LIMIT, new Object[]{this.maxSize});
                }
                this.searchIndex = this.buf.length();
                break;
            }
            byte[] lineBytes = this.buf.array(this.splitIndex, idx);
            if (lineBytes.length > this.maxSize) {
                this.buf.reset(this.defaultBufferSize);
                throw new ProtocolException(ProtocolExceptionType.LINE_LENGTH_LIMIT, new Object[]{this.maxSize});
            }
            this.searchIndex = this.splitIndex = idx + this.delimiterLen;
            strs.add(new String(lineBytes, this.charset));
        }
        return strs;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        this.delimiterBytes = delimiter.getBytes(this.charset);
        this.delimiterLen = this.delimiterBytes.length;
    }

    public String toString() {
        return "TextLineDecoder(super=" + super.toString() + ", delimiter=" + this.getDelimiter() + ")";
    }

    public String getDelimiter() {
        return this.delimiter;
    }
}

