/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.svcapi;

import io.continual.builder.Builder;
import io.continual.flowcontrol.FlowControlApi;
import io.continual.flowcontrol.FlowControlCallContext;
import io.continual.flowcontrol.FlowControlCallContextBuilder;
import io.continual.flowcontrol.FlowControlService;
import io.continual.flowcontrol.controlapi.ConfigTransferService;
import io.continual.flowcontrol.controlapi.FlowControlDeploymentService;
import io.continual.flowcontrol.endpoints.ConfigFetch;
import io.continual.flowcontrol.endpoints.FlowControlRoutes;
import io.continual.flowcontrol.jobapi.FlowControlJobDb;
import io.continual.flowcontrol.svcapi.BaseFlowControlCallContext;
import io.continual.http.service.framework.CHttpConnection;
import io.continual.http.service.framework.CHttpErrorHandler;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.context.CHttpResponse;
import io.continual.http.service.framework.routing.CHttpRequestRouter;
import io.continual.http.service.framework.routing.CHttpRouteInvocation;
import io.continual.http.service.framework.routing.CHttpRouteSource;
import io.continual.http.service.framework.routing.playish.CHttpPlayishInstanceCallRoutingSource;
import io.continual.iam.IamServiceManager;
import io.continual.restHttp.BaseApiServiceRouter;
import io.continual.restHttp.HttpRouter;
import io.continual.restHttp.HttpService;
import io.continual.restHttp.HttpServlet;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import io.continual.util.nv.NvReadable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHttpService
extends SimpleService
implements FlowControlService {
    private final FlowControlJobDb fJobDb;
    private final FlowControlDeploymentService fDeployApi;
    private final ConfigTransferService fConfigTransfer;
    private static final Logger log = LoggerFactory.getLogger(BaseHttpService.class);
    private static final String skAllowHeadersValue = "Content-Type, Authorization";

    public BaseHttpService(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        this.fJobDb = (FlowControlJobDb)sc.get(config.optString("jobDb", "jobDb"), FlowControlJobDb.class);
        if (this.fJobDb == null) {
            throw new Builder.BuildFailure("No job database found.");
        }
        this.fDeployApi = (FlowControlDeploymentService)sc.get(config.optString("deployApi", "deployApi"), FlowControlDeploymentService.class);
        if (this.fDeployApi == null) {
            throw new Builder.BuildFailure("No deploy service found.");
        }
        this.fConfigTransfer = (ConfigTransferService)sc.get(config.optString("configTransfer", "configTransfer"), ConfigTransferService.class);
        if (this.fConfigTransfer == null) {
            throw new Builder.BuildFailure("No config transfer service found.");
        }
        HttpService http = (HttpService)sc.get(config.getString("httpService"), HttpService.class);
        if (http == null) {
            throw new Builder.BuildFailure("An HTTP service (\"httpService\") is required in the API service configuration.");
        }
        final IamServiceManager accts = (IamServiceManager)sc.get(config.getString("accounts"), IamServiceManager.class);
        if (accts == null) {
            throw new Builder.BuildFailure("An HTTP service (\"accounts\") is required in the configuration.");
        }
        final BaseHttpService fcs = this;
        http.addRouter("httpApi", (HttpRouter)new BaseApiServiceRouter(){

            public void setupRouter(HttpServlet servlet, CHttpRequestRouter rr, NvReadable p) throws IOException {
                super.setupExceptionHandlers(servlet, rr, p);
                rr.addRouteSource((CHttpRouteSource)new CorsOptionsRouter());
                BaseHttpService.this.addRoutes(rr, "flowControlRoutes.conf", new FlowControlRoutes(accts, fcs));
                BaseHttpService.this.addRoutes(rr, "configFetch.conf", new ConfigFetch(BaseHttpService.this.fConfigTransfer));
                rr.setHandlerForException(FlowControlApi.FlowControlApiException.class, new CHttpErrorHandler(){

                    public void handle(CHttpRequestContext ctx, Throwable cause) {
                        ctx.response().sendErrorAndBody(503, new JSONObject().put("error", 503).put("message", (Object)cause.getMessage()).toString(), "application/json");
                    }
                });
            }
        });
    }

    @Override
    public FlowControlCallContextBuilder createtContextBuilder() {
        return new BaseFlowControlCallContext.Builder();
    }

    @Override
    public FlowControlJobDb getJobDb(FlowControlCallContext fccc) {
        return this.fJobDb;
    }

    @Override
    public FlowControlDeploymentService getDeployer(FlowControlCallContext fccc) {
        return this.fDeployApi;
    }

    private void addRoutes(CHttpRequestRouter rr, String routeFile, Object handler) throws IOException {
        log.debug("Loading routes from " + routeFile);
        URL url = this.getClass().getResource(routeFile);
        rr.addRouteSource((CHttpRouteSource)new CHttpPlayishInstanceCallRoutingSource(handler, url));
    }

    private static class CorsOptionsRouter
    implements CHttpRouteSource {
        private CorsOptionsRouter() {
        }

        public CHttpRouteInvocation getRouteFor(String verb, String path, CHttpConnection forSession) {
            if (verb != null && verb.equalsIgnoreCase("OPTIONS")) {
                return new CHttpRouteInvocation(){

                    public void run(CHttpRequestContext context) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                        CHttpResponse reply = context.response();
                        reply.writeHeader("Access-Control-Allow-Origin", "*");
                        reply.writeHeader("Access-Control-Allow-Methods", "DELETE, GET, OPTIONS, PATCH, POST, PUT");
                        reply.writeHeader("Access-Control-Max-Age", "3600");
                        reply.writeHeader("Access-Control-Allow-Headers", BaseHttpService.skAllowHeadersValue);
                        reply.setStatus(204);
                    }

                    public Path getRouteNameForMetrics() {
                        return Path.getRootPath().makeChildItem(Name.fromString((String)"options"));
                    }
                };
            }
            return null;
        }

        public String getRouteTo(Class<?> c, String staticMethodName, Map<String, Object> args, CHttpConnection forSession) {
            return null;
        }
    }
}

