/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.impl.transfer;

import io.continual.builder.Builder;
import io.continual.flowcontrol.controlapi.ConfigTransferService;
import io.continual.flowcontrol.jobapi.FlowControlJob;
import io.continual.flowcontrol.jobapi.FlowControlJobConfig;
import io.continual.flowcontrol.jobapi.FlowControlJobDb;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.util.data.Sha256HmacSigner;
import io.continual.util.data.StringUtils;
import io.continual.util.data.TypeConvertor;
import io.continual.util.data.exprEval.EnvDataSource;
import io.continual.util.data.exprEval.ExprDataSource;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import io.continual.util.data.exprEval.JsonDataSource;
import io.continual.util.time.Clock;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFetchService
extends SimpleService
implements ConfigTransferService {
    private final FlowControlJobDb fJobDb;
    private final String fSigningKey;
    private final String fBaseUrl;
    private final long fKeyTimeLimitSec;
    private static final Logger log = LoggerFactory.getLogger(ConfigFetchService.class);

    public ConfigFetchService(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        this.fJobDb = (FlowControlJobDb)sc.get(config.optString("jobDb", "jobDb"), FlowControlJobDb.class);
        if (this.fJobDb == null) {
            throw new Builder.BuildFailure("No job database found.");
        }
        ExpressionEvaluator ee = new ExpressionEvaluator(new ExprDataSource[]{new JsonDataSource(config), new EnvDataSource()});
        this.fSigningKey = ee.evaluateText(config.getString("signingKey"));
        if (this.fSigningKey.length() == 0) {
            throw new Builder.BuildFailure("Config signing key is an empty string.");
        }
        this.fBaseUrl = ee.evaluateText(config.getString("baseUrl"));
        this.fKeyTimeLimitSec = ee.evaluateTextToLong(config.opt("timeLimitSec"), -1L);
    }

    @Override
    public Map<String, String> deployConfiguration(FlowControlJob job) {
        HashMap<String, String> result = new HashMap<String, String>();
        String jobId = job.getId();
        long createdAtMs = Clock.now();
        StringBuilder in = new StringBuilder();
        in.append(jobId).append(".").append(createdAtMs);
        String tag = in.toString();
        String tagEnc = TypeConvertor.base64UrlEncode((String)tag);
        String tagSigned = TypeConvertor.base64UrlEncode((String)Sha256HmacSigner.sign((String)tag, (String)this.fSigningKey));
        String key = tagEnc + "-" + tagSigned;
        log.info("job [" + jobId + "] => [" + key + "]");
        result.put("CONFIG_KEY", key);
        result.put("CONFIG_URL", this.fBaseUrl + key);
        return result;
    }

    @Override
    public InputStream fetch(String byKey) {
        String[] parts = StringUtils.splitList((String)byKey, (char[])new char[]{'-'}, (char[])new char[0]);
        if (parts.length != 2) {
            log.info("bad key format");
            return null;
        }
        String tagPart = new String(TypeConvertor.base64UrlDecode((String)parts[0]), StandardCharsets.UTF_8);
        String sigPart = new String(TypeConvertor.base64UrlDecode((String)parts[1]), StandardCharsets.UTF_8);
        String tagSigned = Sha256HmacSigner.sign((String)tagPart, (String)this.fSigningKey);
        if (!tagSigned.equals(sigPart)) {
            log.info("signature doesn't match");
            return null;
        }
        String[] idAndTimestamp = StringUtils.splitList((String)tagPart, (char[])new char[]{'.'}, (char[])new char[0]);
        if (idAndTimestamp.length != 2) {
            log.info("tag is malformed");
            return null;
        }
        try {
            long ts = Long.parseLong(idAndTimestamp[1]);
            if (this.fKeyTimeLimitSec > 0L && ts + this.fKeyTimeLimitSec < Clock.now()) {
                log.info("tag is expired");
                return null;
            }
        }
        catch (NumberFormatException x) {
            log.info("tag timestamp is not a number");
            return null;
        }
        try {
            FlowControlJob job = this.fJobDb.getJobAsAdmin(idAndTimestamp[0]);
            if (job == null) {
                log.info("No such job.");
                return null;
            }
            FlowControlJobConfig config = job.getConfiguration();
            return config.readConfiguration();
        }
        catch (FlowControlJobDb.ServiceException e) {
            log.info("Error loading job: " + e.getMessage());
            return null;
        }
    }
}

