/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.impl.jobdb.model;

import io.continual.builder.Builder;
import io.continual.flowcontrol.FlowControlCallContext;
import io.continual.flowcontrol.impl.jobdb.common.JsonJob;
import io.continual.flowcontrol.jobapi.FlowControlJob;
import io.continual.flowcontrol.jobapi.FlowControlJobDb;
import io.continual.iam.access.AccessControlEntry;
import io.continual.iam.access.AccessControlList;
import io.continual.iam.access.AccessException;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.iam.impl.common.CommonJsonIdentity;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelObject;
import io.continual.services.model.core.ModelPathList;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.util.data.TypeConvertor;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Collection;
import java.util.LinkedList;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;

public class ModelJobDb
extends SimpleService
implements FlowControlJobDb {
    private final Model fModel;
    private final Identity fModelUser;
    private final Enc fEnc;
    private static final byte[] kFixmeSalt = "salty".getBytes(StandardCharsets.UTF_8);

    public ModelJobDb(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        JSONObject modelData = config.getJSONObject("model");
        this.fModel = (Model)Builder.fromJson(Model.class, (JSONObject)modelData, (Object)sc);
        this.fModelUser = new CommonJsonIdentity("flowControlUser", CommonJsonIdentity.initializeIdentity(), null);
        try {
            this.fEnc = new Enc(config.getString("secretEncryptKey"));
        }
        catch (GeneralSecurityException e) {
            throw new Builder.BuildFailure((Throwable)e);
        }
    }

    @Override
    public FlowControlJobDb.Builder createJob(FlowControlCallContext fccc) {
        return new ModelFcJobBuilder(fccc);
    }

    @Override
    public Collection<FlowControlJob> getJobsFor(FlowControlCallContext fccc) throws FlowControlJobDb.ServiceException {
        try {
            ModelRequestContext mrc = this.buildContext();
            Path path = ModelJobDb.getBaseJobPath();
            ModelPathList pathList = this.fModel.listChildrenOfPath(mrc, path);
            LinkedList<FlowControlJob> result = new LinkedList<FlowControlJob>();
            if (pathList != null) {
                for (Path p : pathList) {
                    try {
                        FlowControlJob job = this.internalLoadJob(mrc, p.getItemName().toString());
                        if (job == null || !job.getAccessControlList().canUser(fccc.getUser(), "read")) continue;
                        result.add(job);
                    }
                    catch (IamSvcException e) {
                        throw new FlowControlJobDb.ServiceException(e);
                    }
                }
            }
            return result;
        }
        catch (Builder.BuildFailure | ModelRequestException | ModelServiceException e) {
            throw new FlowControlJobDb.ServiceException(e);
        }
    }

    @Override
    public FlowControlJob getJob(FlowControlCallContext fccc, String name) throws FlowControlJobDb.ServiceException, AccessException {
        try {
            ModelRequestContext mrc = this.buildContext();
            FlowControlJob job = this.internalLoadJob(mrc, name);
            this.checkAccess(job, fccc, "read");
            return job;
        }
        catch (Builder.BuildFailure e) {
            throw new FlowControlJobDb.ServiceException(e);
        }
    }

    @Override
    public FlowControlJob getJobAsAdmin(String name) throws FlowControlJobDb.ServiceException {
        try {
            ModelRequestContext mrc = this.buildContext();
            return this.internalLoadJob(mrc, name);
        }
        catch (Builder.BuildFailure e) {
            throw new FlowControlJobDb.ServiceException(e);
        }
    }

    @Override
    public void storeJob(FlowControlCallContext fccc, String name, FlowControlJob job) throws FlowControlJobDb.ServiceException, AccessException {
        try {
            ModelRequestContext mrc = this.buildContext();
            FlowControlJob existing = this.internalLoadJob(mrc, name);
            this.checkAccess(existing, fccc, "update");
            this.internalStoreJob(mrc, job);
        }
        catch (Builder.BuildFailure e) {
            throw new FlowControlJobDb.ServiceException(e);
        }
    }

    @Override
    public void removeJob(FlowControlCallContext fccc, String name) throws FlowControlJobDb.ServiceException, AccessException {
        try {
            ModelRequestContext mrc = this.buildContext();
            this.checkAccess(this.internalLoadJob(mrc, name), fccc, "update");
            Path path = ModelJobDb.jobNameToPath(name);
            this.fModel.remove(mrc, path);
        }
        catch (Builder.BuildFailure | ModelRequestException | ModelServiceException e) {
            throw new FlowControlJobDb.ServiceException(e);
        }
    }

    private FlowControlJob internalLoadJob(ModelRequestContext mrc, String name) throws FlowControlJobDb.ServiceException {
        try {
            Path path = ModelJobDb.jobNameToPath(name);
            ModelObject mo = this.fModel.load(mrc, path);
            return new ModelFcJob(name, mo);
        }
        catch (ModelItemDoesNotExistException e) {
            return null;
        }
        catch (ModelRequestException | ModelServiceException e) {
            throw new FlowControlJobDb.ServiceException(e);
        }
    }

    private FlowControlJob internalStoreJob(ModelRequestContext mrc, FlowControlJob job) throws FlowControlJobDb.ServiceException {
        try {
            String name = job.getName();
            Path path = ModelJobDb.jobNameToPath(name);
            this.fModel.store(mrc, path, ((ModelFcJob)job).toJson());
            return this.internalLoadJob(mrc, name);
        }
        catch (ModelRequestException | ModelServiceException e) {
            throw new FlowControlJobDb.ServiceException(e);
        }
    }

    private static Path getBaseJobPath() {
        return Path.fromString((String)"/jobs");
    }

    private static Path jobNameToPath(String name) {
        return ModelJobDb.getBaseJobPath().makeChildItem(Name.fromString((String)name));
    }

    private void checkAccess(FlowControlJob job, FlowControlCallContext fccc, String op) throws AccessException, FlowControlJobDb.ServiceException {
        try {
            if (job == null) {
                return;
            }
            if (!job.getAccessControlList().canUser(fccc.getUser(), op)) {
                throw new AccessException(fccc.getUser() + " may not " + op + " job " + job.getId() + ".");
            }
        }
        catch (IamSvcException e) {
            throw new FlowControlJobDb.ServiceException(e);
        }
    }

    private ModelRequestContext buildContext() throws Builder.BuildFailure {
        return this.fModel.getRequestContextBuilder().forUser(this.fModelUser).build();
    }

    private class ModelFcJob
    extends JsonJob {
        public ModelFcJob(ModelFcJobBuilder builder) {
            super(builder.fName, ModelJobDb.this.fEnc);
        }

        public ModelFcJob(String name, ModelObject mo) {
            super(name, ModelJobDb.this.fEnc, mo.getData());
        }
    }

    static class Enc
    implements JsonJob.Encryptor {
        private final String fEncKey;
        private final Cipher fCipher;
        private final SecretKeySpec fSec;

        public Enc(String pwd) throws GeneralSecurityException {
            this.fEncKey = pwd;
            this.fCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(this.fEncKey.toCharArray(), kFixmeSalt, 65536, 256);
            SecretKey tmp = factory.generateSecret(spec);
            this.fSec = new SecretKeySpec(tmp.getEncoded(), "AES");
        }

        @Override
        public String encrypt(String val) throws GeneralSecurityException {
            this.fCipher.init(1, this.fSec);
            AlgorithmParameters params = this.fCipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] ciphertext = this.fCipher.doFinal(val.getBytes(StandardCharsets.UTF_8));
            return TypeConvertor.base64Encode((byte[])ciphertext) + ":" + TypeConvertor.base64Encode((byte[])iv);
        }

        @Override
        public String decrypt(String val) throws GeneralSecurityException {
            String[] parts = val.split(":");
            if (parts.length != 2) {
                throw new GeneralSecurityException("Unexpected encrypted text format.");
            }
            byte[] iv = TypeConvertor.base64Decode((String)parts[1]);
            byte[] ciphertext = TypeConvertor.base64Decode((String)parts[0]);
            this.fCipher.init(2, (Key)this.fSec, new IvParameterSpec(iv));
            return new String(this.fCipher.doFinal(ciphertext), StandardCharsets.UTF_8);
        }
    }

    private class ModelFcJobBuilder
    implements FlowControlJobDb.Builder {
        private final FlowControlCallContext fCtx;
        private String fName;
        private String fOwner;
        private LinkedList<AccessControlEntry> fAces;

        public ModelFcJobBuilder(FlowControlCallContext fccc) {
            this.fCtx = fccc;
            this.fAces = new LinkedList();
            this.withAccess("~owner~", "read", "update", "delete");
        }

        @Override
        public FlowControlJobDb.Builder withName(String name) {
            this.fName = name;
            return this;
        }

        @Override
        public FlowControlJobDb.Builder withOwner(String owner) {
            this.fOwner = owner;
            return this;
        }

        @Override
        public FlowControlJobDb.Builder withAccess(String user, String ... ops) {
            this.fAces.add(AccessControlEntry.builder().permit().forSubject(user).operations(ops).build());
            return this;
        }

        @Override
        public FlowControlJob build() throws FlowControlJobDb.RequestException, FlowControlJobDb.ServiceException, AccessException {
            if (this.fName == null || this.fName.length() == 0) {
                throw new FlowControlJobDb.RequestException("Name is not set.");
            }
            FlowControlJob existing = ModelJobDb.this.getJob(this.fCtx, this.fName);
            if (existing != null) {
                throw new FlowControlJobDb.RequestException("Job " + this.fName + " already exists.");
            }
            try {
                ModelRequestContext mrc = ModelJobDb.this.buildContext();
                ModelFcJob job = new ModelFcJob(this);
                AccessControlList acl = job.getAccessControlList();
                acl.setOwner(this.fOwner).clear();
                for (AccessControlEntry ace : this.fAces) {
                    acl.addAclEntry(ace);
                }
                ModelJobDb.this.internalStoreJob(mrc, job);
                return ModelJobDb.this.internalLoadJob(mrc, this.fName);
            }
            catch (Builder.BuildFailure e) {
                throw new FlowControlJobDb.ServiceException(e);
            }
        }
    }
}

