/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.impl.jobdb.common;

import io.continual.flowcontrol.controlapi.FlowControlRuntimeSpec;
import io.continual.flowcontrol.jobapi.FlowControlJob;
import io.continual.flowcontrol.jobapi.FlowControlJobConfig;
import io.continual.flowcontrol.jobapi.FlowControlJobDb;
import io.continual.iam.access.AccessControlList;
import io.continual.iam.access.AclUpdateListener;
import io.continual.util.data.StreamTools;
import io.continual.util.data.TypeConvertor;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonSerialized;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonJob
implements FlowControlJob,
JsonSerialized {
    private static final String kName = "name";
    private static final String kVersion = "version";
    private static final String kAcl = "acl";
    private static final String kRuntime = "runtime";
    private static final String kConfig = "config";
    private static final String kSecrets = "secrets";
    private static final String kSecretValue = "value";
    private final JSONObject fData;
    private final Encryptor fEncryptor;

    public JsonJob(String name, Encryptor enc) {
        this.fData = new JSONObject().put(kName, (Object)name).put(kAcl, (Object)AccessControlList.initialize(null).asJson()).put(kRuntime, (Object)new JSONObject().put(kName, (Object)"current").put(kVersion, (Object)"current")).put(kConfig, (Object)this.buildEmptyConfig()).put(kSecrets, (Object)new JSONObject());
        this.fEncryptor = enc;
    }

    public JsonJob(String name, Encryptor enc, JSONObject persisted) {
        this(name, enc);
        JsonUtil.copyInto((JSONObject)persisted, (JSONObject)this.fData);
        this.fData.put(kName, (Object)name);
    }

    public JSONObject toJson() {
        return JsonUtil.clone((JSONObject)this.fData);
    }

    public AccessControlList getAccessControlList() {
        return AccessControlList.deserialize((JSONObject)this.fData.getJSONObject(kAcl), (AclUpdateListener)new AclUpdateListener(){

            public void onAclUpdate(AccessControlList accessControlList) {
                JsonJob.this.fData.put(JsonJob.kAcl, (Object)accessControlList.asJson());
            }
        });
    }

    public String getId() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.fData.getString(kName);
    }

    @Override
    public FlowControlJobConfig getConfiguration() {
        final JSONObject config = this.fData.getJSONObject(kConfig);
        return new FlowControlJobConfig(){

            @Override
            public String getDataType() {
                return config.getString("type");
            }

            @Override
            public InputStream readConfiguration() {
                String type = this.getDataType();
                if (type.equalsIgnoreCase("application/json")) {
                    JSONObject data = config.getJSONObject("data");
                    return new ByteArrayInputStream(data.toString().getBytes(StandardCharsets.UTF_8));
                }
                if (type.equalsIgnoreCase("text/plain")) {
                    String data = config.getString("data");
                    return new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
                }
                if (type.equalsIgnoreCase("application/octet-stream")) {
                    String data = config.getString("data");
                    return new ByteArrayInputStream(TypeConvertor.base64Decode((String)data));
                }
                throw new IllegalArgumentException("Unrecognized config type: " + type);
            }
        };
    }

    @Override
    public FlowControlJob setConfiguration(FlowControlJobConfig config) throws IOException {
        block15: {
            JSONObject configData = this.fData.getJSONObject(kConfig);
            try (InputStream is = config.readConfiguration();){
                String type = config.getDataType();
                configData.put("type", (Object)type);
                if (type.equalsIgnoreCase("application/json")) {
                    JSONObject data = new JSONObject((JSONTokener)new CommentedJsonTokener(is));
                    configData.put("data", (Object)data);
                    break block15;
                }
                if (type.equalsIgnoreCase("text/plain")) {
                    byte[] bytes = StreamTools.readBytes((InputStream)is);
                    String data = new String(bytes, StandardCharsets.UTF_8);
                    configData.put("data", (Object)data);
                    break block15;
                }
                if (type.equalsIgnoreCase("application/octet-stream")) {
                    byte[] bytes = StreamTools.readBytes((InputStream)is);
                    String data = TypeConvertor.base64Encode((byte[])bytes);
                    configData.put("data", (Object)data);
                    break block15;
                }
                throw new IllegalArgumentException("Unrecognized config type: " + type);
            }
        }
        return this;
    }

    @Override
    public FlowControlRuntimeSpec getRuntimeSpec() {
        final JSONObject runtime = this.fData.getJSONObject(kRuntime);
        return new FlowControlRuntimeSpec(){

            @Override
            public String getName() {
                return runtime.getString(JsonJob.kName);
            }

            @Override
            public String getVersion() {
                return runtime.getString(JsonJob.kVersion);
            }
        };
    }

    @Override
    public FlowControlJob setRuntimeSpec(FlowControlRuntimeSpec runtimeSpec) {
        this.fData.put(kRuntime, (Object)new JSONObject().put(kName, (Object)runtimeSpec.getName()).put(kVersion, (Object)runtimeSpec.getVersion()));
        return this;
    }

    @Override
    public Set<String> getSecretRefs() {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(this.fData.getJSONObject(kSecrets).keySet());
        return result;
    }

    @Override
    public FlowControlJob registerSecret(String key, String value) throws FlowControlJobDb.ServiceException {
        this.fData.getJSONObject(kSecrets).put(key, (Object)this.buildSecretValue(value));
        return this;
    }

    @Override
    public FlowControlJob removeSecretRef(String key) {
        this.fData.getJSONObject(kSecrets).remove(key);
        return this;
    }

    @Override
    public Map<String, String> getSecrets() throws FlowControlJobDb.ServiceException {
        final HashMap<String, String> result = new HashMap<String, String>();
        JsonVisitor.forEachElement((JSONObject)this.fData.getJSONObject(kSecrets), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONObject, FlowControlJobDb.ServiceException>(){

            public boolean visit(String secretName, JSONObject secretValueHolder) throws JSONException, FlowControlJobDb.ServiceException {
                String val = secretValueHolder.getString(JsonJob.kSecretValue);
                try {
                    result.put(secretName, JsonJob.this.fEncryptor.decrypt(val));
                }
                catch (GeneralSecurityException e) {
                    throw new FlowControlJobDb.ServiceException(e);
                }
                return true;
            }
        });
        return result;
    }

    private JSONObject buildSecretValue(String value) throws FlowControlJobDb.ServiceException {
        try {
            return new JSONObject().put(kSecretValue, (Object)this.fEncryptor.encrypt(value));
        }
        catch (GeneralSecurityException e) {
            throw new FlowControlJobDb.ServiceException(e);
        }
    }

    private JSONObject buildEmptyConfig() {
        return new JSONObject().put("type", (Object)"application/json").put("data", (Object)new JSONObject());
    }

    public static interface Encryptor {
        public String encrypt(String var1) throws GeneralSecurityException;

        public String decrypt(String var1) throws GeneralSecurityException;
    }
}

