/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.impl.controller.k8s;

import io.continual.builder.Builder;
import io.continual.flowcontrol.FlowControlCallContext;
import io.continual.flowcontrol.controlapi.ConfigTransferService;
import io.continual.flowcontrol.controlapi.FlowControlDeployment;
import io.continual.flowcontrol.controlapi.FlowControlDeploymentService;
import io.continual.flowcontrol.controlapi.FlowControlRuntimeSpec;
import io.continual.flowcontrol.impl.controller.k8s.ContainerImageMapper;
import io.continual.flowcontrol.jobapi.FlowControlJob;
import io.continual.flowcontrol.jobapi.FlowControlJobDb;
import io.continual.resources.ResourceLoader;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.util.data.StreamTools;
import io.continual.util.data.TypeConvertor;
import io.continual.util.data.exprEval.EnvDataSource;
import io.continual.util.data.exprEval.ExprDataSource;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import io.continual.util.data.exprEval.JsonDataSource;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.standards.HttpStatusCodes;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarSource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentCondition;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.DeploymentStatus;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetList;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.apps.StatefulSetStatus;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.TailPrettyLoggable;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sController
extends SimpleService
implements FlowControlDeploymentService {
    static final String kSetting_k8sContext = "context";
    static final String kSetting_Namespace = "namespace";
    static final String kSetting_ConfigMountLoc = "configMountLoc";
    static final String kDefault_ConfigMountLoc = "/var/flowcontrol/config";
    static final String kSetting_PersistMountLoc = "persistMountLoc";
    static final String kDefault_PersistMountLoc = "/var/flowcontrol/persistence";
    static final String kSetting_LogsMountLoc = "logsMountLoc";
    static final String kDefault_LogsMountLoc = "/var/flowcontrol/logs";
    static final String kSetting_ConfigTransfer = "configTransfer";
    static final String kSetting_InitYamlResource = "deploymentYaml";
    static final String kDefault_InitYamlResource = "initDeployment.yaml";
    static final String kSetting_InitYamlSettings = "deploymentSettings";
    static final String kSetting_InitYamlImagePullSecrets = "imagePullSecrets";
    static final String kSetting_StorageClass = "storageClass";
    static final String kDefault_StorageClass = "standard";
    static final String kSetting_InstallationName = "installationName";
    static final String kSetting_DumpInitYaml = "dumpInitYaml";
    static final String kSetting_DefaultCpuRequest = "defaultCpuRequest";
    static final String kSetting_DefaultCpuLimit = "defaultCpuLimit";
    static final String kSetting_DefaultMemLimit = "defaultMemLimit";
    static final String kSetting_DefaultPersistDiskSize = "defaultPersistDiskSize";
    static final String kSetting_DefaultLogDiskSize = "defaultLogDiskSize";
    private final ConfigTransferService fConfigTransfer;
    private final KubernetesClient fApiClient;
    private final String fNamespace;
    private final String fConfigMountLoc;
    private final String fPersistMountLoc;
    private final String fLogsMountLoc;
    private final ContainerImageMapper fImageMapper;
    private final String fInitYamlResource;
    private final JSONObject fInitYamlSettings;
    private final String fInitYamlStorageClass;
    private final String fInstallationName;
    private final List<String> fImgPullSecrets;
    private final boolean fDumpInitYaml;
    private final String fDefCpuLimit;
    private final String fDefCpuRequest;
    private final String fDefMemLimit;
    private final String fDefPersistDiskSize;
    private final String fDefLogDiskSize;
    private static final Logger log = LoggerFactory.getLogger(K8sController.class);

    public K8sController(ServiceContainer sc, JSONObject rawConfig) throws Builder.BuildFailure {
        JSONObject config = sc.getExprEval().evaluateJsonObject(rawConfig);
        this.fConfigTransfer = (ConfigTransferService)sc.get(config.optString(kSetting_ConfigTransfer, kSetting_ConfigTransfer), ConfigTransferService.class);
        if (this.fConfigTransfer == null) {
            throw new Builder.BuildFailure("No configTransfer service");
        }
        String contextName = config.optString(kSetting_k8sContext, null);
        if (contextName != null && contextName.length() > 0) {
            Config cfgWithContext = Config.autoConfigure((String)contextName);
            this.fApiClient = new DefaultKubernetesClient(cfgWithContext);
        } else {
            this.fApiClient = new DefaultKubernetesClient();
        }
        this.fNamespace = config.getString(kSetting_Namespace);
        this.fConfigMountLoc = config.optString(kSetting_ConfigMountLoc, kDefault_ConfigMountLoc);
        this.fPersistMountLoc = config.optString(kSetting_PersistMountLoc, kDefault_PersistMountLoc);
        this.fLogsMountLoc = config.optString(kSetting_LogsMountLoc, kDefault_LogsMountLoc);
        JSONObject mapperSpec = config.optJSONObject("imageMapper");
        this.fImageMapper = mapperSpec != null ? (ContainerImageMapper)Builder.fromJson(ContainerImageMapper.class, (JSONObject)mapperSpec, (Object)sc) : new SimpleImageMapper();
        this.fInitYamlResource = config.optString(kSetting_InitYamlResource, kDefault_InitYamlResource);
        this.fInitYamlSettings = config.optJSONObject(kSetting_InitYamlSettings);
        this.fInitYamlStorageClass = config.optString(kSetting_StorageClass, kDefault_StorageClass);
        this.fInstallationName = config.optString(kSetting_InstallationName, "");
        this.fImgPullSecrets = JsonVisitor.arrayToList((JSONArray)config.optJSONArray(kSetting_InitYamlImagePullSecrets));
        this.fDumpInitYaml = config.optBoolean(kSetting_DumpInitYaml, false);
        this.fDefCpuRequest = config.optString(kSetting_DefaultCpuRequest, null);
        this.fDefCpuLimit = config.optString(kSetting_DefaultCpuLimit, null);
        this.fDefMemLimit = config.optString(kSetting_DefaultMemLimit, null);
        this.fDefPersistDiskSize = config.optString(kSetting_DefaultPersistDiskSize, null);
        this.fDefLogDiskSize = config.optString(kSetting_DefaultLogDiskSize, null);
    }

    protected void onStopRequested() {
        super.onStopRequested();
        this.fApiClient.close();
    }

    @Override
    public FlowControlDeploymentService.DeploymentSpecBuilder deploymentBuilder() {
        return new LocalDeploymentSpecBuilder();
    }

    @Override
    public FlowControlDeployment deploy(FlowControlCallContext ctx, FlowControlDeploymentService.DeploymentSpec ds) throws FlowControlDeploymentService.ServiceException, FlowControlDeploymentService.RequestException {
        try {
            String k8sJobId;
            String jobId = ds.getJob().getId();
            String tag = k8sJobId = K8sController.makeK8sName(jobId);
            Map<String, String> configFetchEnv = this.fConfigTransfer.deployConfiguration(ds.getJob());
            String targetConfigFile = this.fConfigMountLoc + "/jobConfig.json";
            JSONObject replacements = new JSONObject().put("CONFIG_URL", (Object)"${CONFIG_URL}").put("FC_DEPLOYMENT_NAME", (Object)tag).put("FC_JOB_TAG", (Object)("job-" + tag)).put("FC_JOB_ID", (Object)jobId).put("FC_INSTANCE_COUNT", (Object)("" + ds.getInstanceCount())).put("FC_RUNTIME_IMAGE", (Object)this.fImageMapper.getImageName(ds.getJob().getRuntimeSpec())).put("FC_CONFIG_MOUNT", (Object)this.fConfigMountLoc).put("FC_PERSISTENCE_MOUNT", (Object)this.fPersistMountLoc).put("FC_LOGS_MOUNT", (Object)this.fLogsMountLoc).put("FC_CONFIG_FILE", (Object)targetConfigFile).put("FC_STORAGE_CLASS", (Object)this.fInitYamlStorageClass).put("FC_STORAGE_SIZE", (Object)ds.getResourceSpecs().persistDiskSize()).put("FC_LOGS_SIZE", (Object)ds.getResourceSpecs().logDiskSize());
            String secretsName = K8sController.tagToSecret(tag);
            Map<String, String> secrets = ds.getJob().getSecrets();
            SecretBuilder sb = (SecretBuilder)((SecretFluent.MetadataNested)((SecretBuilder)new SecretBuilder().withType("Opaque")).withNewMetadata().withName(secretsName)).endMetadata();
            boolean anyInternalSecrets = false;
            for (Map.Entry<String, String> secret : secrets.entrySet()) {
                String val = secret.getValue();
                boolean isInternal = val != null;
                if (!isInternal) continue;
                anyInternalSecrets = true;
                sb = (SecretBuilder)sb.addToData(secret.getKey(), TypeConvertor.base64Encode((String)secret.getValue()));
            }
            if (anyInternalSecrets) {
                ((NonNamespaceOperation)this.fApiClient.secrets().inNamespace(this.fNamespace)).createOrReplace((Object[])new Secret[]{sb.build()});
            }
            try (InputStream deployTemplate = new ResourceLoader().usingStandardSources(false, K8sController.class).named(this.fInitYamlResource).load();){
                if (deployTemplate == null) {
                    throw new FlowControlDeploymentService.ServiceException("Couldn't load " + this.fInitYamlResource);
                }
                String deployYaml = this.replaceAllTokens(deployTemplate, replacements);
                ByteArrayInputStream bais = new ByteArrayInputStream(deployYaml.getBytes(StandardCharsets.UTF_8));
                this.dumpYaml(tag, deployYaml);
                List items = (List)this.fApiClient.load((InputStream)bais).get();
                HashMap<String, String> env = new HashMap<String, String>();
                env.putAll(ds.getEnv());
                env.putAll(configFetchEnv);
                env.put("FC_INSTALLATION_NAME", this.fInstallationName);
                env.put("FC_CONFIG_DIR", this.fConfigMountLoc);
                env.put("FC_PERSISTENCE_DIR", this.fPersistMountLoc);
                env.put("FC_LOGS_DIR", this.fLogsMountLoc);
                env.put("JOB_ID", jobId);
                env.put("CONFIG_FILE", targetConfigFile);
                this.updateEnv(env);
                for (HasMetadata md : items) {
                    String kind = md.getKind();
                    String name = md.getMetadata().getName();
                    log.info("Manifest includes {} {}.", (Object)kind, (Object)name);
                    PodTemplateSpec template = null;
                    if (kind.equals("Deployment")) {
                        Deployment d = (Deployment)md;
                        DeploymentSpec deploySpec = d.getSpec();
                        template = deploySpec.getTemplate();
                    } else if (kind.equals("StatefulSet")) {
                        StatefulSet ss = (StatefulSet)md;
                        StatefulSetSpec sss = ss.getSpec();
                        template = sss.getTemplate();
                    }
                    if (template == null) continue;
                    this.updateTemplate(ds, template, env, secretsName, secrets);
                }
                ((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.fApiClient.resourceList((Collection)items).inNamespace(this.fNamespace)).createOrReplace();
            }
            catch (IOException e) {
                throw new FlowControlDeploymentService.ServiceException(e);
            }
            catch (KubernetesClientException x) {
                K8sController.mapException(x);
            }
            return new IntDeployment(tag, jobId);
        }
        catch (ConfigTransferService.ServiceException x) {
            throw new FlowControlDeploymentService.ServiceException(x);
        }
        catch (FlowControlJobDb.ServiceException x) {
            throw new FlowControlDeploymentService.ServiceException(x);
        }
    }

    @Override
    public void undeploy(FlowControlCallContext ctx, String deploymentId) throws FlowControlDeploymentService.ServiceException {
        K8sDeployWrapper dw = this.getDeployment(deploymentId);
        if (dw != null) {
            dw.delete();
            try {
                Secret secret = (Secret)((Resource)((NonNamespaceOperation)this.fApiClient.secrets().inNamespace(this.fNamespace)).withName(K8sController.tagToSecret(deploymentId))).get();
                if (secret != null) {
                    this.fApiClient.resource((HasMetadata)secret).delete();
                }
            }
            catch (KubernetesClientException | IllegalStateException throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public FlowControlDeployment getDeployment(FlowControlCallContext ctx, String deploymentId) throws FlowControlDeploymentService.ServiceException {
        try {
            K8sDeployWrapper dw = this.getDeployment(deploymentId);
            if (dw == null) {
                return null;
            }
            String jobId = (String)dw.getMetadata().getLabels().get("flowcontroljob");
            return new IntDeployment(dw.getMetadata().getName(), jobId == null ? "(unknown)" : jobId);
        }
        catch (KubernetesClientException x) {
            Throwable cause = x.getCause();
            if (cause instanceof ProtocolException) {
                return null;
            }
            K8sController.mapExceptionSvcOnly(x);
            return null;
        }
        catch (IllegalStateException x) {
            return null;
        }
    }

    @Override
    public List<FlowControlDeployment> getDeployments(FlowControlCallContext ctx) throws FlowControlDeploymentService.ServiceException {
        LinkedList<FlowControlDeployment> result = new LinkedList<FlowControlDeployment>();
        try {
            for (K8sDeployWrapper dw : this.getK8sDeployments()) {
                String jobId = (String)dw.getMetadata().getLabels().get("flowcontroljob");
                result.add(new IntDeployment(dw.getMetadata().getName(), jobId == null ? "(unknown)" : jobId));
            }
        }
        catch (KubernetesClientException x) {
            K8sController.mapExceptionSvcOnly(x);
        }
        return result;
    }

    @Override
    public List<FlowControlDeployment> getDeploymentsForJob(FlowControlCallContext ctx, String jobId) throws FlowControlDeploymentService.ServiceException {
        LinkedList<FlowControlDeployment> result = new LinkedList<FlowControlDeployment>();
        try {
            for (K8sDeployWrapper dw : this.getK8sDeployments()) {
                String thisJobId = (String)dw.getMetadata().getLabels().get("flowcontroljob");
                if (!jobId.equals(thisJobId)) continue;
                result.add(new IntDeployment(dw.getMetadata().getName(), thisJobId));
            }
        }
        catch (KubernetesClientException x) {
            K8sController.mapExceptionSvcOnly(x);
        }
        return result;
    }

    protected void updateEnv(HashMap<String, String> env) {
    }

    private static String makeK8sName(String from) {
        return "s-" + from.toLowerCase();
    }

    private void dumpYaml(String tag, String deployYaml) {
        if (this.fDumpInitYaml) {
            File tmpDir = new File("/tmp/flowControlYamls");
            tmpDir.mkdir();
            File yamlFile = new File(tmpDir, tag + ".yaml");
            try (FileWriter fw = new FileWriter(yamlFile);){
                fw.write(deployYaml);
            }
            catch (IOException x) {
                log.warn("Couldn't write {}", (Object)yamlFile);
            }
        }
    }

    private static String tagToSecret(String tag) {
        return "secret-" + tag;
    }

    private void updateTemplate(FlowControlDeploymentService.DeploymentSpec ds, PodTemplateSpec template, HashMap<String, String> env, String secretsName, Map<String, String> secrets) {
        PodSpec ps = template.getSpec();
        LinkedList<LocalObjectReference> ipsList = new LinkedList<LocalObjectReference>();
        for (String ips : this.fImgPullSecrets) {
            ipsList.add(new LocalObjectReference(ips));
            log.info("Registering image pull secret {}...", (Object)ips);
        }
        ps.setImagePullSecrets(ipsList);
        for (Container c : ps.getContainers()) {
            this.pushEnvMapToContainer(env, c);
            this.addSecretsToContainer(secretsName, secrets, c);
            this.setLimitsOnContainer(ds, c);
        }
        for (Container c : ps.getInitContainers()) {
            this.pushEnvMapToContainer(env, c);
            this.addSecretsToContainer(secretsName, secrets, c);
            this.setLimitsOnContainer(ds, c);
        }
        LinkedList<Toleration> tols = new LinkedList<Toleration>();
        for (FlowControlDeploymentService.Toleration t : ds.getResourceSpecs().tolerations()) {
            tols.add(new Toleration(t.effect(), t.key(), t.operator(), t.seconds(), t.value()));
        }
        if (tols.size() > 0) {
            ps.setTolerations(tols);
        }
    }

    private void addSecretsToContainer(String secretName, Map<String, String> secrets, Container c) {
        List list = c.getEnv();
        for (Map.Entry<String, String> e : secrets.entrySet()) {
            if (e.getValue() == null) continue;
            list.add(new EnvVar(e.getKey(), null, new EnvVarSource(null, null, null, new SecretKeySelector(e.getKey(), secretName, Boolean.valueOf(true)))));
        }
    }

    private void pushEnvMapToContainer(Map<String, String> env, Container c) {
        List list = c.getEnv();
        for (Map.Entry<String, String> e : env.entrySet()) {
            list.add(new EnvVar(e.getKey(), e.getValue(), null));
        }
    }

    private void setLimitsOnContainer(FlowControlDeploymentService.DeploymentSpec ds, Container c) {
        ResourceRequirements rr;
        FlowControlDeploymentService.ResourceSpecs rs = ds.getResourceSpecs();
        String cpuReq = rs.cpuRequest();
        String cpuLimit = rs.cpuLimit();
        String mem = rs.memLimit();
        HashMap<String, Quantity> map = new HashMap<String, Quantity>();
        if (mem != null) {
            map.put("memory", new Quantity(mem));
        }
        if (cpuReq != null) {
            map.put("cpu", new Quantity(cpuReq));
        }
        if (map.size() > 0) {
            rr = c.getResources();
            if (rr == null) {
                rr = new ResourceRequirements();
                c.setResources(rr);
            }
            rr.setRequests(map);
        }
        map = new HashMap();
        if (mem != null) {
            map.put("memory", new Quantity(mem));
        }
        if (cpuLimit != null) {
            map.put("cpu", new Quantity(cpuLimit));
        }
        if (map.size() > 0) {
            rr = c.getResources();
            if (rr == null) {
                rr = new ResourceRequirements();
                c.setResources(rr);
            }
            rr.setLimits(map);
        }
    }

    private static void mapException(KubernetesClientException x) throws FlowControlDeploymentService.RequestException, FlowControlDeploymentService.ServiceException {
        int status = x.getStatus().getCode();
        if (HttpStatusCodes.isClientFailure((int)status)) {
            switch (status) {
                case 404: {
                    throw new FlowControlDeploymentService.RequestException("Object not found.");
                }
                case 400: {
                    throw new FlowControlDeploymentService.RequestException("Bad request.");
                }
            }
            throw new FlowControlDeploymentService.RequestException(x);
        }
        throw new FlowControlDeploymentService.ServiceException(x);
    }

    private static void mapExceptionSvcOnly(KubernetesClientException x) throws FlowControlDeploymentService.ServiceException {
        throw new FlowControlDeploymentService.ServiceException(x);
    }

    private K8sDeployWrapper getDeployment(String tag) {
        try {
            StatefulSetList ssl = (StatefulSetList)((NonNamespaceOperation)this.fApiClient.apps().statefulSets().inNamespace(this.fNamespace)).list();
            for (StatefulSet ss : ssl.getItems()) {
                if (!ss.getMetadata().getName().equals(tag)) continue;
                return new K8sDeployWrapper(ss);
            }
        }
        catch (KubernetesClientException | IllegalStateException x) {
            log.warn(x.getMessage());
        }
        try {
            DeploymentList dl = (DeploymentList)((NonNamespaceOperation)this.fApiClient.apps().deployments().inNamespace(this.fNamespace)).list();
            for (Deployment d : dl.getItems()) {
                if (!d.getMetadata().getName().equals(tag)) continue;
                return new K8sDeployWrapper(d);
            }
        }
        catch (KubernetesClientException | IllegalStateException x) {
            log.warn(x.getMessage());
        }
        return null;
    }

    private List<K8sDeployWrapper> getK8sDeployments() {
        LinkedList<K8sDeployWrapper> result = new LinkedList<K8sDeployWrapper>();
        for (Deployment d : ((DeploymentList)((NonNamespaceOperation)this.fApiClient.apps().deployments().inNamespace(this.fNamespace)).list()).getItems()) {
            result.add(new K8sDeployWrapper(d));
        }
        for (Deployment d : ((StatefulSetList)((NonNamespaceOperation)this.fApiClient.apps().statefulSets().inNamespace(this.fNamespace)).list()).getItems()) {
            result.add(new K8sDeployWrapper((StatefulSet)d));
        }
        return result;
    }

    private List<Pod> getPodsFor(String tag) {
        PodList pl = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.fApiClient.pods().inNamespace(this.fNamespace)).withLabel("app", "job-" + tag)).list();
        return pl.getItems();
    }

    private String replaceAllTokens(InputStream src, JSONObject replacements) throws IOException {
        byte[] bytes = StreamTools.readBytes((InputStream)src);
        String origText = new String(bytes, StandardCharsets.UTF_8);
        return ExpressionEvaluator.evaluateText((String)origText, (ExprDataSource[])new ExprDataSource[]{new JsonDataSource(this.fInitYamlSettings), new JsonDataSource(replacements), new EnvDataSource()});
    }

    private static int safeInt(Integer i) {
        return i == null ? 0 : i;
    }

    private static String selectValue(String ... values) {
        for (String val : values) {
            if (val == null || val.length() <= 0) continue;
            return val;
        }
        return null;
    }

    static /* synthetic */ String access$1600(K8sController x0) {
        return x0.fDefCpuLimit;
    }

    static /* synthetic */ String access$1700(K8sController x0) {
        return x0.fDefCpuRequest;
    }

    static /* synthetic */ String access$1800(K8sController x0) {
        return x0.fDefMemLimit;
    }

    static /* synthetic */ String access$1900(K8sController x0) {
        return x0.fDefPersistDiskSize;
    }

    static /* synthetic */ String access$2000(K8sController x0) {
        return x0.fDefLogDiskSize;
    }

    private static class LocalDeploymentSpec
    implements FlowControlDeploymentService.DeploymentSpec {
        private final LocalDeploymentSpecBuilder fBuilder;

        public LocalDeploymentSpec(LocalDeploymentSpecBuilder builder) {
            this.fBuilder = builder;
        }

        @Override
        public FlowControlJob getJob() {
            return this.fBuilder.fJob;
        }

        @Override
        public int getInstanceCount() {
            return this.fBuilder.fInstances;
        }

        @Override
        public Map<String, String> getEnv() {
            return this.fBuilder.fEnv;
        }

        @Override
        public FlowControlDeploymentService.ResourceSpecs getResourceSpecs() {
            return new FlowControlDeploymentService.ResourceSpecs(){

                @Override
                public String cpuRequest() {
                    return fBuilder.fCpuRequest;
                }

                @Override
                public String cpuLimit() {
                    return fBuilder.fCpuLimit;
                }

                @Override
                public String memLimit() {
                    return fBuilder.fMemLimit;
                }

                @Override
                public String persistDiskSize() {
                    return fBuilder.fPersistDiskSize;
                }

                @Override
                public String logDiskSize() {
                    return fBuilder.fLogDiskSize;
                }

                @Override
                public List<FlowControlDeploymentService.Toleration> tolerations() {
                    return fBuilder.fTolerations;
                }
            };
        }
    }

    private class LocalDeploymentSpecBuilder
    implements FlowControlDeploymentService.DeploymentSpecBuilder {
        private FlowControlJob fJob;
        private int fInstances = 1;
        private HashMap<String, String> fEnv = new HashMap();
        private String fCpuLimit = K8sController.access$1600(K8sController.this);
        private String fCpuRequest = K8sController.access$1700(K8sController.this);
        private String fMemLimit = K8sController.access$1800(K8sController.this);
        private String fPersistDiskSize = K8sController.access$1900(K8sController.this);
        private String fLogDiskSize = K8sController.access$2000(K8sController.this);
        private LinkedList<FlowControlDeploymentService.Toleration> fTolerations = new LinkedList();

        private LocalDeploymentSpecBuilder() {
        }

        @Override
        public FlowControlDeploymentService.DeploymentSpecBuilder forJob(FlowControlJob job) {
            this.fJob = job;
            return this;
        }

        @Override
        public FlowControlDeploymentService.DeploymentSpecBuilder withInstances(int count) {
            this.fInstances = count;
            return this;
        }

        @Override
        public FlowControlDeploymentService.DeploymentSpecBuilder withEnv(String key, String val) {
            this.fEnv.put(key, val);
            return this;
        }

        @Override
        public FlowControlDeploymentService.DeploymentSpecBuilder withEnv(Map<String, String> keyValMap) {
            this.fEnv.putAll(keyValMap);
            return this;
        }

        @Override
        public FlowControlDeploymentService.ResourceSpecBuilder withResourceSpecs() {
            return new FlowControlDeploymentService.ResourceSpecBuilder(){

                @Override
                public FlowControlDeploymentService.ResourceSpecBuilder withCpuRequest(String cpuReq) {
                    LocalDeploymentSpecBuilder.this.fCpuRequest = K8sController.selectValue(new String[]{cpuReq, LocalDeploymentSpecBuilder.this.fCpuRequest, LocalDeploymentSpecBuilder.this.fCpuLimit});
                    return this;
                }

                @Override
                public FlowControlDeploymentService.ResourceSpecBuilder withCpuLimit(String cpuLimit) {
                    LocalDeploymentSpecBuilder.this.fCpuLimit = K8sController.selectValue(new String[]{cpuLimit, LocalDeploymentSpecBuilder.this.fCpuLimit});
                    return this;
                }

                @Override
                public FlowControlDeploymentService.ResourceSpecBuilder withMemLimit(String memLimit) {
                    LocalDeploymentSpecBuilder.this.fMemLimit = K8sController.selectValue(new String[]{memLimit, LocalDeploymentSpecBuilder.this.fMemLimit});
                    return this;
                }

                @Override
                public FlowControlDeploymentService.ResourceSpecBuilder withPersistDiskSize(String diskSize) {
                    LocalDeploymentSpecBuilder.this.fPersistDiskSize = K8sController.selectValue(new String[]{diskSize, LocalDeploymentSpecBuilder.this.fPersistDiskSize});
                    return this;
                }

                @Override
                public FlowControlDeploymentService.ResourceSpecBuilder withLogDiskSize(String diskSize) {
                    LocalDeploymentSpecBuilder.this.fLogDiskSize = K8sController.selectValue(new String[]{diskSize, LocalDeploymentSpecBuilder.this.fLogDiskSize});
                    return this;
                }

                @Override
                public FlowControlDeploymentService.ResourceSpecBuilder withToleration(FlowControlDeploymentService.Toleration tol) {
                    LocalDeploymentSpecBuilder.this.fTolerations.add(tol);
                    return this;
                }

                @Override
                public FlowControlDeploymentService.DeploymentSpecBuilder build() {
                    return LocalDeploymentSpecBuilder.this;
                }
            };
        }

        @Override
        public FlowControlDeploymentService.DeploymentSpec build() throws Builder.BuildFailure {
            if (this.fJob == null) {
                throw new Builder.BuildFailure("No job provided.");
            }
            return new LocalDeploymentSpec(this);
        }
    }

    private class IntDeployment
    implements FlowControlDeployment {
        private final String fTag;
        private final String fJobId;

        public IntDeployment(String tag, String jobId) {
            this.fTag = tag;
            this.fJobId = jobId;
        }

        @Override
        public String getId() {
            return this.fTag;
        }

        @Override
        public String getJobId() {
            return this.fJobId;
        }

        @Override
        public FlowControlDeployment.Status getStatus() {
            K8sDeployWrapper d = K8sController.this.getDeployment(this.fTag);
            return d == null ? FlowControlDeployment.Status.UNKNOWN : d.getStatus();
        }

        @Override
        public int instanceCount() {
            K8sDeployWrapper d = K8sController.this.getDeployment(this.fTag);
            return d == null ? -1 : d.getReplicaCount();
        }

        @Override
        public Set<String> instances() {
            TreeSet<String> result = new TreeSet<String>();
            List pods = K8sController.this.getPodsFor(this.fTag);
            for (Pod p : pods) {
                result.add(p.getMetadata().getName());
            }
            return result;
        }

        @Override
        public String getPodId(int instanceNo) {
            List pods = K8sController.this.getPodsFor(this.fTag);
            if (pods.size() > instanceNo) {
                return ((Pod)pods.get(instanceNo)).getMetadata().getName();
            }
            return null;
        }

        @Override
        public List<String> getLog(String instanceId, String sinceRfc3339Time) throws FlowControlDeploymentService.RequestException, FlowControlDeploymentService.ServiceException {
            LinkedList<String> result = new LinkedList<String>();
            try {
                String[] lines;
                PodResource pod = (PodResource)((NonNamespaceOperation)K8sController.this.fApiClient.pods().inNamespace(K8sController.this.fNamespace)).withName(instanceId);
                String logText = sinceRfc3339Time != null ? ((TailPrettyLoggable)pod.sinceTime(sinceRfc3339Time)).getLog() : pod.getLog();
                for (String line : lines = logText.split("\\n")) {
                    result.add(line);
                }
            }
            catch (KubernetesClientException x) {
                K8sController.mapException(x);
            }
            return result;
        }
    }

    private class K8sDeployWrapper {
        private final Deployment fDeployment;
        private final StatefulSet fStatefulSet;

        public K8sDeployWrapper(Deployment d) {
            this.fDeployment = d;
            this.fStatefulSet = null;
        }

        public K8sDeployWrapper(StatefulSet ss) {
            this.fDeployment = null;
            this.fStatefulSet = ss;
        }

        public ObjectMeta getMetadata() {
            if (this.fDeployment != null) {
                return this.fDeployment.getMetadata();
            }
            if (this.fStatefulSet != null) {
                return this.fStatefulSet.getMetadata();
            }
            return null;
        }

        public void delete() {
            if (this.fDeployment != null) {
                K8sController.this.fApiClient.resource((HasMetadata)this.fDeployment).delete();
            }
            if (this.fStatefulSet != null) {
                K8sController.this.fApiClient.resource((HasMetadata)this.fStatefulSet).delete();
            }
        }

        public FlowControlDeployment.Status getStatus() {
            if (this.fDeployment != null) {
                boolean progressing = false;
                boolean available = false;
                DeploymentStatus ds = this.fDeployment.getStatus();
                for (DeploymentCondition dc : ds.getConditions()) {
                    String type = dc.getType();
                    String status = dc.getStatus();
                    if (type.equalsIgnoreCase("progressing") && status.equalsIgnoreCase("true")) {
                        progressing = true;
                        continue;
                    }
                    if (!type.equalsIgnoreCase("available") || !status.equalsIgnoreCase("true")) continue;
                    available = true;
                }
                if (progressing && available) {
                    return FlowControlDeployment.Status.RUNNING;
                }
                if (progressing && !available) {
                    return FlowControlDeployment.Status.PENDING;
                }
            } else if (this.fStatefulSet != null) {
                int replReqd = K8sController.safeInt(this.fStatefulSet.getSpec().getReplicas());
                StatefulSetStatus sss = this.fStatefulSet.getStatus();
                int ready = K8sController.safeInt(sss.getReadyReplicas());
                int repls = K8sController.safeInt(sss.getReplicas());
                log.info("Sts {}: {} reqd, {} created, {} ready", new Object[]{this.fStatefulSet.getMetadata().getName(), replReqd, repls, ready});
                if (ready < replReqd) {
                    return FlowControlDeployment.Status.PENDING;
                }
                if (ready == replReqd) {
                    return FlowControlDeployment.Status.RUNNING;
                }
            }
            return FlowControlDeployment.Status.UNKNOWN;
        }

        public int getReplicaCount() {
            if (this.fDeployment != null) {
                DeploymentStatus ds = this.fDeployment.getStatus();
                return ds.getReplicas();
            }
            return -1;
        }
    }

    private static class SimpleImageMapper
    implements ContainerImageMapper {
        private SimpleImageMapper() {
        }

        @Override
        public String getImageName(FlowControlRuntimeSpec rs) {
            return rs.getName() + ":" + rs.getVersion();
        }
    }
}

