/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.endpoints;

import io.continual.builder.Builder;
import io.continual.flowcontrol.FlowControlCallContext;
import io.continual.flowcontrol.FlowControlService;
import io.continual.flowcontrol.controlapi.FlowControlDeployment;
import io.continual.flowcontrol.controlapi.FlowControlDeploymentService;
import io.continual.flowcontrol.controlapi.FlowControlRuntimeSpec;
import io.continual.flowcontrol.jobapi.FlowControlJob;
import io.continual.flowcontrol.jobapi.FlowControlJobConfig;
import io.continual.flowcontrol.jobapi.FlowControlJobDb;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.iam.IamServiceManager;
import io.continual.iam.access.AccessControlEntry;
import io.continual.iam.access.AccessException;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.iam.identity.UserContext;
import io.continual.restHttp.ApiContextHelper;
import io.continual.restHttp.HttpServlet;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonVisitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class FlowControlRoutes<I extends Identity>
extends ApiContextHelper<I> {
    private final FlowControlService fFlowControl;

    public FlowControlRoutes(IamServiceManager<I, ?> accts, FlowControlService fcs) {
        super(accts);
        this.fFlowControl = fcs;
    }

    public void getJobs(CHttpRequestContext context) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, new ApiContextHelper.ApiHandler<I>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<I> uc) throws IOException {
                try {
                    FlowControlCallContext fccc = FlowControlRoutes.this.fFlowControl.createtContextBuilder().asUser(uc.getUser()).build();
                    FlowControlJobDb jobDb = FlowControlRoutes.this.fFlowControl.getJobDb(fccc);
                    Collection<FlowControlJob> jobs = jobDb.getJobsFor(fccc);
                    LinkedList<String> jobNames = new LinkedList<String>();
                    for (FlowControlJob job : jobs) {
                        jobNames.add(job.getName());
                    }
                    Collections.sort(jobNames);
                    FlowControlRoutes.sendJson((CHttpRequestContext)context, (JSONObject)new JSONObject().put("jobs", (Object)JsonVisitor.listToArray(jobNames)));
                }
                catch (FlowControlJobDb.ServiceException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the flow control job database.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[0]);
    }

    public void getJob(CHttpRequestContext context, final String id) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, new ApiContextHelper.ApiHandler<I>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<I> uc) throws IOException {
                try {
                    FlowControlCallContext fccc = FlowControlRoutes.this.fFlowControl.createtContextBuilder().asUser(uc.getUser()).build();
                    FlowControlJobDb jobDb = FlowControlRoutes.this.fFlowControl.getJobDb(fccc);
                    FlowControlJob job = jobDb.getJob(fccc, id);
                    if (job == null) {
                        FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"no such job");
                    } else {
                        FlowControlRoutes.sendJson((CHttpRequestContext)context, (JSONObject)FlowControlRoutes.render(job));
                    }
                }
                catch (FlowControlJobDb.ServiceException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the flow control job database.");
                }
                catch (AccessException x) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)401, (String)x.getMessage());
                }
            }
        }, new ApiContextHelper.ResourceAccess[0]);
    }

    public void createJob(CHttpRequestContext context) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, new ApiContextHelper.ApiHandler<I>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<I> uc) throws IOException {
                try {
                    JSONObject payload = new JSONObject((JSONTokener)new CommentedJsonTokener(context.request().getBodyStream()));
                    String name = payload.getString("name");
                    FlowControlCallContext fccc = FlowControlRoutes.this.fFlowControl.createtContextBuilder().asUser(uc.getUser()).build();
                    FlowControlJobDb jobDb = FlowControlRoutes.this.fFlowControl.getJobDb(fccc);
                    FlowControlJob job = jobDb.createJob(fccc).withName(name).build();
                    job.getAccessControlList().setOwner(uc.getEffectiveUserId()).addAclEntry(new AccessControlEntry.Builder().forOwner().permit().operations(new String[]{"read", "update", "delete"}).build());
                    FlowControlRoutes.this.readJobPayloadInto(payload, job);
                    jobDb.storeJob(fccc, name, job);
                    FlowControlRoutes.sendJson((CHttpRequestContext)context, (JSONObject)FlowControlRoutes.render(job));
                }
                catch (FlowControlJobDb.ServiceException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the flow control job database.");
                }
                catch (FlowControlJobDb.RequestException | JSONException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)("There was a problem with your request: " + e.getMessage()));
                }
                catch (AccessException x) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)401, (String)x.getMessage());
                }
            }
        }, new ApiContextHelper.ResourceAccess[0]);
    }

    public void patchJob(CHttpRequestContext context, final String name) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, new ApiContextHelper.ApiHandler<I>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<I> uc) throws IOException {
                try {
                    JSONObject payload = new JSONObject((JSONTokener)new CommentedJsonTokener(context.request().getBodyStream()));
                    FlowControlCallContext fccc = FlowControlRoutes.this.fFlowControl.createtContextBuilder().asUser(uc.getUser()).build();
                    FlowControlJobDb jobDb = FlowControlRoutes.this.fFlowControl.getJobDb(fccc);
                    FlowControlJob job = jobDb.getJob(fccc, name);
                    if (job == null) {
                        FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"no such job");
                    } else {
                        boolean changesMade = FlowControlRoutes.this.readJobPayloadInto(payload, job);
                        if (changesMade) {
                            jobDb.storeJob(fccc, name, job);
                        }
                        FlowControlRoutes.sendJson((CHttpRequestContext)context, (JSONObject)FlowControlRoutes.render(job));
                    }
                }
                catch (FlowControlJobDb.ServiceException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the flow control job database.");
                }
                catch (FlowControlJobDb.RequestException | JSONException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)("There was a problem with your request: " + e.getMessage()));
                }
                catch (AccessException x) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)401, (String)x.getMessage());
                }
            }
        }, new ApiContextHelper.ResourceAccess[0]);
    }

    public void putSecret(CHttpRequestContext context, final String name, final String secretId) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, new ApiContextHelper.ApiHandler<I>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<I> uc) throws IOException {
                try {
                    FlowControlCallContext fccc = FlowControlRoutes.this.fFlowControl.createtContextBuilder().asUser(uc.getUser()).build();
                    FlowControlJobDb jobDb = FlowControlRoutes.this.fFlowControl.getJobDb(fccc);
                    FlowControlJob job = jobDb.getJob(fccc, name);
                    if (job == null) {
                        FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"no such job");
                    } else {
                        JSONObject payload = new JSONObject((JSONTokener)new CommentedJsonTokener(context.request().getBodyStream()));
                        Object value = payload.opt("value");
                        if (value == null) {
                            FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)"A value must be provided.");
                            return;
                        }
                        job.registerSecret(secretId, value.toString());
                        jobDb.storeJob(fccc, name, job);
                        FlowControlRoutes.sendJson((CHttpRequestContext)context, (JSONObject)FlowControlRoutes.render(job));
                    }
                }
                catch (FlowControlJobDb.ServiceException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the flow control job database.");
                }
                catch (FlowControlJobDb.RequestException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)("Couldn't process your request: " + e.getMessage()));
                }
                catch (JSONException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)("There was a problem with your request: " + e.getMessage()));
                }
                catch (AccessException x) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)401, (String)x.getMessage());
                }
            }
        }, new ApiContextHelper.ResourceAccess[0]);
    }

    public void deleteSecret(CHttpRequestContext context, final String name, final String secretId) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, new ApiContextHelper.ApiHandler<I>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<I> uc) throws IOException {
                try {
                    FlowControlCallContext fccc = FlowControlRoutes.this.fFlowControl.createtContextBuilder().asUser(uc.getUser()).build();
                    FlowControlJobDb jobDb = FlowControlRoutes.this.fFlowControl.getJobDb(fccc);
                    FlowControlJob job = jobDb.getJob(fccc, name);
                    if (job == null) {
                        FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"no such job");
                    } else {
                        job.removeSecretRef(secretId);
                        jobDb.storeJob(fccc, name, job);
                        FlowControlRoutes.sendJson((CHttpRequestContext)context, (JSONObject)FlowControlRoutes.render(job));
                    }
                }
                catch (FlowControlJobDb.ServiceException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the flow control job database.");
                }
                catch (FlowControlJobDb.RequestException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)("Couldn't process your request: " + e.getMessage()));
                }
                catch (JSONException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)("There was a problem with your request: " + e.getMessage()));
                }
                catch (AccessException x) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)401, (String)x.getMessage());
                }
            }
        }, new ApiContextHelper.ResourceAccess[0]);
    }

    private boolean readJobPayloadInto(JSONObject payload, final FlowControlJob job) throws FlowControlJobDb.RequestException, IOException, FlowControlJobDb.ServiceException, JSONException {
        JSONObject secrets;
        JSONObject runtime;
        boolean changesMade = false;
        final JSONObject config = payload.optJSONObject("config");
        if (config != null) {
            final String mimeType = config.getString("type");
            if (!mimeType.equalsIgnoreCase("application/json")) {
                throw new FlowControlJobDb.RequestException("Unsupported config type " + mimeType + ".");
            }
            job.setConfiguration(new FlowControlJobConfig(){

                @Override
                public String getDataType() {
                    return mimeType;
                }

                @Override
                public InputStream readConfiguration() {
                    return new ByteArrayInputStream(config.getJSONObject("data").toString().getBytes(StandardCharsets.UTF_8));
                }
            });
            changesMade = true;
        }
        if ((runtime = payload.optJSONObject("runtime")) != null) {
            job.setRuntimeSpec(new FlowControlRuntimeSpec(){

                @Override
                public String getName() {
                    return runtime.getString("name");
                }

                @Override
                public String getVersion() {
                    return runtime.getString("version");
                }
            });
            changesMade = true;
        }
        if ((secrets = payload.optJSONObject("secrets")) != null) {
            JsonVisitor.forEachElement((JSONObject)secrets, (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<String, FlowControlJobDb.ServiceException>(){

                public boolean visit(String key, String t) throws JSONException, FlowControlJobDb.ServiceException {
                    job.registerSecret(key, t);
                    return true;
                }
            });
            changesMade = true;
        }
        return changesMade;
    }

    public void deleteJob(CHttpRequestContext context, final String id) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, new ApiContextHelper.ApiHandler<I>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<I> uc) throws IOException {
                try {
                    FlowControlCallContext fccc = FlowControlRoutes.this.fFlowControl.createtContextBuilder().asUser(uc.getUser()).build();
                    FlowControlJobDb jobDb = FlowControlRoutes.this.fFlowControl.getJobDb(fccc);
                    jobDb.removeJob(fccc, id);
                    FlowControlRoutes.sendStatusOk((CHttpRequestContext)context, (String)("removed " + id));
                }
                catch (FlowControlJobDb.RequestException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)("Couldn't process your request: " + e.getMessage()));
                }
                catch (FlowControlJobDb.ServiceException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the flow control job database.");
                }
                catch (AccessException x) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)401, (String)x.getMessage());
                }
            }
        }, new ApiContextHelper.ResourceAccess[0]);
    }

    public void createDeployment(CHttpRequestContext context) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, new ApiContextHelper.ApiHandler<I>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<I> uc) throws IOException {
                try {
                    JSONObject payload = new JSONObject((JSONTokener)new CommentedJsonTokener(context.request().getBodyStream()));
                    String jobId = payload.getString("job");
                    int instanceCount = payload.optInt("instanceCount", 1);
                    JSONObject env = payload.optJSONObject("env");
                    FlowControlCallContext fccc = FlowControlRoutes.this.fFlowControl.createtContextBuilder().asUser(uc.getUser()).build();
                    FlowControlJobDb jobDb = FlowControlRoutes.this.fFlowControl.getJobDb(fccc);
                    FlowControlJob job = jobDb.getJob(fccc, jobId);
                    if (job == null) {
                        FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)("Couldn't load job: " + jobId));
                        return;
                    }
                    FlowControlDeploymentService api = FlowControlRoutes.this.fFlowControl.getDeployer(fccc);
                    FlowControlDeployment deploy = api.deploy(fccc, api.deploymentBuilder().forJob(job).withInstances(instanceCount).withEnv(JsonVisitor.objectToMap((JSONObject)env)).build());
                    FlowControlRoutes.sendJson((CHttpRequestContext)context, (JSONObject)new JSONObject().put("deployment", (Object)FlowControlRoutes.render(deploy, true)));
                }
                catch (Builder.BuildFailure | JSONException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)("There was a problem with your request: " + e.getMessage()));
                }
                catch (FlowControlJobDb.ServiceException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the flow control job database.");
                }
                catch (FlowControlDeploymentService.RequestException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)("There was a problem with your request: " + e.getMessage()));
                }
                catch (FlowControlDeploymentService.ServiceException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't deploy the job.");
                }
                catch (AccessException x) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)401, (String)x.getMessage());
                }
            }
        }, new ApiContextHelper.ResourceAccess[0]);
    }

    public void getDeployments(CHttpRequestContext context) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, new ApiContextHelper.ApiHandler<I>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<I> uc) throws IOException {
                try {
                    FlowControlCallContext fccc = FlowControlRoutes.this.fFlowControl.createtContextBuilder().asUser(uc.getUser()).build();
                    FlowControlDeploymentService deployApi = FlowControlRoutes.this.fFlowControl.getDeployer(fccc);
                    String jobSpecific = context.request().getParameter("job", null);
                    List<FlowControlDeployment> deployments = jobSpecific == null ? deployApi.getDeployments(fccc) : deployApi.getDeploymentsForJob(fccc, jobSpecific);
                    JSONObject deploymentContainer = new JSONObject();
                    for (FlowControlDeployment dd : deployments) {
                        deploymentContainer.put(dd.getId(), (Object)FlowControlRoutes.render(dd, false));
                    }
                    FlowControlRoutes.sendJson((CHttpRequestContext)context, (JSONObject)new JSONObject().put("deploys", (Object)deploymentContainer));
                }
                catch (FlowControlDeploymentService.ServiceException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the flow control controller.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[0]);
    }

    public void getDeployment(CHttpRequestContext context, final String deployId) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, new ApiContextHelper.ApiHandler<I>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<I> uc) throws IOException {
                block5: {
                    try {
                        FlowControlCallContext fccc = FlowControlRoutes.this.fFlowControl.createtContextBuilder().asUser(uc.getUser()).build();
                        FlowControlDeploymentService deployApi = FlowControlRoutes.this.fFlowControl.getDeployer(fccc);
                        FlowControlDeployment deployment = deployApi.getDeployment(fccc, deployId);
                        if (deployment != null) {
                            FlowControlRoutes.sendJson((CHttpRequestContext)context, (JSONObject)new JSONObject().put("deployment", (Object)FlowControlRoutes.render(deployment, true)));
                            break block5;
                        }
                        FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"Deployment not found.");
                    }
                    catch (FlowControlDeploymentService.ServiceException e) {
                        FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't complete your request.");
                    }
                }
            }
        }, new ApiContextHelper.ResourceAccess[0]);
    }

    public void getLogs(CHttpRequestContext context, final String deployId, final String instanceId) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, new ApiContextHelper.ApiHandler<I>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<I> uc) throws IOException {
                block19: {
                    try {
                        FlowControlCallContext fccc = FlowControlRoutes.this.fFlowControl.createtContextBuilder().asUser(uc.getUser()).build();
                        FlowControlDeploymentService deployApi = FlowControlRoutes.this.fFlowControl.getDeployer(fccc);
                        FlowControlDeployment deployment = deployApi.getDeployment(fccc, deployId);
                        if (deployment != null) {
                            String since = context.request().getParameter("since", null);
                            List<String> lines = deployment.getLog(instanceId, since);
                            try (PrintWriter pw = context.response().getStreamForTextResponse("text/plain");){
                                for (String line : lines) {
                                    pw.println(line);
                                }
                                break block19;
                            }
                        }
                        FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"Deployment not found.");
                    }
                    catch (FlowControlDeploymentService.RequestException e) {
                        FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)("There was a problem with your request: " + e.getMessage()));
                    }
                    catch (FlowControlDeploymentService.ServiceException e) {
                        FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't complete your request.");
                    }
                }
            }
        }, new ApiContextHelper.ResourceAccess[0]);
    }

    public void undeploy(CHttpRequestContext context, final String deployId) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, new ApiContextHelper.ApiHandler<I>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<I> uc) throws IOException {
                try {
                    FlowControlCallContext fccc = FlowControlRoutes.this.fFlowControl.createtContextBuilder().asUser(uc.getUser()).build();
                    FlowControlRoutes.this.fFlowControl.getDeployer(fccc).undeploy(fccc, deployId);
                    FlowControlRoutes.sendStatusOk((CHttpRequestContext)context, (String)("undeployed " + deployId));
                }
                catch (JSONException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)("There was a problem with your request: " + e.getMessage()));
                }
                catch (FlowControlDeploymentService.ServiceException e) {
                    FlowControlRoutes.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't deploy the job.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[0]);
    }

    private static JSONObject render(FlowControlJob job) throws JSONException, IOException, FlowControlJobDb.ServiceException {
        return new JSONObject().put("name", (Object)job.getName()).put("config", (Object)FlowControlRoutes.render(job.getConfiguration())).put("runtime", (Object)new JSONObject().put("name", (Object)job.getRuntimeSpec().getName()).put("version", (Object)job.getRuntimeSpec().getVersion())).put("secrets", (Object)JsonVisitor.listToArray(job.getSecretRefs()));
    }

    private static JSONObject render(FlowControlJobConfig config) throws IOException {
        JSONObject result;
        block13: {
            result = new JSONObject();
            String type = config.getDataType();
            result.put("type", (Object)type);
            try (InputStream is = config.readConfiguration();){
                if (type.equalsIgnoreCase("application/json")) {
                    result.put("data", (Object)new JSONObject((JSONTokener)new CommentedJsonTokener(is)));
                    break block13;
                }
                throw new IllegalArgumentException("Unsupported config type: " + type);
            }
        }
        return result;
    }

    private static JSONObject render(FlowControlDeployment deploy, boolean withId) throws JSONException, IOException {
        Set<String> instances = deploy.instances();
        JSONObject result = new JSONObject().put("job", (Object)deploy.getJobId()).put("instanceCount", instances.size()).put("instances", (Object)JsonVisitor.listToArray(instances));
        if (withId) {
            result.put("id", (Object)deploy.getId());
        }
        try {
            result.put("status", (Object)deploy.getStatus().toString());
        }
        catch (FlowControlDeploymentService.ServiceException e) {
            result.put("status", (Object)FlowControlDeployment.Status.UNKNOWN.toString());
        }
        return result;
    }
}

