/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.endpoints;

import io.continual.flowcontrol.controlapi.ConfigTransferService;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.context.CHttpResponse;
import io.continual.iam.identity.Identity;
import io.continual.restHttp.ApiContextHelper;
import io.continual.util.data.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ConfigFetch<I extends Identity>
extends ApiContextHelper<I> {
    private final ConfigTransferService fConfigTransfer;

    public ConfigFetch(ConfigTransferService configTransfer) {
        this.fConfigTransfer = configTransfer;
    }

    public void getConfig(CHttpRequestContext context, String id) throws IOException, ConfigTransferService.ServiceException {
        try (InputStream is = this.fConfigTransfer.fetch(id);){
            if (is == null) {
                ConfigFetch.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"Unknown configuration key.");
                return;
            }
            CHttpResponse resp = context.response();
            resp.setStatus(200);
            OutputStream os = resp.getStreamForBinaryResponse("application/octet-stream");
            StreamTools.copyStream((InputStream)is, (OutputStream)os);
            os.close();
        }
    }
}

