/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.controlapi;

import io.continual.builder.Builder;
import io.continual.flowcontrol.FlowControlCallContext;
import io.continual.flowcontrol.controlapi.FlowControlDeployment;
import io.continual.flowcontrol.jobapi.FlowControlJob;
import java.util.List;
import java.util.Map;

public interface FlowControlDeploymentService {
    public DeploymentSpecBuilder deploymentBuilder();

    public FlowControlDeployment deploy(FlowControlCallContext var1, DeploymentSpec var2) throws ServiceException, RequestException;

    public void undeploy(FlowControlCallContext var1, String var2) throws ServiceException;

    public FlowControlDeployment getDeployment(FlowControlCallContext var1, String var2) throws ServiceException;

    public List<FlowControlDeployment> getDeployments(FlowControlCallContext var1) throws ServiceException;

    public List<FlowControlDeployment> getDeploymentsForJob(FlowControlCallContext var1, String var2) throws ServiceException;

    public static interface DeploymentSpecBuilder {
        public DeploymentSpecBuilder forJob(FlowControlJob var1);

        public DeploymentSpecBuilder withInstances(int var1);

        public DeploymentSpecBuilder withEnv(String var1, String var2);

        public DeploymentSpecBuilder withEnv(Map<String, String> var1);

        public ResourceSpecBuilder withResourceSpecs();

        default public DeploymentSpecBuilder withResourceSpecs(ResourceSpecs spec) {
            return this.withResourceSpecs().withCpuRequest(spec.cpuRequest()).withCpuLimit(spec.cpuLimit()).withMemLimit(spec.memLimit()).withPersistDiskSize(spec.persistDiskSize()).withLogDiskSize(spec.logDiskSize()).withTolerations(spec.tolerations()).build();
        }

        public DeploymentSpec build() throws Builder.BuildFailure;
    }

    public static interface DeploymentSpec {
        public FlowControlJob getJob();

        public int getInstanceCount();

        public Map<String, String> getEnv();

        public ResourceSpecs getResourceSpecs();
    }

    public static interface ResourceSpecBuilder {
        public ResourceSpecBuilder withCpuRequest(String var1);

        public ResourceSpecBuilder withCpuLimit(String var1);

        public ResourceSpecBuilder withMemLimit(String var1);

        public ResourceSpecBuilder withPersistDiskSize(String var1);

        public ResourceSpecBuilder withLogDiskSize(String var1);

        public ResourceSpecBuilder withToleration(Toleration var1);

        default public ResourceSpecBuilder withTolerations(List<Toleration> tols) {
            for (Toleration tol : tols) {
                this.withToleration(tol);
            }
            return this;
        }

        public DeploymentSpecBuilder build();
    }

    public static interface ResourceSpecs {
        default public String cpuRequest() {
            return null;
        }

        default public String cpuLimit() {
            return null;
        }

        default public String memLimit() {
            return null;
        }

        default public String persistDiskSize() {
            return null;
        }

        default public String logDiskSize() {
            return null;
        }

        default public List<Toleration> tolerations() {
            return null;
        }
    }

    public static interface Toleration {
        default public String effect() {
            return null;
        }

        default public String key() {
            return null;
        }

        default public String operator() {
            return null;
        }

        default public Long seconds() {
            return null;
        }

        default public String value() {
            return null;
        }
    }

    public static class RequestException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public RequestException(String msg) {
            super(msg);
        }

        public RequestException(Throwable t) {
            super(t);
        }

        public RequestException(String msg, Throwable t) {
            super(msg, t);
        }
    }

    public static class ServiceException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ServiceException(String msg) {
            super(msg);
        }

        public ServiceException(Throwable t) {
            super(t);
        }

        public ServiceException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

