package io.ciogram.types

import kotlinx.serialization.*
import kotlinx.serialization.json.JsonClassDiscriminator

@Serializable
@JsonClassDiscriminator("type")
@OptIn(ExperimentalSerializationApi::class)
public sealed class InputMedia {
    public abstract val type: String
    public abstract val media: InputFile
}

@Serializable
@SerialName("photo")
public data class InputMediaPhoto(
    public override val media: InputFile,
    public val caption: String? = null,
    @SerialName("parse_mode") public val parseMode: String? = null,
    @SerialName("caption_entities") public val captionEntities: List<MessageEntity>? = null
) : InputMedia() {
    @Transient
    public override val type: String = "photo"
}

@Serializable
@SerialName("video")
public data class InputMediaVideo(
    public override val media: InputFile,
    public val thumb: InputFile? = null,
    public val caption: String? = null,
    @SerialName("parse_mode") public val parseMode: String? = null,
    @SerialName("caption_entities") public val captionEntities: List<MessageEntity>? = null,
    public val width: Int? = null,
    public val height: Int? = null,
    public val duration: Int? = null,
    @SerialName("supports_streaming") public val supportsStreaming: Boolean? = null
) : InputMedia() {
    @Transient
    public override val type: String = "video"
}

@Serializable
@SerialName("animation")
public data class InputMediaAnimation(
    public override val media: InputFile,
    public val thumb: InputFile? = null,
    public val caption: String? = null,
    @SerialName("parse_mode") public val parseMode: String? = null,
    @SerialName("caption_entities") public val captionEntities: List<MessageEntity>? = null,
    public val width: Int? = null,
    public val height: Int? = null,
    public val duration: Int? = null
) : InputMedia() {
    @Transient
    public override val type: String = "animation"
}

@Serializable
@SerialName("audio")
public data class InputMediaAudio(
    public override val media: InputFile,
    public val thumb: InputFile? = null,
    public val caption: String? = null,
    @SerialName("parse_mode") public val parseMode: String? = null,
    @SerialName("caption_entities") public val captionEntities: List<MessageEntity>? = null,
    public val duration: Int? = null,
    public val performer: String? = null,
    public val title: String? = null
) : InputMedia() {
    @Transient
    public override val type: String = "audio"
}

@Serializable
@SerialName("document")
public data class InputMediaDocument(
    public override val media: InputFile,
    public val thumb: InputFile? = null,
    public val caption: String? = null,
    @SerialName("parse_mode") public val parseMode: String? = null,
    @SerialName("caption_entities") public val captionEntities: List<MessageEntity>? = null,
    @SerialName("disable_content_type_detection") public val disableContentTypeDetection: Boolean? = null
) : InputMedia() {
    @Transient
    public override val type: String = "document"
}