package io.ciogram.types

public inline fun InlineKeyboardMarkup(block: InlineKeyboardMarkupBuilder.() -> Unit): InlineKeyboardMarkup {
    return InlineKeyboardMarkupBuilder().apply(block).build()
}

public class InlineKeyboardMarkupBuilder @PublishedApi internal constructor() {
    @PublishedApi
    internal val rows: MutableList<List<InlineKeyboardButton>> = mutableListOf()

    public inline fun row(block: InlineKeyboardRowBuilder.() -> Unit) {
        rows.add(InlineKeyboardRowBuilder().apply(block).build())
    }

    public fun build(): InlineKeyboardMarkup {
        return InlineKeyboardMarkup(rows.toList())
    }
}

public class InlineKeyboardRowBuilder @PublishedApi internal constructor() {
    @PublishedApi
    internal val buttons: MutableList<InlineKeyboardButton> = mutableListOf()

    public inline fun button(text: String, block: InlineKeyboardButtonBuilder.() -> Unit) {
        buttons.add(InlineKeyboardButtonBuilder(text).apply(block).build())
    }

    public fun build(): List<InlineKeyboardButton> {
        return buttons.toList()
    }
}

public class InlineKeyboardButtonBuilder @PublishedApi internal constructor(public var text: String) {
    public var url: String? = null
    public var loginUrl: LoginUrl? = null
    public var callbackData: String? = null
    public var switchInlineQuery: String? = null
    public var switchInlineQueryCurrentChat: String? = null
    public var callbackGame: CallbackGame? = null
    public var pay: Boolean? = null

    public fun build(): InlineKeyboardButton {
        return InlineKeyboardButton(text, url, loginUrl, callbackData, switchInlineQuery, switchInlineQueryCurrentChat, callbackGame, pay)
    }
}