package io.ciogram.types

import kotlinx.serialization.*

@Serializable
public data class Chat(
    public val id: Long,
    public val type: String,
    public val title: String? = null,
    public val username: String? = null,
    @SerialName("first_name") public val firstName: String? = null,
    @SerialName("last_name") public val lastName: String? = null,
    public val photo: ChatPhoto? = null,
    public val bio: String? = null,
    @SerialName("has_private_forwards") public val hasPrivateForwards: Boolean? = null,
    public val description: String? = null,
    @SerialName("invite_link") public val inviteLink: String? = null,
    @SerialName("pinned_message") public val pinnedMessage: Message? = null,
    public val permissions: ChatPermissions? = null,
    @SerialName("slow_mode_delay") public val slowModeDelay: Int? = null,
    @SerialName("message_auto_delete_time") public val messageAutoDeleteTime: Int? = null,
    @SerialName("has_protected_content") public val hasProtectedContent: Boolean? = null,
    @SerialName("sticker_set_name") public val stickerSetName: String? = null,
    @SerialName("can_set_sticker_set") public val canSetStickerSet: Boolean? = null,
    @SerialName("linked_chat_id") public val linkedChatId: Long? = null,
    public val location: ChatLocation? = null
)