/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.inject.spi;

import io.avaje.inject.BeanScopeBuilder;
import io.avaje.inject.aop.AspectProvider;
import io.avaje.inject.spi.GenericType;
import io.avaje.inject.spi.Plugin;
import io.avaje.inject.spi.PropertyRequiresPlugin;
import io.avaje.validation.ValidMethod;
import io.avaje.validation.Validator;
import io.avaje.validation.adapter.MethodAdapterProvider;
import io.avaje.validation.adapter.ValidationContext;
import io.avaje.validation.inject.aspect.AOPMethodValidator;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public final class DefaultValidatorProvider
implements Plugin {
    public Class<?>[] provides() {
        return new Class[]{Validator.class};
    }

    public Class<?>[] providesAspects() {
        return new Class[]{ValidMethod.class};
    }

    public void apply(BeanScopeBuilder builder) {
        this.validator(builder);
        this.paramAspect(builder);
    }

    private void validator(BeanScopeBuilder builder) {
        builder.provideDefault(null, Validator.class, () -> {
            PropertyRequiresPlugin props = builder.propertyPlugin();
            Validator.Builder validator = Validator.builder().failFast(props.equalTo("validation.failFast", "true"));
            props.get("validation.resourcebundle.names").map(s -> s.split(",")).ifPresent(arg_0 -> ((Validator.Builder)validator).addResourceBundles(arg_0));
            props.get("validation.locale.default").map(Locale::forLanguageTag).ifPresent(arg_0 -> ((Validator.Builder)validator).setDefaultLocale(arg_0));
            props.get("validation.locale.addedLocales").stream().flatMap(s -> Arrays.stream(s.split(","))).map(Locale::forLanguageTag).forEach(xva$0 -> validator.addLocales(new Locale[]{xva$0}));
            props.get("validation.temporal.tolerance.value").map(Long::valueOf).ifPresent(duration -> {
                ChronoUnit unit = props.get("validation.temporal.tolerance.chronoUnit").map(ChronoUnit::valueOf).orElse(ChronoUnit.MILLIS);
                validator.temporalTolerance(Duration.of(duration, unit));
            });
            return validator.build();
        });
    }

    private void paramAspect(BeanScopeBuilder builder) {
        builder.provideDefault(null, new GenericType<AspectProvider<ValidMethod>>(){}.type(), () -> {
            AOPMethodValidator methodValidator = new AOPMethodValidator();
            builder.addPostConstruct(b -> {
                ValidationContext ctx = ((Validator)b.get(Validator.class)).context();
                Map<Method, MethodAdapterProvider> map = b.list(MethodAdapterProvider.class).stream().collect(Collectors.toMap(MethodAdapterProvider::provide, p -> p));
                methodValidator.post(ctx, map);
            });
            return methodValidator;
        });
    }
}

