/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.mojo;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.classfile.ClassElement;
import java.lang.classfile.ClassFile;
import java.lang.classfile.ClassFileElement;
import java.lang.classfile.ClassModel;
import java.lang.classfile.attribute.ModuleAttribute;
import java.lang.classfile.attribute.ModuleProvideInfo;
import java.lang.classfile.attribute.ModuleRequireInfo;
import java.lang.classfile.constantpool.Utf8Entry;
import java.lang.constant.ClassDesc;
import java.lang.constant.ModuleDesc;
import java.lang.reflect.AccessFlag;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class ModuleSPIProcessor {
    private static final String IO_AVAJE_JSONB_PLUGIN = "io.avaje.jsonb.plugin";
    private static final String IO_AVAJE_INJECT = "io.avaje.inject";
    private static final String IO_AVAJE_VALIDATOR_PLUGIN = "io.avaje.validation.plugin";
    private static final String IO_AVAJE_VALIDATOR_HTTP_PLUGIN = "io.avaje.validation.http";
    private static final Set<String> avajeModuleNames = new HashSet<String>();
    private final MavenProject project;
    private final Log log;

    public ModuleSPIProcessor(MavenProject project, Log log) {
        this.project = project;
        this.log = log;
    }

    public void execute() throws MojoExecutionException {
        File directory = new File(this.project.getBuild().getDirectory());
        if (!directory.exists()) {
            throw new MojoExecutionException("Failed to find build folder");
        }
        String dirPath = directory.getAbsolutePath();
        Path moduleCF = Paths.get(dirPath + "\\classes\\module-info.class", new String[0]);
        Path servicesDirectory = Paths.get(dirPath + "\\classes\\META-INF\\services", new String[0]);
        if (!moduleCF.toFile().exists()) {
            return;
        }
        try {
            byte[] newModuleFile = this.transform(moduleCF, servicesDirectory);
            Files.delete(moduleCF);
            Files.write(moduleCF, newModuleFile, StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write spi classes", (Exception)e);
        }
    }

    private byte[] transform(Path moduleCF, Path metaInfServicesPath) throws IOException {
        ClassFile cf = ClassFile.of();
        ClassModel classModel = cf.parse(moduleCF);
        return cf.build(classModel.thisClass().asSymbol(), classBuilder -> {
            for (ClassElement ce : classModel) {
                if (!(ce instanceof ModuleAttribute)) {
                    classBuilder.with((ClassFileElement)ce);
                    continue;
                }
                ModuleAttribute ma = (ModuleAttribute)ce;
                ModuleAttribute newModule = ModuleAttribute.of((ModuleDesc)ma.moduleName().asSymbol(), b -> this.transformDirectives(ma, (ModuleAttribute.ModuleAttributeBuilder)b, metaInfServicesPath));
                classBuilder.with((ClassFileElement)newModule);
            }
        });
    }

    private void transformDirectives(ModuleAttribute moduleAttribute, ModuleAttribute.ModuleAttributeBuilder moduleBuilder, Path metaInfServicesPath) {
        moduleAttribute.moduleFlags().forEach(xva$0 -> moduleBuilder.moduleFlags(new AccessFlag[]{xva$0}));
        moduleBuilder.moduleFlags(moduleAttribute.moduleFlagsMask());
        moduleAttribute.exports().forEach(arg_0 -> ((ModuleAttribute.ModuleAttributeBuilder)moduleBuilder).exports(arg_0));
        moduleAttribute.opens().forEach(arg_0 -> ((ModuleAttribute.ModuleAttributeBuilder)moduleBuilder).opens(arg_0));
        moduleAttribute.requires().stream().filter(r -> !r.has(AccessFlag.STATIC)).map(r -> r.requires().name().toString()).filter(n -> n.contains("io.avaje")).forEach(avajeModuleNames::add);
        moduleAttribute.requires().forEach(r -> this.requires((ModuleRequireInfo)r, moduleBuilder));
        moduleAttribute.uses().forEach(arg_0 -> ((ModuleAttribute.ModuleAttributeBuilder)moduleBuilder).uses(arg_0));
        if (!metaInfServicesPath.toFile().exists()) {
            moduleAttribute.provides().stream().forEach(arg_0 -> ((ModuleAttribute.ModuleAttributeBuilder)moduleBuilder).provides(arg_0));
            return;
        }
        try (Stream<Path> servicesDir = Files.walk(metaInfServicesPath, new FileVisitOption[0]);){
            this.addServices(moduleAttribute, moduleBuilder, servicesDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void requires(ModuleRequireInfo moduleRequires, ModuleAttribute.ModuleAttributeBuilder moduleBuilder) {
        String moduleString = moduleRequires.requires().name().stringValue();
        if (moduleRequires.has(AccessFlag.STATIC) || !moduleString.contains("avaje")) {
            moduleBuilder.requires(moduleRequires);
            return;
        }
        moduleBuilder.requires(moduleRequires);
        switch (moduleString) {
            case "io.avaje.jsonb": {
                if (avajeModuleNames.contains(IO_AVAJE_JSONB_PLUGIN) || !avajeModuleNames.contains(IO_AVAJE_INJECT)) break;
                ModuleRequireInfo plugin = ModuleRequireInfo.of((ModuleDesc)ModuleDesc.of(IO_AVAJE_JSONB_PLUGIN), (int)moduleRequires.requiresFlagsMask(), (String)moduleRequires.requiresVersion().map(Utf8Entry::stringValue).orElse(null));
                moduleBuilder.requires(plugin);
                this.log.info((CharSequence)"Adding `requires %s;` to compiled module-info.class".formatted(IO_AVAJE_JSONB_PLUGIN));
                break;
            }
            case "io.avaje.validation": {
                if (!avajeModuleNames.contains(IO_AVAJE_INJECT)) break;
                boolean hasHttp = avajeModuleNames.contains("io.avaje.http.api");
                if (!avajeModuleNames.contains(IO_AVAJE_VALIDATOR_PLUGIN) && !avajeModuleNames.contains(IO_AVAJE_VALIDATOR_HTTP_PLUGIN)) {
                    String pluginModule = hasHttp ? IO_AVAJE_VALIDATOR_HTTP_PLUGIN : IO_AVAJE_VALIDATOR_PLUGIN;
                    ModuleRequireInfo plugin = ModuleRequireInfo.of((ModuleDesc)ModuleDesc.of(pluginModule), (int)moduleRequires.requiresFlagsMask(), (String)moduleRequires.requiresVersion().map(Utf8Entry::stringValue).orElse(null));
                    moduleBuilder.requires(plugin);
                    this.log.info((CharSequence)"Adding `requires %s;` to compiled module-info.class".formatted(pluginModule));
                    break;
                }
                if (avajeModuleNames.contains(IO_AVAJE_VALIDATOR_HTTP_PLUGIN) || !hasHttp) break;
                ModuleRequireInfo plugin = ModuleRequireInfo.of((ModuleDesc)ModuleDesc.of(IO_AVAJE_VALIDATOR_HTTP_PLUGIN), (int)moduleRequires.requiresFlagsMask(), (String)moduleRequires.requiresVersion().map(Utf8Entry::stringValue).orElse(null));
                moduleBuilder.requires(plugin);
                this.log.info((CharSequence)"Adding `requires %s;` to compiled module-info.class".formatted(IO_AVAJE_VALIDATOR_HTTP_PLUGIN));
                break;
            }
        }
    }

    private void addServices(ModuleAttribute moduleAttribute, ModuleAttribute.ModuleAttributeBuilder moduleBuilder, Stream<Path> servicesDir) {
        Map<String, List> serviceMap = servicesDir.skip(1L).sorted(Comparator.comparing(Path::getFileName)).collect(Collectors.toMap(p -> p.getFileName().toString(), p -> {
            try {
                return Files.readAllLines(p).stream().map(s -> s.replace(" ", "").replace("$", ".").split(",")).flatMap(Arrays::stream).filter(Predicate.not(String::isBlank)).map(ClassDesc::of).toList();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }));
        moduleAttribute.provides().stream().filter(p -> !serviceMap.containsKey(p.provides().name().stringValue().replace("/", "."))).forEach(arg_0 -> ((ModuleAttribute.ModuleAttributeBuilder)moduleBuilder).provides(arg_0));
        serviceMap.forEach((k, v) -> {
            ClassDesc provides = ClassDesc.of(k);
            String with = v.stream().map(ClassDesc::displayName).collect(Collectors.joining(","));
            this.log.info((CharSequence)"Adding `provides %s with %s;` to compiled module-info.class".formatted(provides.displayName(), with));
            moduleBuilder.provides(ModuleProvideInfo.of((ClassDesc)provides, (List)v));
        });
    }
}

