/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.mojo;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="disable-apt-validation", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class DisableModuleValidationMojo
extends AbstractMojo {
    private static final String DISABLING_AVAJE_MODULE_VERIFICATION = "disabling avaje module verification";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        boolean canRun;
        boolean bl = canRun = Integer.getInteger("java.specification.version") == 23 && ManagementFactory.getRuntimeMXBean().getInputArguments().stream().anyMatch("--enable-preview"::equals);
        if (!canRun) {
            this.getLog().warn((CharSequence)"This version of the avaje-provides-plugin only works on JDK 23 with --enable-preview cofigured in MAVEN_OPTS");
            return;
        }
        File directory = new File(this.project.getBuild().getDirectory());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        try (FileWriter flagFile = this.createFileWriter("avaje-plugin-exists.txt");){
            flagFile.append(DISABLING_AVAJE_MODULE_VERIFICATION);
            this.getLog().info((CharSequence)DISABLING_AVAJE_MODULE_VERIFICATION);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write spi classes", (Exception)e);
        }
    }

    private FileWriter createFileWriter(String string) throws IOException {
        return new FileWriter(new File(this.project.getBuild().getDirectory(), string));
    }
}

