/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.stream.core;

import io.avaje.json.PropertyNames;
import io.avaje.json.stream.core.Escape;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

final class JsonNames
implements PropertyNames {
    static final JsonNames EMPTY = new JsonNames(new byte[0][0], Collections.emptyMap());
    private final byte[][] nameArray;
    private final Map<Integer, String> nameHash;

    JsonNames(byte[][] nameArray, Map<Integer, String> nameHash) {
        this.nameArray = nameArray;
        this.nameHash = nameHash;
    }

    public static JsonNames of(String ... names) {
        HashSet<Integer> clashKeys = new HashSet<Integer>();
        HashMap<Integer, String> nameHash = new HashMap<Integer, String>();
        byte[][] nameArray = new byte[names.length][];
        for (int i = 0; i < names.length; ++i) {
            nameArray[i] = Escape.quoteEscape(names[i]);
            int hash = Escape.nameHash(names[i]);
            String priorKey = nameHash.put(hash, names[i]);
            if (priorKey == null || priorKey.equals(names[i])) continue;
            clashKeys.add(hash);
        }
        for (Integer clashKey : clashKeys) {
            nameHash.remove(clashKey);
        }
        return new JsonNames(nameArray, nameHash);
    }

    byte[] key(int namePos) {
        return this.nameArray[namePos];
    }

    String lookup(int hash) {
        return this.nameHash.get(hash);
    }
}

