/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.stream.core;

import io.avaje.json.JsonIoException;
import io.avaje.json.stream.JsonOutput;
import io.avaje.json.stream.core.Base64;
import io.avaje.json.stream.core.Grisu3;
import io.avaje.json.stream.core.JsonGenerator;
import io.avaje.json.stream.core.JsonNames;
import io.avaje.json.stream.core.NumberWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;

class JGenerator
implements JsonGenerator {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final byte[] NULL = "null".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TRUE = "true".getBytes(StandardCharsets.UTF_8);
    private static final byte[] FALSE = "false".getBytes(StandardCharsets.UTF_8);
    private static final byte[] INDENT = "  ".getBytes(StandardCharsets.UTF_8);
    private static final byte OBJECT_START = 123;
    private static final byte OBJECT_END = 125;
    private static final byte ARRAY_START = 91;
    private static final byte ARRAY_END = 93;
    private static final byte NEWLINE = 10;
    private static final byte COMMA = 44;
    private static final byte SEMI = 58;
    private static final byte QUOTE = 34;
    private static final byte ESCAPE = 92;
    private static final byte SPACE = 32;
    private static final int OP_START = 1;
    private static final int OP_FIELD = 3;
    private static final int OP_END = 4;
    private final Grisu3.FastDtoaBuilder doubleBuilder = new Grisu3.FastDtoaBuilder();
    private final int largeStringMax;
    private final int largeAsciiMax;
    private byte[] buffer;
    private JsonOutput target;
    private int lastOp;
    private int position;
    private boolean pretty;
    private int depth;
    private final Deque<JsonNames> nameStack = new ArrayDeque<JsonNames>();
    private JsonNames currentNames;
    private boolean allNames;
    private boolean incomplete;

    JGenerator() {
        this(512);
    }

    JGenerator(int size) {
        this(new byte[size]);
    }

    JGenerator(byte[] buffer) {
        this.buffer = buffer;
        this.largeStringMax = buffer.length >> 3;
        this.largeAsciiMax = buffer.length - 10;
    }

    @Override
    public JsonGenerator prepare(JsonOutput targetStream) {
        this.target = targetStream;
        this.lastOp = 0;
        this.position = 0;
        this.pretty = false;
        this.nameStack.clear();
        this.allNames = false;
        this.currentNames = null;
        this.incomplete = false;
        return this;
    }

    int position() {
        return this.position;
    }

    byte[] ensureCapacity(int free) {
        if (this.position + free >= this.buffer.length) {
            this.enlargeOrFlush(this.position, free);
        }
        return this.buffer;
    }

    void advance(int size) {
        this.position += size;
    }

    private void enlargeOrFlush(int size, int padding) {
        if (this.target != null) {
            try {
                this.target.write(this.buffer, 0, size);
            }
            catch (IOException ex) {
                throw new JsonIoException("Unable to write to target stream.", ex);
            }
            this.position = 0;
            if (padding > this.buffer.length) {
                this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + this.buffer.length / 2 + padding);
            }
        } else {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + this.buffer.length / 2 + padding);
        }
    }

    private void writeByte(byte value) {
        if (this.position == this.buffer.length) {
            this.enlargeOrFlush(this.position, 0);
        }
        this.buffer[this.position++] = value;
    }

    private void writeString(String value) {
        int len = value.length();
        if (len > this.largeStringMax) {
            this.writeLargeString(value);
            return;
        }
        if (this.position + (len << 2) + (len << 1) + 2 >= this.buffer.length) {
            this.enlargeOrFlush(this.position, (len << 2) + (len << 1) + 2);
        }
        this.buffer[this.position++] = 34;
        this.writeStringSegment(value, 0, len);
        this.buffer[this.position++] = 34;
    }

    private void writeStringSegment(String value, int i, int end) {
        int cur = this.position;
        while (i < end) {
            char c = value.charAt(i);
            if (c <= '\u001f' || c == '\"' || c == '\\' || c >= '~') {
                this.writeStringEscape(value, i, cur, end);
                return;
            }
            this.buffer[cur++] = (byte)c;
            ++i;
        }
        this.position = cur;
    }

    private void writeLargeString(String text) {
        int len;
        this.writeByte((byte)34);
        int offset = 0;
        for (int left = text.length(); left > 0; left -= len) {
            len = Math.min(this.largeStringMax, left);
            if (this.position + (len << 2) + (len << 1) + 2 >= this.buffer.length) {
                this.enlargeOrFlush(this.position, 0);
            }
            this.writeStringSegment(text, offset, offset + len);
            offset += len;
        }
        this.writeByte((byte)34);
    }

    private void writeStringEscape(String str, int i, int cur, int len) {
        byte[] _result = this.buffer;
        while (i < len) {
            char c = str.charAt(i);
            if (c == '\"') {
                _result[cur++] = 92;
                _result[cur++] = 34;
            } else if (c == '\\') {
                _result[cur++] = 92;
                _result[cur++] = 92;
            } else if (c < ' ') {
                switch (c) {
                    case '\b': {
                        _result[cur++] = 92;
                        _result[cur++] = 98;
                        break;
                    }
                    case '\t': {
                        _result[cur++] = 92;
                        _result[cur++] = 116;
                        break;
                    }
                    case '\n': {
                        _result[cur++] = 92;
                        _result[cur++] = 110;
                        break;
                    }
                    case '\f': {
                        _result[cur++] = 92;
                        _result[cur++] = 102;
                        break;
                    }
                    case '\r': {
                        _result[cur++] = 92;
                        _result[cur++] = 114;
                        break;
                    }
                    default: {
                        _result[cur] = 92;
                        _result[cur + 1] = 117;
                        _result[cur + 2] = 48;
                        _result[cur + 3] = 48;
                        switch (c) {
                            case '\u0000': {
                                _result[cur + 4] = 48;
                                _result[cur + 5] = 48;
                                break;
                            }
                            case '\u0001': {
                                _result[cur + 4] = 48;
                                _result[cur + 5] = 49;
                                break;
                            }
                            case '\u0002': {
                                _result[cur + 4] = 48;
                                _result[cur + 5] = 50;
                                break;
                            }
                            case '\u0003': {
                                _result[cur + 4] = 48;
                                _result[cur + 5] = 51;
                                break;
                            }
                            case '\u0004': {
                                _result[cur + 4] = 48;
                                _result[cur + 5] = 52;
                                break;
                            }
                            case '\u0005': {
                                _result[cur + 4] = 48;
                                _result[cur + 5] = 53;
                                break;
                            }
                            case '\u0006': {
                                _result[cur + 4] = 48;
                                _result[cur + 5] = 54;
                                break;
                            }
                            case '\u0007': {
                                _result[cur + 4] = 48;
                                _result[cur + 5] = 55;
                                break;
                            }
                            case '\u000b': {
                                _result[cur + 4] = 48;
                                _result[cur + 5] = 66;
                                break;
                            }
                            case '\u000e': {
                                _result[cur + 4] = 48;
                                _result[cur + 5] = 69;
                                break;
                            }
                            case '\u000f': {
                                _result[cur + 4] = 48;
                                _result[cur + 5] = 70;
                                break;
                            }
                            case '\u0010': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 48;
                                break;
                            }
                            case '\u0011': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 49;
                                break;
                            }
                            case '\u0012': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 50;
                                break;
                            }
                            case '\u0013': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 51;
                                break;
                            }
                            case '\u0014': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 52;
                                break;
                            }
                            case '\u0015': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 53;
                                break;
                            }
                            case '\u0016': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 54;
                                break;
                            }
                            case '\u0017': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 55;
                                break;
                            }
                            case '\u0018': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 56;
                                break;
                            }
                            case '\u0019': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 57;
                                break;
                            }
                            case '\u001a': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 65;
                                break;
                            }
                            case '\u001b': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 66;
                                break;
                            }
                            case '\u001c': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 67;
                                break;
                            }
                            case '\u001d': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 68;
                                break;
                            }
                            case '\u001e': {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 69;
                                break;
                            }
                            default: {
                                _result[cur + 4] = 49;
                                _result[cur + 5] = 70;
                            }
                        }
                        cur += 6;
                        break;
                    }
                }
            } else if (c < '\u007f') {
                _result[cur++] = (byte)c;
            } else {
                int cp = Character.codePointAt(str, i);
                if (Character.isSupplementaryCodePoint(cp)) {
                    ++i;
                }
                if (cp == 127) {
                    _result[cur++] = (byte)cp;
                } else if (cp <= 2047) {
                    _result[cur++] = (byte)(0xC0 | cp >> 6 & 0x1F);
                    _result[cur++] = (byte)(0x80 | cp & 0x3F);
                } else if (cp < 55296 || cp > 57343 && cp <= 65535) {
                    _result[cur++] = (byte)(0xE0 | cp >> 12 & 0xF);
                    _result[cur++] = (byte)(0x80 | cp >> 6 & 0x3F);
                    _result[cur++] = (byte)(0x80 | cp & 0x3F);
                } else if (cp >= 65536 && cp <= 0x10FFFF) {
                    _result[cur++] = (byte)(0xF0 | cp >> 18 & 7);
                    _result[cur++] = (byte)(0x80 | cp >> 12 & 0x3F);
                    _result[cur++] = (byte)(0x80 | cp >> 6 & 0x3F);
                    _result[cur++] = (byte)(0x80 | cp & 0x3F);
                } else {
                    throw new JsonIoException("Unknown unicode codepoint in string! " + Integer.toHexString(cp));
                }
            }
            ++i;
        }
        this.position = cur;
    }

    private void writeAscii(String value) {
        int len = value.length();
        if (len > this.largeAsciiMax) {
            this.writeLargeAscii(value);
            return;
        }
        if (this.position + len >= this.buffer.length) {
            this.enlargeOrFlush(this.position, len);
        }
        value.getBytes(0, len, this.buffer, this.position);
        this.position += len;
    }

    private void writeLargeAscii(String value) {
        int len;
        int offset = 0;
        for (int left = value.length(); left > 0; left -= len) {
            len = Math.min(this.largeAsciiMax, left);
            if (this.position + len >= this.buffer.length) {
                this.enlargeOrFlush(this.position, 0);
            }
            value.getBytes(offset, offset + len, this.buffer, this.position);
            this.position += len;
            offset += len;
        }
    }

    private void writeAscii(byte[] buf) {
        int len = buf.length;
        if (this.position + len >= this.buffer.length) {
            this.enlargeOrFlush(this.position, len);
        }
        System.arraycopy(buf, 0, this.buffer, this.position, buf.length);
        this.position += len;
    }

    private void writeBase64(byte[] value) {
        if (this.position + (value.length << 1) + 2 >= this.buffer.length) {
            this.enlargeOrFlush(this.position, (value.length << 1) + 2);
        }
        this.buffer[this.position++] = 34;
        this.position += Base64.encodeToBytes(value, this.buffer, this.position);
        this.buffer[this.position++] = 34;
    }

    void writeDouble(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            this.writeAscii("\"Infinity\"");
        } else if (value == Double.NEGATIVE_INFINITY) {
            this.writeAscii("\"-Infinity\"");
        } else if (value != value) {
            this.writeAscii("\"NaN\"");
        } else if (value == 0.0) {
            this.writeAscii("0.0");
        } else if (Grisu3.tryConvert(value, this.doubleBuilder)) {
            if (this.position + 24 >= this.buffer.length) {
                this.enlargeOrFlush(this.position, 24);
            }
            int len = this.doubleBuilder.copyTo(this.buffer, this.position);
            this.position += len;
        } else {
            this.writeAscii(Double.toString(value));
        }
    }

    public String toString() {
        return new String(this.buffer, 0, this.position, UTF_8);
    }

    @Override
    public byte[] toByteArray() {
        if (this.target != null) {
            throw new IllegalStateException("Method is not available when targeting stream");
        }
        return Arrays.copyOf(this.buffer, this.position);
    }

    @Override
    public void markIncomplete() {
        this.incomplete = true;
    }

    @Override
    public void flush() {
        if (this.target != null) {
            try {
                if (this.position != 0) {
                    this.target.writeLast(this.buffer, 0, this.position);
                    this.position = 0;
                }
                this.target.flush();
            }
            catch (IOException ex) {
                throw new JsonIoException("Unable to write to target stream.", ex);
            }
        }
    }

    @Override
    public void close() {
        if (this.incomplete) {
            return;
        }
        this.flush();
    }

    private void prefixName() {
        if (this.lastOp == 4) {
            this.writeByte((byte)44);
        }
        this.lastOp = 3;
        if (this.pretty) {
            this.prettyIndent();
        }
    }

    private void prefixValue() {
        if (this.lastOp == 4) {
            this.writeByte((byte)44);
        }
        if (this.pretty && this.depth > 1) {
            this.prettyIndent();
        }
        this.lastOp = 4;
    }

    @Override
    public void pretty(boolean pretty) {
        this.pretty = pretty;
    }

    private void writeStartObject() {
        if (this.pretty) {
            ++this.depth;
        }
        if (this.lastOp == 4) {
            this.writeByte((byte)44);
        }
        this.writeByte((byte)123);
        this.lastOp = 1;
    }

    @Override
    public void startObject() {
        this.writeStartObject();
        if (this.currentNames != null && !this.allNames) {
            this.nameStack.push(this.currentNames);
            this.currentNames = JsonNames.EMPTY;
        }
    }

    @Override
    public void startObject(JsonNames nextNames) {
        this.writeStartObject();
        if (this.currentNames != null) {
            this.nameStack.push(this.currentNames);
        }
        this.currentNames = nextNames;
    }

    @Override
    public void endObject() {
        if (!this.allNames) {
            this.currentNames = this.nameStack.poll();
        }
        if (this.pretty) {
            --this.depth;
            this.prettyIndent();
        }
        this.writeByte((byte)125);
        this.lastOp = 4;
    }

    @Override
    public void startArray() {
        this.writeByte((byte)91);
        this.lastOp = 1;
        if (this.pretty) {
            ++this.depth;
        }
    }

    @Override
    public void endArray() {
        if (this.pretty) {
            --this.depth;
            this.prettyIndent();
        }
        this.writeByte((byte)93);
        this.lastOp = 4;
    }

    private void prettyIndent() {
        this.writeByte((byte)10);
        for (int i = 0; i < this.depth; ++i) {
            this.writeAscii(INDENT);
        }
    }

    @Override
    public void allNames(JsonNames names) {
        this.allNames = true;
        this.currentNames = names;
    }

    @Override
    public void writeName(int namePos) {
        this.prefixName();
        this.writeAscii(this.currentNames.key(namePos));
        this.writeColon();
    }

    @Override
    public void writeName(String name) {
        this.prefixName();
        this.writeString(name);
        this.writeColon();
    }

    private void writeColon() {
        this.writeByte((byte)58);
        if (this.pretty) {
            this.writeByte((byte)32);
        }
    }

    @Override
    public void writeNull() {
        this.prefixValue();
        this.writeAscii(NULL);
    }

    @Override
    public void write(boolean value) {
        this.prefixValue();
        if (value) {
            this.writeAscii(TRUE);
        } else {
            this.writeAscii(FALSE);
        }
    }

    @Override
    public void write(int value) {
        this.prefixValue();
        NumberWriter.writeInt(value, this);
    }

    @Override
    public void write(long value) {
        this.prefixValue();
        NumberWriter.writeLong(value, this);
    }

    @Override
    public void write(double value) {
        this.prefixValue();
        this.writeDouble(value);
    }

    @Override
    public void write(BigInteger value) {
        this.prefixValue();
        this.writeAscii(value.toString());
    }

    @Override
    public void write(BigDecimal value) {
        this.prefixValue();
        this.writeAscii(value.toString());
    }

    @Override
    public void write(String value) {
        this.prefixValue();
        this.writeString(value);
    }

    @Override
    public void write(byte[] value) {
        this.prefixValue();
        this.writeBase64(value);
    }

    @Override
    public void writeRaw(String value) {
        this.prefixValue();
        this.writeAscii(value);
    }

    @Override
    public void writeNewLine() {
        this.writeByte((byte)10);
        this.lastOp = 0;
    }
}

