/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.stream.core;

import io.avaje.json.stream.JsonOutput;
import io.avaje.json.stream.core.BufferRecycler;
import io.avaje.json.stream.core.JGenerator;
import io.avaje.json.stream.core.JParser;
import io.avaje.json.stream.core.JsonGenerator;
import io.avaje.json.stream.core.JsonParser;
import io.avaje.json.stream.core.Recyclers;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Predicate;

final class HybridBufferRecycler
implements BufferRecycler {
    private static final HybridBufferRecycler INSTANCE = new HybridBufferRecycler();
    private static final Predicate<Thread> isVirtual = VirtualPredicate.access$000();
    private static final BufferRecycler NATIVE_RECYCLER = Recyclers.ThreadLocalPool.shared();
    private static final BufferRecycler VIRTUAL_RECYCLER = StripedLockFreePool.shared();
    private static final int MAX_POW2 = 0x40000000;

    private HybridBufferRecycler() {
    }

    static HybridBufferRecycler shared() {
        return INSTANCE;
    }

    @Override
    public JsonGenerator generator(JsonOutput target) {
        return isVirtual.test(Thread.currentThread()) ? VIRTUAL_RECYCLER.generator(target) : NATIVE_RECYCLER.generator(target);
    }

    @Override
    public JsonParser parser(byte[] bytes) {
        return isVirtual.test(Thread.currentThread()) ? VIRTUAL_RECYCLER.parser(bytes) : NATIVE_RECYCLER.parser(bytes);
    }

    @Override
    public JsonParser parser(InputStream in) {
        return isVirtual.test(Thread.currentThread()) ? VIRTUAL_RECYCLER.parser(in) : NATIVE_RECYCLER.parser(in);
    }

    @Override
    public void recycle(JsonGenerator recycler) {
        if (recycler instanceof VThreadJGenerator) {
            VIRTUAL_RECYCLER.recycle(recycler);
        }
    }

    @Override
    public void recycle(JsonParser recycler) {
        if (recycler instanceof VThreadJParser) {
            VIRTUAL_RECYCLER.recycle(recycler);
        }
    }

    private static int roundToPowerOfTwo(int value) {
        if (value > 0x40000000) {
            throw new IllegalArgumentException("Exceeded max power of 2 (2^31), got " + value);
        }
        if (value < 0) {
            throw new IllegalArgumentException("Expecting value >= 0, got " + value);
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    private static final class VThreadJGenerator
    extends JGenerator {
        private final int slot;

        private VThreadJGenerator(int slot) {
            super(Recyclers.GENERATOR_BUFFER_SIZE);
            this.slot = slot;
        }
    }

    private static final class VThreadJParser
    extends JParser {
        private final int slot;

        private VThreadJParser(int slot) {
            super(new char[Recyclers.PARSER_CHAR_BUFFER_SIZE], new byte[Recyclers.PARSER_BUFFER_SIZE], 0, JParser.ErrorInfo.MINIMAL, JParser.DoublePrecision.DEFAULT, JParser.UnknownNumberParsing.BIGDECIMAL, 100, 50000);
            this.slot = slot;
        }
    }

    private static final class VirtualPredicate {
        private static final MethodHandle virtualMh = VirtualPredicate.findVirtualMH();

        private VirtualPredicate() {
        }

        private static MethodHandle findVirtualMH() {
            try {
                return MethodHandles.publicLookup().findVirtual(Thread.class, "isVirtual", MethodType.methodType(Boolean.TYPE));
            }
            catch (Exception e) {
                return null;
            }
        }

        private static Predicate<Thread> findIsVirtualPredicate() {
            return virtualMh == null ? VirtualPredicate::notVirtual : VirtualPredicate::isVirtual;
        }

        private static boolean isVirtual(Thread thread) {
            try {
                return virtualMh.invokeExact(thread);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        private static boolean notVirtual(Thread thread) {
            return false;
        }

        static /* synthetic */ Predicate access$000() {
            return VirtualPredicate.findIsVirtualPredicate();
        }
    }

    static final class StripedLockFreePool
    implements BufferRecycler {
        private static final StripedLockFreePool INSTANCE = new StripedLockFreePool(Runtime.getRuntime().availableProcessors());
        private static final int CACHE_LINE_SHIFT = 4;
        private static final int CACHE_LINE_PADDING = 16;
        private final XorShiftThreadProbe threadProbe;
        private final AtomicReferenceArray<JNode> generatorStacks;
        private final AtomicReferenceArray<PNode> parserStacks;

        private StripedLockFreePool(int stripesCount) {
            int size = HybridBufferRecycler.roundToPowerOfTwo(stripesCount);
            this.generatorStacks = new AtomicReferenceArray(size * 16);
            this.parserStacks = new AtomicReferenceArray(size * 16);
            int mask = size - 1 << 4;
            this.threadProbe = new XorShiftThreadProbe(mask);
        }

        static StripedLockFreePool shared() {
            return INSTANCE;
        }

        @Override
        public JsonParser parser(byte[] bytes) {
            return this.parser().process(bytes, bytes.length);
        }

        @Override
        public JsonParser parser(InputStream in) {
            return this.parser().process(in);
        }

        @Override
        public JsonGenerator generator(JsonOutput target) {
            int index = this.threadProbe.index();
            JNode currentHead = this.generatorStacks.get(index);
            while (currentHead != null) {
                if (this.generatorStacks.compareAndSet(index, currentHead, currentHead.next)) {
                    currentHead.next = null;
                    return currentHead.value.prepare(target);
                }
                currentHead = this.generatorStacks.get(index);
            }
            return new VThreadJGenerator(index).prepare(target);
        }

        private JsonParser parser() {
            int index = this.threadProbe.index();
            PNode currentHead = this.parserStacks.get(index);
            while (currentHead != null) {
                if (this.parserStacks.compareAndSet(index, currentHead, currentHead.next)) {
                    currentHead.next = null;
                    return currentHead.value;
                }
                currentHead = this.parserStacks.get(index);
            }
            return new VThreadJParser(index);
        }

        @Override
        public void recycle(JsonGenerator recycler) {
            VThreadJGenerator vThreadBufferRecycler = (VThreadJGenerator)recycler;
            JNode newHead = new JNode(vThreadBufferRecycler);
            JNode next = this.generatorStacks.get(vThreadBufferRecycler.slot);
            while (true) {
                int n = newHead.level = next == null ? 1 : next.level + 1;
                if (this.generatorStacks.compareAndSet(vThreadBufferRecycler.slot, next, newHead)) {
                    newHead.next = next;
                    return;
                }
                next = this.generatorStacks.get(vThreadBufferRecycler.slot);
            }
        }

        @Override
        public void recycle(JsonParser recycler) {
            VThreadJParser vThreadBufferRecycler = (VThreadJParser)recycler;
            PNode newHead = new PNode(vThreadBufferRecycler);
            PNode next = this.parserStacks.get(vThreadBufferRecycler.slot);
            while (true) {
                int n = newHead.level = next == null ? 1 : next.level + 1;
                if (this.parserStacks.compareAndSet(vThreadBufferRecycler.slot, next, newHead)) {
                    newHead.next = next;
                    return;
                }
                next = this.parserStacks.get(vThreadBufferRecycler.slot);
            }
        }

        private static final class JNode {
            final VThreadJGenerator value;
            JNode next;
            int level = 0;

            JNode(VThreadJGenerator value) {
                this.value = value;
            }
        }

        private static final class PNode {
            final VThreadJParser value;
            PNode next;
            int level = 0;

            PNode(VThreadJParser value) {
                this.value = value;
            }
        }
    }

    private static final class XorShiftThreadProbe {
        private final int mask;

        XorShiftThreadProbe(int mask) {
            this.mask = mask;
        }

        public int index() {
            return this.probe() & this.mask;
        }

        private int probe() {
            int probe = (int)(Thread.currentThread().getId() * -1640531527L & Integer.MAX_VALUE);
            probe ^= probe << 13;
            probe ^= probe >>> 17;
            probe ^= probe << 5;
            return probe;
        }
    }
}

