/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.core;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;

final class ArrayAdapter
implements JsonAdapter<Object> {
    private final Class<?> elementClass;
    private final JsonAdapter<Object> elementAdapter;

    static JsonAdapter<Object> create(Class<?> elementClass, JsonAdapter<Object> elementAdapter) {
        return new ArrayAdapter(elementClass, elementAdapter).nullSafe();
    }

    static JsonAdapter<byte[]> byteArray() {
        return new ByteArray();
    }

    ArrayAdapter(Class<?> elementClass, JsonAdapter<Object> elementAdapter) {
        this.elementClass = elementClass;
        this.elementAdapter = elementAdapter;
    }

    @Override
    public Object fromJson(JsonReader reader) {
        ArrayList<Object> list = new ArrayList<Object>();
        reader.beginArray();
        while (reader.hasNextElement()) {
            list.add(this.elementAdapter.fromJson(reader));
        }
        reader.endArray();
        Object array = Array.newInstance(this.elementClass, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }

    @Override
    public void toJson(JsonWriter writer, Object value) {
        writer.beginArray();
        int size = Array.getLength(value);
        for (int i = 0; i < size; ++i) {
            this.elementAdapter.toJson(writer, Array.get(value, i));
        }
        writer.endArray();
    }

    public String toString() {
        return this.elementAdapter + ".array()";
    }

    private static final class ByteArray
    implements JsonAdapter<byte[]> {
        private ByteArray() {
        }

        @Override
        public byte[] fromJson(JsonReader reader) {
            return reader.readBinary();
        }

        @Override
        public void toJson(JsonWriter writer, byte[] value) {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(byte[])";
        }
    }
}

