package io.avaje.jex.core;

public final class Constants {

  private Constants() {}

  public static final String ACCEPT = "Accept";
  public static final String CONTENT_ENCODING = "Content-encoding";
  public static final String CONTENT_LENGTH = "Content-length";
  public static final String CONTENT_TYPE = "Content-type";
  public static final String LOCATION = "Location";
  public static final String HOST = "Host";
  public static final String USER_AGENT = "User-agent";
  public static final String ACCEPT_ENCODING = "Accept-encoding";

  public static final String TEXT_HTML = "text/html";
  public static final String TEXT_PLAIN = "text/plain";
  public static final String TEXT_HTML_UTF8 = "text/html;charset=utf-8";
  public static final String TEXT_PLAIN_UTF8 = "text/plain;charset=utf-8";
  public static final String APPLICATION_JSON = "application/json";
  public static final String APPLICATION_X_JSON_STREAM = "application/x-json-stream";

  // range
  public static final String ACCEPT_RANGES = "Accept-ranges";
  public static final String RANGE = "Range";
  public static final String CONTENT_RANGE = "Content-range";
}
