/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.Jex;
import io.avaje.jex.Routing;
import io.avaje.jex.compression.CompressedOutputStream;
import io.avaje.jex.compression.CompressionConfig;
import io.avaje.jex.core.BufferedOutStream;
import io.avaje.jex.core.CoreServiceLoader;
import io.avaje.jex.core.ExceptionManager;
import io.avaje.jex.core.JdkContext;
import io.avaje.jex.core.TemplateManager;
import io.avaje.jex.core.json.JacksonJsonService;
import io.avaje.jex.core.json.JsonbJsonService;
import io.avaje.jex.http.Context;
import io.avaje.jex.routes.UrlDecode;
import io.avaje.jex.spi.JsonService;
import io.avaje.jex.spi.TemplateRender;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

final class ServiceManager {
    private static final System.Logger log = System.getLogger("io.avaje.jex");
    private final CompressionConfig compressionConfig;
    private final JsonService jsonService;
    private final ExceptionManager exceptionHandler;
    private final TemplateManager templateManager;
    private final String scheme;
    private final int bufferInitial;
    private final long bufferMax;

    static ServiceManager create(Jex jex) {
        return new Builder(jex).build();
    }

    ServiceManager(CompressionConfig compressionConfig, JsonService jsonService, ExceptionManager manager, TemplateManager templateManager, String scheme, long bufferMax, int bufferInitial) {
        this.compressionConfig = compressionConfig;
        this.jsonService = jsonService;
        this.exceptionHandler = manager;
        this.templateManager = templateManager;
        this.scheme = scheme;
        this.bufferInitial = bufferInitial;
        this.bufferMax = bufferMax;
    }

    OutputStream createOutputStream(JdkContext jdkContext) {
        BufferedOutStream out = new BufferedOutStream(jdkContext, this.bufferInitial, this.bufferMax);
        if (this.compressionConfig.compressionEnabled()) {
            return new CompressedOutputStream(this.compressionConfig, jdkContext, out);
        }
        return out;
    }

    JsonService jsonService() {
        return this.jsonService;
    }

    <T> T fromJson(Type type, InputStream is) {
        return this.jsonService.fromJson(type, is);
    }

    <T> T fromJson(Type type, byte[] data) {
        return this.jsonService.fromJson(type, data);
    }

    void toJson(Object bean, OutputStream os) {
        this.jsonService.toJson(bean, os);
    }

    <E> void toJsonStream(Stream<E> stream, OutputStream os) {
        try (Stream<E> stream2 = stream;){
            this.jsonService.toJsonStream(stream.iterator(), os);
        }
    }

    <E> void toJsonStream(Iterator<E> iterator, OutputStream os) {
        try {
            this.jsonService.toJsonStream(iterator, os);
        }
        finally {
            this.maybeClose(iterator);
        }
    }

    void maybeClose(Object iterator) {
        if (iterator instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)iterator;
            try {
                closeable.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Error closing iterator " + String.valueOf(iterator), e);
            }
        }
    }

    Routing.Type lookupRoutingType(String method) {
        try {
            return Routing.Type.valueOf(method);
        }
        catch (Exception e) {
            return null;
        }
    }

    void handleException(JdkContext ctx, Exception t) {
        this.exceptionHandler.handle(ctx, t);
    }

    void render(Context ctx, String name, Map<String, Object> model) {
        this.templateManager.render(ctx, name, model);
    }

    Charset requestCharset(Context ctx) {
        return ServiceManager.parseCharset(ctx.header("Content-type"));
    }

    static Charset parseCharset(String header) {
        if (header != null) {
            for (String val : header.split(";")) {
                if (!(val = val.trim()).regionMatches(true, 0, "charset", 0, "charset".length())) continue;
                return Charset.forName(val.split("=")[1].trim());
            }
        }
        return StandardCharsets.UTF_8;
    }

    Map<String, List<String>> formParamMap(Context ctx, Charset charset) {
        return this.parseParamMap(ctx.body(), charset);
    }

    Map<String, List<String>> parseParamMap(String body, Charset charset) {
        if (body == null || body.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        for (String pair : body.split("&")) {
            String[] split1 = pair.split("=", 2);
            String key = UrlDecode.decode(split1[0], charset);
            String val = split1.length > 1 ? UrlDecode.decode(split1[1], charset) : "";
            map.computeIfAbsent(key, s -> new ArrayList()).add(val);
        }
        return map;
    }

    String scheme() {
        return this.scheme;
    }

    private static final class Builder {
        private final Jex jex;

        Builder(Jex jex) {
            this.jex = jex;
        }

        ServiceManager build() {
            return new ServiceManager(this.jex.config().compression(), this.initJsonService(), new ExceptionManager(this.jex.routing().errorHandlers()), this.initTemplateMgr(), this.jex.config().scheme(), this.jex.config().maxStreamBufferSize(), this.jex.config().initialStreamBufferSize());
        }

        JsonService initJsonService() {
            JsonService jsonService = this.jex.config().jsonService();
            if (jsonService != null) {
                return jsonService;
            }
            JsonService json = CoreServiceLoader.jsonService().orElseGet(this::defaultJsonService);
            if (json == null) {
                log.log(System.Logger.Level.WARNING, "No Json library configured");
            }
            return json;
        }

        JsonService defaultJsonService() {
            if (this.detectJsonb()) {
                return new JsonbJsonService();
            }
            return this.detectJackson() ? new JacksonJsonService() : null;
        }

        boolean detectJackson() {
            return this.detectTypeExists("com.fasterxml.jackson.databind.ObjectMapper");
        }

        boolean detectJsonb() {
            return this.detectTypeExists("io.avaje.jsonb.Jsonb");
        }

        private boolean detectTypeExists(String className) {
            try {
                Class.forName(className);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        TemplateManager initTemplateMgr() {
            TemplateManager mgr = new TemplateManager();
            mgr.register(this.jex.config().renderers());
            for (TemplateRender render : CoreServiceLoader.getRenders()) {
                mgr.registerDefault(render);
            }
            return mgr;
        }
    }
}

