/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.inject.BeanScope;
import io.avaje.jex.AppLifecycle;
import io.avaje.jex.DJexConfig;
import io.avaje.jex.DefaultLifecycle;
import io.avaje.jex.DefaultRouting;
import io.avaje.jex.Jex;
import io.avaje.jex.JexConfig;
import io.avaje.jex.Routing;
import io.avaje.jex.core.BootstrapServer;
import io.avaje.jex.spi.JexPlugin;
import io.avaje.jex.spi.JsonService;
import io.avaje.jex.spi.TemplateRender;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

final class DJex
implements Jex {
    private final Routing routing = new DefaultRouting();
    private final AppLifecycle lifecycle = new DefaultLifecycle();
    private final Map<Class<?>, Object> attributes = new HashMap();
    private final DJexConfig config = new DJexConfig();

    DJex() {
    }

    @Override
    public DJexConfig config() {
        return this.config;
    }

    @Override
    public <T> Jex attribute(Class<T> cls, T instance) {
        this.attributes.put(cls, instance);
        return this;
    }

    @Override
    public <T> T attribute(Class<T> cls) {
        return (T)this.attributes.get(cls);
    }

    @Override
    public Jex routing(Routing.HttpService routes) {
        this.routing.add(routes);
        return this;
    }

    @Override
    public Jex routing(Collection<Routing.HttpService> routes) {
        this.routing.addAll(routes);
        return this;
    }

    @Override
    public Routing routing() {
        return this.routing;
    }

    @Override
    public Jex jsonService(JsonService jsonService) {
        this.config.jsonService(jsonService);
        return this;
    }

    @Override
    public Jex plugin(JexPlugin plugin) {
        plugin.apply(this);
        return this;
    }

    @Override
    public Jex configureWith(BeanScope beanScope) {
        this.lifecycle.onShutdown(() -> ((BeanScope)beanScope).close());
        for (JexPlugin plugin : beanScope.list(JexPlugin.class)) {
            plugin.apply(this);
        }
        this.routing.addAll(beanScope.list(Routing.HttpService.class));
        beanScope.getOptional(JsonService.class).ifPresent(this::jsonService);
        return this;
    }

    @Override
    public Jex configure(Consumer<JexConfig> configure) {
        configure.accept(this.config);
        return this;
    }

    @Override
    public Jex port(int port) {
        this.config.port(port);
        return this;
    }

    @Override
    public Jex context(String contextPath) {
        this.config.contextPath(contextPath);
        return this;
    }

    @Override
    public Jex register(TemplateRender renderer, String ... extensions) {
        for (String extension : extensions) {
            this.config.renderer(extension, renderer);
        }
        return this;
    }

    @Override
    public AppLifecycle lifecycle() {
        return this.lifecycle;
    }

    @Override
    public Jex.Server start() {
        return BootstrapServer.start(this);
    }
}

