/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import io.avaje.jex.routes.PathSegment;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Pattern;

final class RegBuilder {
    private final StringJoiner full = new StringJoiner("/");
    private final StringJoiner extract = new StringJoiner("/");
    private boolean trailingSlash;
    private boolean multiSlash;
    private boolean literal = true;

    RegBuilder() {
    }

    void add(PathSegment pathSegment, List<String> paramNames) {
        this.full.add(pathSegment.asRegexString(false));
        this.extract.add(pathSegment.asRegexString(true));
        pathSegment.addParamName(paramNames);
        if (!this.multiSlash) {
            this.multiSlash = pathSegment.multiSlash();
        }
        if (this.literal && !pathSegment.literal()) {
            this.literal = false;
        }
    }

    void trailingSlash() {
        this.trailingSlash = true;
    }

    Pattern matchRegex() {
        return Pattern.compile(this.wrap(this.full.toString()));
    }

    Pattern extractRegex() {
        return Pattern.compile(this.wrap(this.extract.toString()));
    }

    private String wrap(String parts) {
        if (this.trailingSlash) {
            parts = (String)parts + "\\/";
        }
        return "^/" + (String)parts + "/?$";
    }

    boolean multiSlash() {
        return this.multiSlash;
    }

    boolean literal() {
        return this.literal;
    }
}

