/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.jdk;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.avaje.jex.HttpFilter;
import io.avaje.jex.Routing;
import io.avaje.jex.compression.CompressionConfig;
import io.avaje.jex.http.NotFoundException;
import io.avaje.jex.jdk.BaseFilterChain;
import io.avaje.jex.jdk.CtxServiceManager;
import io.avaje.jex.jdk.JdkContext;
import io.avaje.jex.jdk.Mode;
import io.avaje.jex.routes.SpiRoutes;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RoutingHandler
implements HttpHandler {
    private final SpiRoutes routes;
    private final CtxServiceManager mgr;
    private final CompressionConfig compressionConfig;
    private final List<HttpFilter> filters;

    RoutingHandler(SpiRoutes routes, CtxServiceManager mgr, CompressionConfig compressionConfig) {
        this.mgr = mgr;
        this.routes = routes;
        this.filters = routes.filters();
        this.compressionConfig = compressionConfig;
    }

    void waitForIdle(long maxSeconds) {
        this.routes.waitForIdle(maxSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) {
        String uri = exchange.getRequestURI().getPath();
        Routing.Type routeType = this.mgr.lookupRoutingType(exchange.getRequestMethod());
        SpiRoutes.Entry route = this.routes.match(routeType, uri);
        if (route == null) {
            JdkContext ctx = new JdkContext(this.mgr, this.compressionConfig, exchange, uri, Set.of());
            this.handleException(ctx, new NotFoundException("uri: " + uri));
        } else {
            route.inc();
            try {
                Map<String, String> params = route.pathParams(uri);
                JdkContext ctx = new JdkContext(this.mgr, this.compressionConfig, exchange, route.matchPath(), params, route.roles());
                try {
                    ctx.setMode(Mode.BEFORE);
                    new BaseFilterChain(this.filters, route.handler(), ctx).proceed();
                    this.handleNoResponse(exchange);
                }
                catch (Exception e) {
                    this.handleException(ctx, e);
                }
            }
            finally {
                route.dec();
                exchange.close();
            }
        }
    }

    private void handleNoResponse(HttpExchange exchange) throws IOException {
        if (exchange.getResponseCode() == -1) {
            exchange.sendResponseHeaders(204, -1L);
        }
    }

    private void handleException(JdkContext ctx, Exception e) {
        this.mgr.handleException(ctx, e);
    }
}

