/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.applog.AppLog;
import io.avaje.jex.Context;
import io.avaje.jex.ExceptionHandler;
import io.avaje.jex.http.ErrorCode;
import io.avaje.jex.http.HttpResponseException;
import io.avaje.jex.http.InternalServerErrorException;
import io.avaje.jex.jdk.JdkContext;
import java.util.Map;

public final class ExceptionManager {
    private static final String APPLICATION_JSON = "application/json";
    private static final System.Logger log = AppLog.getLogger((String)"io.avaje.jex");
    private final Map<Class<?>, ExceptionHandler<?>> handlers;

    public ExceptionManager(Map<Class<?>, ExceptionHandler<?>> handlers) {
        this.handlers = handlers;
    }

    public <T extends Exception> ExceptionHandler<Exception> find(Class<T> exceptionType) {
        Class<T> type = exceptionType;
        do {
            ExceptionHandler<Exception> handler;
            if ((handler = this.handlers.get(type)) == null) continue;
            return handler;
        } while ((type = type.getSuperclass()) != null);
        return null;
    }

    void handle(JdkContext ctx, Exception e) {
        ExceptionHandler<Exception> handler = this.find(e.getClass());
        if (handler != null) {
            try {
                handler.handle(ctx, e);
            }
            catch (Exception ex) {
                this.unhandledException(ctx, ex);
            }
        } else if (e instanceof HttpResponseException) {
            HttpResponseException ex = (HttpResponseException)e;
            this.defaultHandling(ctx, ex);
        } else {
            this.unhandledException(ctx, e);
        }
    }

    private void unhandledException(JdkContext ctx, Exception e) {
        log.log(System.Logger.Level.WARNING, "Uncaught exception", (Throwable)e);
        this.defaultHandling(ctx, new InternalServerErrorException(ErrorCode.INTERNAL_SERVER_ERROR.message()));
    }

    private void defaultHandling(JdkContext ctx, HttpResponseException exception) {
        ctx.status(exception.getStatus());
        if (exception.getStatus() == ErrorCode.REDIRECT.status()) {
            ctx.performRedirect();
        } else if (this.useJson(ctx)) {
            ctx.contentType(APPLICATION_JSON).write(this.asJsonContent(exception));
        } else {
            ctx.text(exception.getMessage());
        }
    }

    private String asJsonContent(HttpResponseException e) {
        return "{\"title\": " + this.jsonEscape(e.getMessage()) + ", \"status\": " + e.getStatus() + "}";
    }

    private String jsonEscape(String message) {
        return message;
    }

    private boolean useJson(Context ctx) {
        String acceptHeader = ctx.header("Accept");
        return acceptHeader != null && acceptHeader.contains(APPLICATION_JSON) || APPLICATION_JSON.equals(ctx.responseHeader("Content-Type"));
    }
}

