/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.compression;

import io.avaje.jex.compression.CompressionConfig;
import io.avaje.jex.compression.Compressor;
import io.avaje.jex.http.Context;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class CompressedOutputStream
extends OutputStream {
    private final int minSizeForCompression;
    private final CompressionConfig compression;
    private final Context ctx;
    private final OutputStream originStream;
    private OutputStream compressedStream;
    private boolean compressionDecided;

    public CompressedOutputStream(CompressionConfig compression, Context ctx, OutputStream originStream) {
        this.minSizeForCompression = compression.minSizeForCompression();
        this.compression = compression;
        this.ctx = ctx;
        this.originStream = originStream;
    }

    private void decideCompression(int length) throws IOException {
        if (!this.compressionDecided) {
            Optional<Compressor> compressor;
            boolean compressionAllowed;
            boolean bl = compressionAllowed = this.compressedStream == null && this.compression.allowsForCompression(this.ctx.responseHeader("Content-type"));
            if (compressionAllowed && length >= this.minSizeForCompression && (compressor = this.findMatchingCompressor(this.ctx.headerValues("Accept-encoding"))).isPresent()) {
                this.compressedStream = compressor.get().compress(this.originStream);
                this.ctx.header("Content-encoding", compressor.get().encoding());
            }
            this.compressionDecided = true;
        }
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.decideCompression(length);
        (this.compressedStream != null ? this.compressedStream : this.originStream).write(bytes, offset, length);
    }

    @Override
    public void write(int byteVal) throws IOException {
        this.decideCompression(1);
        (this.compressedStream != null ? this.compressedStream : this.originStream).write(byteVal);
    }

    @Override
    public void close() throws IOException {
        if (this.compressedStream != null) {
            this.compressedStream.close();
        }
        this.originStream.close();
    }

    private Optional<Compressor> findMatchingCompressor(List<String> acceptedEncoding) {
        if (acceptedEncoding != null) {
            Stream stream = acceptedEncoding.size() > 1 ? acceptedEncoding.stream() : Arrays.stream(acceptedEncoding.getFirst().split(","));
            return stream.map(e -> e.trim().split(";")[0]).map(e -> "*".equals(e) ? "gzip" : e.toLowerCase()).map(this.compression::forType).filter(Objects::nonNull).findFirst();
        }
        return Optional.empty();
    }
}

