/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.inject.BeanScope;
import io.avaje.jex.AppLifecycle;
import io.avaje.jex.DJex;
import io.avaje.jex.JexConfig;
import io.avaje.jex.Routing;
import io.avaje.jex.http.Context;
import io.avaje.jex.http.ExceptionHandler;
import io.avaje.jex.http.ExchangeHandler;
import io.avaje.jex.http.HttpFilter;
import io.avaje.jex.http.sse.SseClient;
import io.avaje.jex.security.Role;
import io.avaje.jex.spi.JexPlugin;
import io.avaje.jex.spi.JsonService;
import io.avaje.jex.spi.TemplateRender;
import java.util.Collection;
import java.util.function.Consumer;

public interface Jex {
    public static Jex create() {
        return new DJex();
    }

    public Jex routing(Routing.HttpService var1);

    public Jex routing(Collection<Routing.HttpService> var1);

    public Routing routing();

    default public Jex get(String path, ExchangeHandler handler, Role ... roles) {
        this.routing().get(path, handler, roles);
        return this;
    }

    default public Jex post(String path, ExchangeHandler handler, Role ... roles) {
        this.routing().post(path, handler, roles);
        return this;
    }

    default public Jex put(String path, ExchangeHandler handler, Role ... roles) {
        this.routing().put(path, handler, roles);
        return this;
    }

    default public Jex patch(String path, ExchangeHandler handler, Role ... roles) {
        this.routing().patch(path, handler, roles);
        return this;
    }

    default public Jex delete(String path, ExchangeHandler handler, Role ... roles) {
        this.routing().delete(path, handler, roles);
        return this;
    }

    default public Jex options(String path, ExchangeHandler handler, Role ... roles) {
        this.routing().options(path, handler, roles);
        return this;
    }

    default public Jex sse(String path, Consumer<SseClient> handler, Role ... roles) {
        return this.get(path, SseClient.handler(handler), roles);
    }

    default public Jex filter(HttpFilter handler) {
        this.routing().filter(handler);
        return this;
    }

    default public Jex before(Consumer<Context> handler) {
        this.routing().before(handler);
        return this;
    }

    default public Jex after(Consumer<Context> handler) {
        this.routing().after(handler);
        return this;
    }

    default public <T extends Exception> Jex error(Class<T> exceptionClass, ExceptionHandler<T> handler) {
        this.routing().error(exceptionClass, handler);
        return this;
    }

    default public Jex group(String path, Routing.HttpService group) {
        this.routing().group(path, group);
        return this;
    }

    public Jex jsonService(JsonService var1);

    public Jex plugin(JexPlugin var1);

    public Jex configureWith(BeanScope var1);

    public Jex config(Consumer<JexConfig> var1);

    public Jex port(int var1);

    public Jex contextPath(String var1);

    public Jex register(TemplateRender var1, String ... var2);

    public AppLifecycle lifecycle();

    public JexConfig config();

    public Server start();

    public static interface Server {
        public void onShutdown(Runnable var1);

        public void shutdown();

        public int port();
    }
}

