package io.avaje.jex.http;

/** Http Error Status codes */
public enum HttpStatus {

  // 1xx Informational
  CONTINUE_100(100),
  SWITCHING_PROTOCOLS_101(101),

  // 2xx Success
  OK_200(200),
  CREATED_201(201),
  ACCEPTED_202(202),
  NON_AUTHORITATIVE_INFORMATION_203(203),
  NO_CONTENT_204(204),
  RESET_CONTENT_205(205),
  PARTIAL_CONTENT_206(206),
  MULTI_STATUS_207(207),

  // 3xx Redirection
  MOVED_PERMANENTLY_301(301),
  FOUND_302(302),
  SEE_OTHER_303(303),
  NOT_MODIFIED_304(304),
  USE_PROXY_305(305),
  TEMPORARY_REDIRECT_307(307),
  PERMANENT_REDIRECT_308(308),

  // 4xx Client Error
  BAD_REQUEST_400(400),
  UNAUTHORIZED_401(401),
  PAYMENT_REQUIRED_402(402),
  FORBIDDEN_403(403),
  NOT_FOUND_404(404),
  METHOD_NOT_ALLOWED_405(405),
  NOT_ACCEPTABLE_406(406),
  PROXY_AUTHENTICATION_REQUIRED_407(407),
  REQUEST_TIMEOUT_408(408),
  CONFLICT_409(409),
  GONE_410(410),
  LENGTH_REQUIRED_411(411),
  PRECONDITION_FAILED_412(412),
  REQUEST_ENTITY_TOO_LARGE_413(413),
  REQUEST_URI_TOO_LONG_414(414),
  UNSUPPORTED_MEDIA_TYPE_415(415),
  REQUESTED_RANGE_NOT_SATISFIABLE_416(416),
  EXPECTATION_FAILED_417(417),
  I_AM_A_TEAPOT_418(418),
  MISDIRECTED_REQUEST_421(421),
  UNPROCESSABLE_CONTENT_422(422),
  LOCKED_423(423),
  FAILED_DEPENDENCY_424(424),
  UPGRADE_REQUIRED_426(426),
  PRECONDITION_REQUIRED_428(428),
  TOO_MANY_REQUESTS_429(429),

  // 5xx Server Error
  INTERNAL_SERVER_ERROR_500(500),
  NOT_IMPLEMENTED_501(501),
  BAD_GATEWAY_502(502),
  SERVICE_UNAVAILABLE_503(503),
  GATEWAY_TIMEOUT_504(504),
  HTTP_VERSION_NOT_SUPPORTED_505(505),
  INSUFFICIENT_STORAGE_507(507),
  LOOP_DETECTED_508(508),
  NOT_EXTENDED_510(510),
  NETWORK_AUTHENTICATION_REQUIRED_511(511);

  private final int status;

  HttpStatus(int status) {
    this.status = status;
  }

  public int status() {
    return status;
  }
}
